/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.monitor.Monitor;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public abstract class Control {
    protected static final int DEFAULT_SIZE = 15;
    protected static float[] ambient = new float[]{0.329412f, 0.223529f, 0.027451f, 1.0f};
    protected static float[] diffuse = new float[]{0.780392f, 0.568627f, 0.113725f, 1.0f};
    protected static float[] specular = new float[]{0.992157f, 0.941176f, 0.807843f, 1.0f};
    protected static float shininess = 27.8974f;
    protected double x;
    protected double y;
    protected int size = 15;
    protected float[] center = null;
    protected Monitor monitor = null;
    protected GraphicComponent component = null;

    public float[] getCenter() {
        return this.center;
    }

    public void setCenter(float[] center) {
        this.center = center;
    }

    public void setComponent(GraphicComponent gc) {
        this.component = gc;
    }

    abstract void draw(GL var1, GLU var2);

    abstract void drawAxes(GL var1);

    public abstract void control(int var1, int var2);

    public abstract void control(int var1);

    boolean pick(int x, int y) {
        return Math.abs(this.x - (double)x) < (double)this.size && Math.abs(this.y - (double)y) < (double)this.size;
    }

    protected void projectVector(float[] vector3) {
        this.monitor.projectVector(vector3);
    }

    public abstract byte[] getColor();
}

