/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.MoleculeComponent;
import chemaxon.marvin.space.monitor.Control;
import chemaxon.marvin.space.monitor.DihedralMonitor;
import chemaxon.marvin.space.util.GraphPartitions;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class DihedralControl
extends Control {
    protected int atomA;
    protected int atomB;
    protected int center;
    protected int bond;
    private GraphPartitions gp = new GraphPartitions();
    private boolean canControl = false;
    boolean flipped = false;

    public DihedralControl(DihedralMonitor monitor) {
        this.monitor = monitor;
    }

    public void finalize() {
        GeomCalc.deleteVector(this.center);
        GeomCalc.deleteVector(this.bond);
    }

    public void setAtoms(int atomA, int atomB) {
        this.atomA = atomA;
        this.atomB = atomB;
        this.canControl = this.gp.partition(this.atomA, this.atomB);
        MoleculeComponent mc = (MoleculeComponent)this.component;
        int a = GeomCalc.newVector(mc.getAtomProperty().getX(atomA), mc.getAtomProperty().getY(atomA), mc.getAtomProperty().getZ(atomA));
        int b = GeomCalc.newVector(mc.getAtomProperty().getX(atomB), mc.getAtomProperty().getY(atomB), mc.getAtomProperty().getZ(atomB));
        this.bond = GeomCalc.sub(b, a);
        GeomCalc.normalize(this.bond);
        this.center = GeomCalc.add(a, b);
        GeomCalc.scale(this.center, 0.5f);
        GeomCalc.deleteVector(a);
        GeomCalc.deleteVector(b);
    }

    public void flip() {
        this.flipped = !this.flipped;
    }

    @Override
    public void setComponent(GraphicComponent gc) {
        this.component = (MoleculeComponent)gc;
        this.gp.setGraph(((MoleculeComponent)gc).getMolecule().getCtab());
    }

    @Override
    public void control(int v) {
        if (!this.canControl) {
            return;
        }
        MoleculeComponent mc = (MoleculeComponent)this.component;
        if (this.flipped) {
            mc.torsion(v, GeomCalc.getVector(this.bond), GeomCalc.getVector(this.center), this.gp.getSecondPartition());
        } else {
            mc.torsion(v, GeomCalc.getVector(this.bond), GeomCalc.getVector(this.center), this.gp.getFirstPartition());
        }
        if (mc.getMacroMoleculeComponent() != null) {
            mc.getMacroMoleculeComponent().notifyCoordinateChange();
        }
    }

    @Override
    public void control(int x, int y) {
    }

    @Override
    void draw(GL gl, GLU glu) {
    }

    @Override
    void drawAxes(GL gl) {
    }

    @Override
    public byte[] getColor() {
        if (((DihedralMonitor)this.monitor).label != null) {
            byte[] lc = ((DihedralMonitor)this.monitor).label.getForegroundColor();
            byte[] b = Colors.brighter(lc);
            return Colors.equals(b, lc) ? Colors.darker(lc) : b;
        }
        return Colors.yellow;
    }
}

