/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.monitor.MeasurementMonitor;

public class DistanceMonitor
extends MeasurementMonitor {
    private static final int ITEM_COUNT = 2;

    public DistanceMonitor() {
        this.measure = "\u00c5";
    }

    @Override
    public int maximumItemCount() {
        return 2;
    }

    @Override
    public double measurement() {
        if (this.measurement != -1.0) {
            return this.measurement;
        }
        this.measurement = GeomCalc.distance(this.selectedItemCoordinates[0], this.selectedItemCoordinates[1]);
        return this.measurement;
    }

    @Override
    public void draw() {
        if (!this.visible || this.hasInvisibleItem()) {
            return;
        }
        this.gl.glDisable(2896);
        this.gl.glEnable(3042);
        this.gl.glLineWidth(4.0f);
        this.gl.glColor3bv(Colors.black, 0);
        this.gl.glBegin(1);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[0]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[1]), 0);
        this.gl.glEnd();
        this.gl.glLineWidth(2.0f);
        this.gl.glColor3bv(this.getMonitorColor(), 0);
        this.gl.glBegin(1);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[0]), 0);
        this.gl.glVertex3fv(GeomCalc.getVector(this.selectedItemCoordinates[1]), 0);
        this.gl.glEnd();
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }
}

