/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.monitor.Control;
import chemaxon.marvin.space.monitor.Monitor;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class GlobalOrientationControl
extends Control {
    public GlobalOrientationControl(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public byte[] getColor() {
        return Colors.yellow;
    }

    @Override
    public void control(int x, int y) {
        float[] v = new float[3];
        v[0] = y;
        v[1] = -x;
        this.projectVector(v);
        v[0] = v[0] * 0.01f;
        v[1] = v[1] * 0.01f;
        v[2] = v[2] * 0.01f;
        this.component.rotate(v, this.center);
    }

    @Override
    public void control(int z) {
        float[] v = new float[3];
        v[2] = z;
        this.projectVector(v);
        v[0] = v[0] * 0.01f;
        v[1] = v[1] * 0.01f;
        v[2] = v[2] * 0.01f;
        this.component.rotate(v, this.center);
    }

    @Override
    void drawAxes(GL gl) {
    }

    @Override
    void draw(GL gl, GLU glu) {
        int[] viewport = new int[4];
        double[] modelview = new double[16];
        double[] projection = new double[16];
        double[] positionWindow = new double[3];
        gl.glGetIntegerv(2978, viewport, 0);
        gl.glGetDoublev(2982, modelview, 0);
        gl.glGetDoublev(2983, projection, 0);
        glu.gluProject((double)this.center[0], (double)this.center[1], (double)this.center[2], modelview, 0, projection, 0, viewport, 0, positionWindow, 0);
        positionWindow[0] = positionWindow[0] - (double)viewport[0];
        positionWindow[1] = positionWindow[1] - (double)viewport[1];
        this.x = positionWindow[0];
        this.y = positionWindow[1];
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)viewport[2], 0.0, (double)viewport[3], -1.0, 1.0);
        gl.glDisable(2929);
        int circlePoints = 80;
        gl.glBegin(1);
        for (int i = 0; i <= circlePoints; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)circlePoints;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)circlePoints;
            gl.glVertex2d(positionWindow[0] + Math.cos(angle1) * (double)this.size, positionWindow[1] + Math.sin(angle1) * (double)this.size);
            gl.glVertex2d(positionWindow[0] + Math.cos(angle2) * (double)this.size, positionWindow[1] + Math.sin(angle2) * (double)this.size);
        }
        gl.glEnd();
        gl.glBegin(0);
        gl.glVertex2dv(positionWindow, 0);
        gl.glEnd();
        gl.glBegin(1);
        gl.glVertex2d(positionWindow[0] - (double)this.size, positionWindow[1]);
        gl.glVertex2d(positionWindow[0] - (double)this.size - 3.0, positionWindow[1] + 5.0);
        gl.glVertex2d(positionWindow[0] - (double)this.size, positionWindow[1]);
        gl.glVertex2d(positionWindow[0] - (double)this.size + 5.0, positionWindow[1] + 5.0);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glEnable(2929);
        this.x += (double)viewport[0];
        this.y += (double)viewport[1];
    }
}

