/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.monitor.Monitor;
import chemaxon.marvin.space.util.GLText;
import java.awt.Color;

public class Label
extends Monitor {
    public static final int LARGE_FONT_SIZE = 8;
    public static final int MEDIUM_FONT_SIZE = 7;
    public static final int SMALL_FONT_SIZE = 6;
    public static final int BORDER_MODE_NONE = 0;
    public static final int BORDER_MODE_OWN_COLOR = 1;
    public static final int BORDER_MODE_FOREGROUND_COLOR = 2;
    public static final int BORDER_MODE_BRIGHTER_FOREGROUND = 3;
    public static final int BACKGROUND_MODE_NONE = 0;
    public static final int BACKGROUND_MODE_OWN_COLOR = 1;
    protected int borderColorMode = 1;
    protected int backgroundColorMode = 1;
    protected static final int ITEM_COUNT = 1;
    protected float[] position = new float[]{0.0f, 0.0f, 0.0f};
    protected int sizeX = 10;
    protected int sizeY = 10;
    protected double textPositionX;
    protected double textPositionY;
    protected double relativeX = 0.0;
    protected double relativeY = 0.0;
    protected boolean draw2D = true;
    protected boolean drawRelation = false;
    protected boolean positionInPlane;
    protected boolean ignoreDrawProperties = false;
    protected int shiftx = 0;
    protected int shifty = 0;
    protected String text;
    protected int labelSize = 7;
    protected float labelScale = 0.5f;
    protected byte[] foregroundColor = new byte[4];
    protected byte[] backgroundColor = new byte[4];
    protected byte[] borderColor = new byte[4];
    protected boolean backgroundColorChanged = false;
    protected boolean foregroundColorChanged = false;
    protected boolean borderColorChanged = false;
    protected GLText gltext = null;

    public Label() {
        this.foregroundColor[0] = Colors.green[0];
        this.foregroundColor[1] = Colors.green[1];
        this.foregroundColor[2] = Colors.green[2];
        this.foregroundColor[3] = 100;
        this.backgroundColor[0] = 0;
        this.backgroundColor[1] = 0;
        this.backgroundColor[2] = 0;
        this.backgroundColor[3] = 100;
        this.borderColor[0] = Colors.reslightgreenB[0];
        this.borderColor[1] = Colors.reslightgreenB[1];
        this.borderColor[2] = Colors.reslightgreenB[2];
        this.borderColor[3] = 100;
    }

    protected void presetTextDraw() {
        if (this.gl == null) {
            System.out.println("no gl!!");
            return;
        }
        if (this.gltext == null) {
            this.gltext = new GLText(this.gl, this.glu);
            this.gltext.setFont(this.labelSize);
            this.gltext.setScale(this.labelScale);
            this.gltext.setForegroundColor(this.foregroundColor);
            this.gltext.setBorderColor(this.borderColor);
            this.gltext.setBackgroundColor(this.backgroundColor);
        }
    }

    public ComponentElement getSelectedItem() {
        return this.selectedItems[0];
    }

    @Override
    public int maximumItemCount() {
        return 1;
    }

    @Override
    public void selectItem(ComponentElement item) {
        super.selectItem(item);
        item.getCoordinates(this.position);
        this.drawRelation = true;
    }

    public void selectItem(GraphicComponent gc) {
        this.selectItem(gc.getComponentElement());
    }

    public GraphicComponent getComponent() {
        return this.selectedItems[0] == null ? null : this.selectedItems[0].getComponent();
    }

    public void refresh() {
        this.selectedItems[0].getCoordinates(this.position);
    }

    @Override
    public void getCoordinates(float[] c) {
        c[0] = this.position[0];
        c[1] = this.position[1];
        c[2] = this.position[2];
    }

    @Override
    public void getCoordinates(ComponentElement item, float[] c) {
        c[0] = this.position[0];
        c[1] = this.position[1];
        c[2] = this.position[2];
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void select() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.foregroundColorChanged = true;
    }

    @Override
    public void unSelect() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.foregroundColorChanged = true;
    }

    @Override
    public void unSelect(ComponentElement element) {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.foregroundColorChanged = true;
    }

    void setPosition(int position) {
        this.position[0] = GeomCalc.getX(position);
        this.position[1] = GeomCalc.getY(position);
        this.position[2] = GeomCalc.getZ(position);
        GeomCalc.deleteVector(position);
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
    }

    public void setPosition(float[] position) {
        this.position[0] = position[0];
        this.position[1] = position[1];
        this.position[2] = position[2];
    }

    public void setPosition(float x, float y) {
        this.position[0] = x;
        this.position[1] = y;
        this.positionInPlane = true;
    }

    public void shift(int x, int y) {
        if (x > 0 && this.textPositionX < (double)(this.graphicCell.getRight() - this.sizeX)) {
            this.shiftx += x;
        } else if (x < 0 && this.textPositionX > (double)this.graphicCell.getLeft()) {
            this.shiftx += x;
        }
        if (y > 0 && this.textPositionY + (double)this.shifty < (double)(this.graphicCell.getTop() - this.sizeY)) {
            this.shifty += y;
        } else if (y < 0 && this.textPositionY > (double)this.graphicCell.getBottom()) {
            this.shifty += y;
        }
    }

    @Override
    public void receiveNotificationOnCoordinateChange(GraphicComponent gc) {
        super.receiveNotificationOnCoordinateChange(gc);
        if (this.selectedItems.length > 0) {
            this.selectedItems[0].getCoordinates(this.position);
        }
    }

    @Override
    public void draw() {
    }

    @Override
    public void drawTransparentPart() {
        if (!this.visible || this.hasInvisibleItem()) {
            return;
        }
        this.presetTextDraw();
        this.gl.glEnable(3042);
        int coordinates = GeomCalc.newVector(this.position);
        this.setColor();
        if (this.text != null) {
            this.gltext.drawLabel3D(coordinates, this.text, this.irm);
        } else if (this.selectedItems[0] != null) {
            this.gltext.drawLabel3D(coordinates, this.selectedItems[0].getDescription(), this.irm);
        }
        this.gl.glDisable(3042);
        GeomCalc.deleteVector(coordinates);
    }

    @Override
    public boolean hasTransparentPart() {
        return !this.draw2D;
    }

    @Override
    public boolean has2DPart() {
        return this.draw2D;
    }

    @Override
    public float getZCoordinateTo2DPart() {
        return this.position[2];
    }

    @Override
    public void draw2DPart() {
        if (!this.visible || this.hasInvisibleItem()) {
            return;
        }
        this.presetTextDraw();
        this.gl.glDisable(2896);
        int coordinates = GeomCalc.newVector(this.position);
        this.setColor();
        if (this.text != null) {
            if (this.positionInPlane) {
                this.gltext.drawLabelRelatively(7168, 0, 0, (int)this.position[0], (int)this.position[1], this.text, this.shiftx, this.shifty, this.drawRelation);
            } else {
                this.gltext.drawLabelRelatively(7168, 0, 0, coordinates, this.text, this.shiftx, this.shifty, this.drawRelation);
            }
        } else if (this.selectedItems[0] != null) {
            this.gltext.drawLabelRelatively(7168, 0, 0, coordinates, this.selectedItems[0].getDescription(), this.shiftx, this.shifty, this.drawRelation);
        }
        this.sizeX = this.gltext.getLastWidth();
        this.sizeY = this.gltext.getLastHeight();
        GeomCalc.deleteVector(coordinates);
        this.gl.glEnable(2896);
    }

    @Override
    public boolean hasInvisibleItem() {
        if (this.selectedItems[0] == null) {
            return this.text == null;
        }
        return !this.selectedItems[0].isVisible();
    }

    private void setColor() {
        if (this.foregroundColorChanged) {
            if (this.active) {
                this.gltext.setForegroundColor(Colors.selected);
            } else {
                this.gltext.setForegroundColor(this.foregroundColor);
            }
            this.foregroundColorChanged = false;
        }
        if (this.backgroundColorChanged) {
            if (this.backgroundColorMode == 0) {
                this.gltext.setBackgroundColor(null);
            } else {
                this.gltext.setBackgroundColor(this.backgroundColor);
            }
            this.backgroundColorChanged = false;
        }
        if (this.borderColorChanged) {
            if (this.borderColorMode == 0) {
                this.gltext.setBorderColor(null);
            } else {
                this.gltext.setBorderColor(this.borderColor);
            }
            this.borderColorChanged = false;
        }
    }

    @Override
    public double locateObject(int x, int y) {
        boolean pick;
        if (!this.draw2D || this.gltext == null) {
            return -1.0;
        }
        this.textPositionX = this.gltext.getTextPositionX() + (double)this.graphicCell.getLeft();
        this.textPositionY = this.gltext.getTextPositionY() + (double)this.graphicCell.getBottom();
        boolean bl = pick = (double)x > this.textPositionX && (double)x - this.textPositionX < (double)this.sizeX && (double)y > this.textPositionY && (double)y - this.textPositionY < (double)this.sizeY;
        if (pick) {
            this.pickedItem = new ComponentElement((GraphicComponent)this, 1, 0);
        }
        return pick ? this.pickedIndicator() : -1.0;
    }

    protected void setLabelSize(String size) {
        if (size.equalsIgnoreCase("Small")) {
            this.labelSize = 6;
            this.labelScale = 0.25f;
        } else if (size.equalsIgnoreCase("Medium")) {
            this.labelSize = 7;
            this.labelScale = 0.5f;
        } else if (size.equalsIgnoreCase("Large")) {
            this.labelSize = 8;
            this.labelScale = 1.0f;
        } else {
            try {
                this.labelScale = Float.parseFloat(size);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.gltext != null) {
            this.gltext.setFont(this.labelSize);
            this.gltext.setScale(this.labelScale);
        }
    }

    public void setRelativeXCoordinate(float x) {
        this.relativeX = x;
    }

    public void setRelativeYCoordinate(float y) {
        this.relativeY = y;
    }

    public byte[] getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color c) {
        this.foregroundColor[0] = (byte)(c.getRed() / 2);
        this.foregroundColor[1] = (byte)(c.getGreen() / 2);
        this.foregroundColor[2] = (byte)(c.getBlue() / 2);
        Colors.checkRange(this.foregroundColor);
        this.foregroundColorChanged = true;
        this.setBorderColor();
    }

    public byte[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color c) {
        if (c == null) {
            this.setBackgroundColorMode(0);
            return;
        }
        this.backgroundColor[0] = (byte)(c.getRed() / 2);
        this.backgroundColor[1] = (byte)(c.getGreen() / 2);
        this.backgroundColor[2] = (byte)(c.getBlue() / 2);
        Colors.checkRange(this.backgroundColor);
        this.backgroundColorChanged = true;
        this.setBorderColor();
    }

    public void setBackgroundColorMode(int mode) {
        if (this.backgroundColorMode == mode) {
            return;
        }
        this.backgroundColorMode = mode;
        this.backgroundColorChanged = true;
    }

    public byte[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color c) {
        if (this.borderColorMode != 1) {
            this.borderColorMode = 1;
        }
        this.borderColor[0] = (byte)(c.getRed() / 2);
        this.borderColor[1] = (byte)(c.getGreen() / 2);
        this.borderColor[2] = (byte)(c.getBlue() / 2);
        this.borderColorChanged = true;
    }

    public void setBorderColorMode(int mode) {
        if (this.borderColorMode == mode) {
            return;
        }
        this.borderColorMode = mode;
        this.setBorderColor();
    }

    private void setBorderColor() {
        if (this.borderColorMode == 1) {
            return;
        }
        if (this.borderColorMode == 2) {
            System.arraycopy(this.foregroundColor, 0, this.borderColor, 0, 4);
        } else if (this.borderColorMode == 3) {
            Colors.brighter(this.borderColor, this.foregroundColor);
        }
        this.borderColorChanged = true;
    }

    public void setLabel2DDrawing(boolean b) {
        this.draw2D = b;
    }

    public void ignoreDrawProperties(boolean b) {
        this.ignoreDrawProperties = b;
    }

    @Override
    public void setDrawProperty(String propertyName, String propertyValue) throws Exception {
        if (this.ignoreDrawProperties) {
            return;
        }
        if (propertyName.equals("Label.Size")) {
            this.setLabelSize(propertyValue);
            this.storeDrawProperty(propertyName, propertyValue);
        } else if (propertyName.equals("Label.ForegroundColor")) {
            this.setForegroundColor(Color.decode(propertyValue));
        } else if (propertyName.equals("Label.BackgroundColor")) {
            this.setBackgroundColor(Color.decode(propertyValue));
        } else if (propertyName.equals("Label.Background")) {
            if (Boolean.valueOf(propertyValue).booleanValue()) {
                this.setBackgroundColorMode(1);
            } else {
                this.setBackgroundColorMode(0);
            }
        } else if (propertyName.equals("Label.BorderColor")) {
            this.setBorderColor(Color.decode(propertyValue));
        } else if (propertyName.equals("Label.Border")) {
            if (Boolean.valueOf(propertyValue).booleanValue()) {
                this.setBorderColorMode(1);
                this.borderColorChanged = true;
            } else {
                this.setBorderColorMode(0);
            }
        } else if (propertyName.equals("Label.Draw2D")) {
            this.setLabel2DDrawing(Boolean.valueOf(propertyValue));
        } else if (propertyName.equals("Label.DrawRelation")) {
            this.drawRelation = Boolean.valueOf(propertyValue);
        }
    }
}

