/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.monitor.Control;
import chemaxon.marvin.space.monitor.Monitor;
import chemaxon.marvin.space.monitor.PositionMonitor;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class LocalLocationControl
extends Control {
    private float controlMeasure = 0.05f;

    public LocalLocationControl(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public byte[] getColor() {
        return Colors.orange;
    }

    @Override
    public void control(int x, int y) {
        float[] v = new float[3];
        v[0] = (float)y * this.controlMeasure;
        v[1] = (float)x * this.controlMeasure;
        this.component.translate(v);
        ((PositionMonitor)this.monitor).refresh();
    }

    @Override
    public void control(int z) {
        float[] v = new float[3];
        v[2] = (float)z * this.controlMeasure;
        this.component.translate(v);
        ((PositionMonitor)this.monitor).refresh();
    }

    @Override
    void drawAxes(GL gl) {
        gl.glPushMatrix();
        gl.glTranslated((double)this.center[0], (double)this.center[1], (double)this.center[2]);
        gl.glColor3fv(Colors.lightorange, 0);
        gl.glBegin(1);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(5.0, 0.0, 0.0);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(0.0, 5.0, 0.0);
        gl.glVertex3d(0.0, 0.0, 0.0);
        gl.glVertex3d(0.0, 0.0, 5.0);
        gl.glEnd();
        gl.glPopMatrix();
    }

    @Override
    void draw(GL gl, GLU glu) {
        int[] viewport = new int[4];
        double[] modelview = new double[16];
        double[] projection = new double[16];
        double[] positionWindow = new double[3];
        gl.glGetIntegerv(2978, viewport, 0);
        gl.glGetDoublev(2982, modelview, 0);
        gl.glGetDoublev(2983, projection, 0);
        glu.gluProject((double)this.center[0], (double)this.center[1], (double)this.center[2], modelview, 0, projection, 0, viewport, 0, positionWindow, 0);
        positionWindow[0] = positionWindow[0] - (double)viewport[0];
        positionWindow[1] = positionWindow[1] - (double)viewport[1];
        this.x = positionWindow[0];
        this.y = positionWindow[1];
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)viewport[2], 0.0, (double)viewport[3], -1.0, 1.0);
        gl.glDisable(2929);
        this.size += 5;
        gl.glBegin(1);
        gl.glVertex2d(this.x - (double)this.size, this.y);
        gl.glVertex2d(this.x + (double)this.size, this.y);
        gl.glVertex2d(this.x - (double)this.size, this.y);
        gl.glVertex2d(this.x - (double)this.size + 5.0, this.y + 3.0);
        gl.glVertex2d(this.x - (double)this.size, this.y);
        gl.glVertex2d(this.x - (double)this.size + 5.0, this.y - 3.0);
        gl.glVertex2d(this.x + (double)this.size, this.y);
        gl.glVertex2d(this.x + (double)this.size - 5.0, this.y + 3.0);
        gl.glVertex2d(this.x + (double)this.size, this.y);
        gl.glVertex2d(this.x + (double)this.size - 5.0, this.y - 3.0);
        gl.glVertex2d(this.x, this.y - (double)this.size);
        gl.glVertex2d(this.x, this.y + (double)this.size);
        gl.glVertex2d(this.x, this.y - (double)this.size);
        gl.glVertex2d(this.x - 3.0, this.y - (double)this.size + 5.0);
        gl.glVertex2d(this.x, this.y - (double)this.size);
        gl.glVertex2d(this.x + 3.0, this.y - (double)this.size + 5.0);
        gl.glVertex2d(this.x, this.y + (double)this.size);
        gl.glVertex2d(this.x - 3.0, this.y + (double)this.size - 5.0);
        gl.glVertex2d(this.x, this.y + (double)this.size);
        gl.glVertex2d(this.x + 3.0, this.y + (double)this.size - 5.0);
        gl.glEnd();
        this.size -= 5;
        gl.glBegin(0);
        gl.glVertex2dv(positionWindow, 0);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glEnable(2929);
        this.x += (double)viewport[0];
        this.y += (double)viewport[1];
    }
}

