/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.monitor.Label;
import chemaxon.marvin.space.monitor.Monitor;
import java.text.NumberFormat;

public abstract class MeasurementMonitor
extends Monitor {
    protected double measurement = -1.0;
    protected double[] textPosWindow = null;
    protected String measure = "";
    protected Label label = null;

    protected MeasurementMonitor() {
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    @Override
    public void selectItem(ComponentElement item) {
        if (this.selectionPointer == this.selectedItems.length) {
            return;
        }
        item.setDescription(null);
        this.selectedItems[this.selectionPointer] = item;
        float[] c = new float[3];
        item.getCoordinates(c);
        this.selectedItemCoordinates[this.selectionPointer] = GeomCalc.newVector(c);
        ++this.selectionPointer;
    }

    @Override
    public void receiveNotificationOnCoordinateChange(GraphicComponent gc) {
        super.receiveNotificationOnCoordinateChange(gc);
        this.refresh();
    }

    public abstract double measurement();

    @Override
    public void getCoordinates(float[] c) {
        if (this.isFull()) {
            int center = GeomCalc.newVector();
            for (int i = 0; i < this.maximumItemCount(); ++i) {
                GeomCalc.increase(center, this.selectedItemCoordinates[i]);
            }
            GeomCalc.scale(center, 1.0f / (float)this.maximumItemCount());
            c[0] = GeomCalc.getX(center);
            c[1] = GeomCalc.getY(center);
            c[2] = GeomCalc.getZ(center);
            GeomCalc.deleteVector(center);
        }
    }

    @Override
    public void getCoordinates(ComponentElement item, float[] c) {
        this.getCoordinates(c);
    }

    @Override
    public String getDescription() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        return nf.format(this.measurement) + this.measure;
    }

    @Override
    public String getDescription(ComponentElement element) {
        return this.getDescription();
    }

    public void refresh() {
        this.measurement = -1.0;
        this.measurement();
    }

    protected byte[] getMonitorColor() {
        if (this.active) {
            return Colors.selected;
        }
        if (this.label != null) {
            return this.label.getForegroundColor();
        }
        return Colors.green;
    }
}

