/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.monitor.Control;

public abstract class Monitor
extends GraphicComponent {
    protected ComponentElement[] selectedItems = new ComponentElement[this.maximumItemCount()];
    protected int[] selectedItemCoordinates = new int[this.maximumItemCount()];
    protected int selectionPointer = 0;
    protected Control control = null;
    protected int mode = 7168;

    protected Monitor() {
        this.clear();
        this.modifiesOrigin = false;
    }

    @Override
    public void onRemoveGraphicComponent() {
        super.onRemoveGraphicComponent();
        for (int i = 0; i < this.selectedItemCoordinates.length; ++i) {
            if (this.selectedItemCoordinates[i] == 0) {
                return;
            }
            GeomCalc.deleteVector(this.selectedItemCoordinates[i]);
        }
    }

    public abstract int maximumItemCount();

    public ComponentElement[] getSelectedElements() {
        return this.selectedItems;
    }

    public void selectItem(ComponentElement item) {
        if (this.selectionPointer == this.selectedItems.length) {
            return;
        }
        this.selectedItems[this.selectionPointer] = item;
        float[] c = new float[3];
        item.getCoordinates(c);
        this.selectedItemCoordinates[this.selectionPointer] = GeomCalc.newVector(c);
        ++this.selectionPointer;
    }

    @Override
    public void receiveNotificationOnCoordinateChange(GraphicComponent gc) {
        super.receiveNotificationOnCoordinateChange(gc);
        for (int i = 0; i < this.maximumItemCount(); ++i) {
            if (this.selectedItems[i].getComponent() != gc) continue;
            float[] c = new float[3];
            this.selectedItems[i].getCoordinates(c);
            this.selectedItemCoordinates[i] = GeomCalc.newVector(c);
        }
        this.notifyCoordinateChange();
    }

    @Override
    public void receiveNotificationOnVisibility(GraphicComponent gc) {
        this.setVisible(true);
    }

    @Override
    public void receiveNotificationOnInvisibility(GraphicComponent gc) {
        this.setVisible(false);
    }

    public boolean isFull() {
        return this.selectionPointer == this.selectedItems.length;
    }

    public boolean hasControl() {
        return this.control != null;
    }

    public void clear() {
        for (int i = 0; i < this.maximumItemCount(); ++i) {
            this.selectedItems[i] = null;
            this.selectedItemCoordinates[i] = 0;
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible && !this.hasInvisibleItem();
    }

    public boolean hasInvisibleItem() {
        for (int i = 0; i < this.maximumItemCount(); ++i) {
            if (this.selectedItems[i].isVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean refersTo(GraphicComponent component) {
        for (int i = 0; i < this.maximumItemCount(); ++i) {
            if (this.selectedItems[i].getComponent() != component) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unSelect() {
        super.unSelect();
        this.pickedItem = null;
    }

    public double pickedIndicator() {
        return -2.0;
    }

    @Override
    public boolean hasTransparentPart() {
        return true;
    }
}

