/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.ComponentElement;
import chemaxon.marvin.space.GraphicComponent;
import chemaxon.marvin.space.monitor.Control;
import chemaxon.marvin.space.monitor.Monitor;

public class PositionMonitor
extends Monitor {
    private static final int ITEM_COUNT = 1;
    protected float[] position = new float[]{0.0f, 0.0f, 0.0f};

    @Override
    public void selectItem(ComponentElement item) {
        super.selectItem(item);
        item.getCoordinates(this.position);
    }

    public void selectItem(GraphicComponent gc) {
        this.selectItem(gc.getComponentElement());
    }

    public GraphicComponent getComponent() {
        return this.selectedItems[0].getComponent();
    }

    public void refresh() {
        this.selectedItems[0].getCoordinates(this.position);
    }

    @Override
    public void getCoordinates(float[] c) {
        c[0] = this.position[0];
        c[1] = this.position[1];
        c[2] = this.position[2];
    }

    @Override
    public void getCoordinates(ComponentElement item, float[] c) {
        c[0] = this.position[0];
        c[1] = this.position[1];
        c[2] = this.position[2];
    }

    @Override
    public int maximumItemCount() {
        return 1;
    }

    public int getPosition() {
        return GeomCalc.newVector(this.position);
    }

    void setPosition(int position) {
        this.position[0] = GeomCalc.getX(position);
        this.position[1] = GeomCalc.getY(position);
        this.position[2] = GeomCalc.getZ(position);
        if (this.control != null) {
            this.control.setCenter(this.position);
        }
        GeomCalc.deleteVector(position);
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        this.control.setCenter(this.position);
    }

    public void setPosition(float[] position) {
        this.position[0] = position[0];
        this.position[1] = position[1];
        this.position[2] = position[2];
        this.control.setCenter(this.position);
    }

    @Override
    public boolean isVisible(ComponentElement item) {
        return true;
    }

    @Override
    public void draw() {
    }

    @Override
    public void draw2DPart() {
        if (this.hasInvisibleItem() || this.control == null) {
            return;
        }
        this.gl.glDisable(2896);
        this.gl.glColor3bv(Colors.black, 0);
        this.gl.glLineWidth(3.0f);
        this.gl.glPointSize(10.0f);
        this.gl.glEnable(3042);
        this.control.draw(this.gl, this.glu);
        this.gl.glColor3bv(this.control.getColor(), 0);
        this.gl.glLineWidth(1.5f);
        this.gl.glPointSize(8.0f);
        this.control.draw(this.gl, this.glu);
        this.control.drawAxes(this.gl);
        this.gl.glDisable(3042);
        this.gl.glEnable(2896);
    }

    @Override
    public boolean has2DPart() {
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public void setControl(Control control) {
        this.control = control;
        this.control.setCenter(this.position);
        this.control.setComponent(this.getComponent());
    }

    public void control(int x, int y) {
        this.control.control(x, y);
    }

    public void control(int z) {
        this.control.control(z);
    }

    @Override
    public double locateObject(int x, int y) {
        boolean flag = this.control.pick(x, y);
        return flag ? this.pickedIndicator() : -1.0;
    }
}

