/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.monitor;

import chemaxon.marvin.space.Colors;
import chemaxon.marvin.space.monitor.Control;
import chemaxon.marvin.space.monitor.Monitor;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class ResizeControl
extends Control {
    public ResizeControl(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void control(int z) {
        double sz = z > 0 ? 1.0 : (z == 0 ? 0.0 : -1.0);
        this.component.resize(0.0, 0.0, sz);
    }

    @Override
    public void control(int x, int y) {
        double sx;
        double d = x > 0 ? 1.0 : (sx = x == 0 ? 0.0 : -1.0);
        double sy = y > 0 ? 1.0 : (y == 0 ? 0.0 : -1.0);
        this.component.resize(sx, sy, 0.0);
    }

    @Override
    void draw(GL gl, GLU glu) {
        int[] viewport = new int[4];
        double[] modelview = new double[16];
        double[] projection = new double[16];
        double[] positionWindow = new double[3];
        gl.glGetIntegerv(2978, viewport, 0);
        gl.glGetDoublev(2982, modelview, 0);
        gl.glGetDoublev(2983, projection, 0);
        glu.gluProject((double)this.center[0], (double)this.center[1], (double)this.center[2], modelview, 0, projection, 0, viewport, 0, positionWindow, 0);
        positionWindow[0] = positionWindow[0] - (double)viewport[0];
        positionWindow[1] = positionWindow[1] - (double)viewport[1];
        this.x = positionWindow[0];
        this.y = positionWindow[1];
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)viewport[2], 0.0, (double)viewport[3], -1.0, 1.0);
        gl.glDisable(2929);
        double sp2 = (double)this.size / 3.0;
        gl.glBegin(3);
        gl.glVertex2d(positionWindow[0] - sp2, positionWindow[1] - sp2);
        gl.glVertex2d(positionWindow[0] + sp2, positionWindow[1] - sp2);
        gl.glVertex2d(positionWindow[0] + sp2, positionWindow[1] + sp2);
        gl.glVertex2d(positionWindow[0] - sp2, positionWindow[1] + sp2);
        gl.glVertex2d(positionWindow[0] - sp2, positionWindow[1] - sp2);
        gl.glEnd();
        gl.glBegin(3);
        gl.glVertex2d(positionWindow[0] - (double)this.size, positionWindow[1] - (double)this.size);
        gl.glVertex2d(positionWindow[0] + (double)this.size, positionWindow[1] - (double)this.size);
        gl.glVertex2d(positionWindow[0] + (double)this.size, positionWindow[1] + (double)this.size);
        gl.glVertex2d(positionWindow[0] - (double)this.size, positionWindow[1] + (double)this.size);
        gl.glVertex2d(positionWindow[0] - (double)this.size, positionWindow[1] - (double)this.size);
        gl.glEnd();
        gl.glBegin(1);
        gl.glVertex2d(positionWindow[0] + sp2, positionWindow[1] + sp2);
        gl.glVertex2d(positionWindow[0] + (double)this.size, positionWindow[1] + (double)this.size);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPopMatrix();
        gl.glEnable(2929);
        this.x += (double)viewport[0];
        this.y += (double)viewport[1];
    }

    @Override
    void drawAxes(GL gl) {
    }

    @Override
    public byte[] getColor() {
        return Colors.yellow;
    }
}

