/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.marvin.space.render.Renderer;
import java.nio.ByteBuffer;

public class Box
extends Renderer {
    private static byte[] triIndices = new byte[]{0, 1, 4, 1, 5, 4, 0, 3, 1, 1, 3, 2, 0, 4, 3, 3, 4, 7, 3, 7, 2, 2, 7, 6, 1, 2, 5, 2, 6, 5, 4, 5, 7, 5, 6, 7};
    private float[][] v = new float[8][3];
    private float[][] n = new float[][]{{0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
    protected ByteBuffer indices;

    public Box() {
        this.allocate();
    }

    public Box(float a, float b, float c) {
        this(a, b, c, false);
        this.allocate();
    }

    public Box(float a, float b, float c, boolean centered) {
        if (centered) {
            float baseA = a / 2.0f;
            float baseB = b / 2.0f;
            this.v[0][0] = -baseA;
            this.v[0][1] = -baseB;
            this.v[0][2] = 0.0f;
            this.v[1][0] = baseA;
            this.v[1][1] = -baseB;
            this.v[1][2] = 0.0f;
            this.v[2][0] = baseA;
            this.v[2][1] = baseB;
            this.v[2][2] = 0.0f;
            this.v[3][0] = -baseA;
            this.v[3][1] = baseB;
            this.v[3][2] = 0.0f;
            this.v[4][0] = -baseA;
            this.v[4][1] = -baseB;
            this.v[4][2] = c;
            this.v[5][0] = baseA;
            this.v[5][1] = -baseB;
            this.v[5][2] = c;
            this.v[6][0] = baseA;
            this.v[6][1] = baseB;
            this.v[6][2] = c;
            this.v[7][0] = -baseA;
            this.v[7][1] = baseB;
            this.v[7][2] = c;
        } else {
            this.v[1][0] = a;
            this.v[2][0] = a;
            this.v[2][1] = b;
            this.v[3][1] = b;
            this.v[4][2] = c;
            this.v[5][0] = a;
            this.v[5][2] = c;
            this.v[6][0] = a;
            this.v[6][1] = b;
            this.v[6][2] = c;
            this.v[7][1] = b;
            this.v[7][2] = c;
        }
        this.allocate();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.v = null;
        this.n = null;
        this.indices.clear();
        this.indices = null;
    }

    public void create() {
        int i;
        for (i = 0; i < 36; ++i) {
            this.vertices.put(this.v[triIndices[i]]);
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.normals.put(this.n[i]);
            }
        }
    }

    @Override
    public int getTriangleCount() {
        return 12;
    }

    @Override
    public int getVertexCount() {
        return 36;
    }

    @Override
    public int getElementType() {
        return 4;
    }
}

