/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.marvin.space.render.Cylinder;
import java.util.HashMap;

public class Cylinders {
    HashMap cylinders = new HashMap();
    CylinderKey ck = new CylinderKey();

    public Cylinder getCylinder(int slices, int stacks, double radius) {
        this.ck.setPrecision(slices, stacks);
        this.ck.setRadius(radius);
        Cylinder cyl = (Cylinder)this.cylinders.get(this.ck);
        if (cyl != null) {
            return cyl;
        }
        cyl = new Cylinder(radius, 1.0, slices, stacks);
        cyl.setRadius(radius);
        cyl.create();
        this.cylinders.put(new CylinderKey(slices, stacks, radius), cyl);
        return cyl;
    }

    public Cylinder getCone(int slices, double baseRadius) {
        this.ck.setPrecision(slices, 0);
        this.ck.setRadius(baseRadius);
        Cylinder cyl = (Cylinder)this.cylinders.get(this.ck);
        if (cyl != null) {
            return cyl;
        }
        cyl = new Cylinder(baseRadius, 0.0, 1.0, slices);
        cyl.create();
        this.cylinders.put(new CylinderKey(slices, 0, baseRadius), cyl);
        return cyl;
    }

    public class CylinderKey {
        int slices;
        int stacks;
        double radius;

        CylinderKey() {
        }

        CylinderKey(int slices, int stacks, double radius) {
            this.slices = slices;
            this.stacks = stacks;
            this.radius = radius;
        }

        public int hashCode() {
            return this.slices + this.stacks + (int)(100.0 * this.radius);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CylinderKey)) {
                return false;
            }
            CylinderKey ck = (CylinderKey)obj;
            return ck.radius == this.radius && ck.slices == this.slices && ck.stacks == this.stacks;
        }

        public void setPrecision(int slices, int stacks) {
            this.slices = slices;
            this.stacks = stacks;
        }

        public void setRadius(double radius) {
            this.radius = radius;
        }
    }
}

