/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.marvin.space.render.Renderer;

public class Disk
extends Renderer {
    private double radius = 1.0;
    private int slices = 8;
    private boolean upwards = true;

    public Disk() {
        this.allocate();
    }

    public Disk(double radius, int slices, boolean upwards) {
        this.radius = radius;
        this.slices = slices;
        this.upwards = upwards;
        this.allocate();
    }

    public void create() {
        if (this.created) {
            return;
        }
        double da = Math.PI * 2 / (double)this.slices;
        for (int s = 0; s < this.slices; ++s) {
            double a = (double)s * da;
            this.vertices.put((float)(this.radius * Math.sin(a)));
            this.vertices.put((float)(this.radius * Math.cos(a)));
            this.vertices.put(0.0f);
            this.vertices.put((float)(this.radius * Math.sin(a + da)));
            this.vertices.put((float)(this.radius * Math.cos(a + da)));
            this.vertices.put(0.0f);
            this.vertices.put(0.0f);
            this.vertices.put(0.0f);
            this.vertices.put(0.0f);
        }
        int n = this.upwards ? 1 : -1;
        for (int i = 0; i < this.getVertexCount(); ++i) {
            this.normals.put(0.0f);
            this.normals.put(0.0f);
            this.normals.put(n);
        }
        this.created = true;
    }

    @Override
    public int getTriangleCount() {
        return this.slices;
    }

    @Override
    public int getVertexCount() {
        return this.slices * 3;
    }

    @Override
    public int getElementType() {
        return 4;
    }
}

