/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.marvin.space.render.Cylinders;
import chemaxon.marvin.space.render.Spheres;
import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;

public abstract class Renderer {
    public static Spheres spheres = new Spheres();
    public static Cylinders cylinders = new Cylinders();
    protected FloatBuffer vertices;
    protected FloatBuffer normals;
    protected int[] triangles;
    protected int trianglePointer = 0;
    public boolean directDraw = true;
    protected boolean created = false;

    protected void finalize() throws Throwable {
        this.vertices.clear();
        this.normals.clear();
        this.vertices = null;
        this.normals = null;
        this.triangles = null;
    }

    protected void allocate() {
        this.vertices = BufferUtil.newFloatBuffer((int)(this.getVertexCount() * 3));
        this.normals = BufferUtil.newFloatBuffer((int)(this.getVertexCount() * 3));
        if (!this.directDraw) {
            this.triangles = new int[this.getTriangleCount() * 3];
        }
    }

    public FloatBuffer getVertices() {
        return this.vertices;
    }

    public FloatBuffer getNormals() {
        return this.normals;
    }

    public int[] getTriangles() {
        return this.triangles;
    }

    public abstract int getVertexCount();

    public abstract int getTriangleCount();

    public abstract int getElementType();

    public void generateRendererDisplayList(int listIndex, GL gl) {
        gl.glNewList(listIndex, 4864);
        gl.glVertexPointer(3, 5126, 0, this.vertices.position(0));
        gl.glNormalPointer(5126, 0, this.normals.position(0));
        if (this.directDraw) {
            gl.glDrawArrays(this.getElementType(), 0, this.getVertexCount());
        } else {
            gl.glDrawElements(this.getElementType(), this.getTriangleCount() * 3, 5125, (Buffer)IntBuffer.wrap(this.triangles));
        }
        gl.glEndList();
    }
}

