/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.marvin.space.render.Renderer;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;

public class Sphere
extends Renderer {
    private static float EPSILON = 1.0E-5f;
    private float[] center = new float[]{0.0f, 0.0f, 0.0f};
    private double radius = 1.0;
    private int precision = 20;
    private double TWOPI = Math.PI * 2;
    private double PID2 = 1.5707963267948966;
    private int vertexCount = 0;
    private double drho;
    private double dtheta;

    public Sphere() {
        this.allocate();
        this.drho = Math.PI / (double)this.precision;
        this.dtheta = 2.0 * this.drho;
    }

    public Sphere(boolean directDraw) {
        this.directDraw = directDraw;
        this.allocate();
        this.drho = Math.PI / (double)this.precision;
        this.dtheta = 2.0 * this.drho;
    }

    public Sphere(int precision) {
        this.precision = precision;
        this.drho = Math.PI / (double)precision;
        this.dtheta = 2.0 * this.drho;
        this.allocate();
    }

    public Sphere(int precision, boolean directDraw) {
        this.directDraw = directDraw;
        this.precision = precision;
        this.drho = Math.PI / (double)precision;
        this.dtheta = 2.0 * this.drho;
        this.allocate();
    }

    @Override
    public void generateRendererDisplayList(int listIndex, GL gl) {
        gl.glNewList(listIndex, 4864);
        gl.glVertexPointer(3, 5126, 0, this.vertices.position(0));
        gl.glNormalPointer(5126, 0, this.normals.position(0));
        if (this.directDraw) {
            gl.glDrawArrays(6, 0, this.precision + 2);
            gl.glDrawArrays(5, this.precision + 2, this.getVertexCount() - (2 * this.precision + 4));
            gl.glDrawArrays(6, this.getVertexCount() - this.precision - 2, this.precision + 2);
        } else {
            gl.glDrawElements(this.getElementType(), this.getTriangleCount() * 3, 5125, (Buffer)IntBuffer.wrap(this.triangles));
        }
        gl.glEndList();
    }

    public void create() {
        if (this.created) {
            return;
        }
        if (this.directDraw) {
            this.createGLUSphere();
            return;
        }
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        if (this.precision <= 4 || this.radius == 0.0) {
            return;
        }
        int t = 0;
        int[] idx = new int[3];
        for (int j = 0; j < this.precision / 2; ++j) {
            double theta1 = (double)j * this.TWOPI / (double)this.precision - this.PID2;
            double theta2 = (double)(j + 1) * this.TWOPI / (double)this.precision - this.PID2;
            for (int i = 0; i <= this.precision; ++i) {
                double theta3 = (double)i * this.TWOPI / (double)this.precision;
                ex = Math.cos(theta2) * Math.cos(theta3);
                ey = Math.sin(theta2);
                ez = Math.cos(theta2) * Math.sin(theta3);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                int newIndex = this.getIndex((float)ex, (float)ey, (float)ez, (float)px, (float)py, (float)pz);
                if (t > 1) {
                    this.processIndex(idx, newIndex);
                } else {
                    idx[t] = newIndex;
                }
                ++t;
                ex = Math.cos(theta1) * Math.cos(theta3);
                ey = Math.sin(theta1);
                ez = Math.cos(theta1) * Math.sin(theta3);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                newIndex = this.getIndex((float)ex, (float)ey, (float)ez, (float)px, (float)py, (float)pz);
                if (t > 1) {
                    this.processIndex(idx, newIndex);
                } else {
                    idx[t] = newIndex;
                }
                ++t;
            }
        }
        this.created = true;
    }

    public void createDirectData() {
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        if (this.precision <= 4 || this.radius == 0.0) {
            return;
        }
        for (int j = 0; j < this.precision / 2; ++j) {
            double theta1 = (double)j * this.TWOPI / (double)this.precision - this.PID2;
            double theta2 = (double)(j + 1) * this.TWOPI / (double)this.precision - this.PID2;
            for (int i = 0; i < this.precision; ++i) {
                double theta3 = (double)i * this.TWOPI / (double)this.precision;
                ex = Math.cos(theta2) * Math.cos(theta3);
                ey = Math.sin(theta2);
                ez = Math.cos(theta2) * Math.sin(theta3);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                this.putNormal((float)ex, (float)ey, (float)ez);
                this.putVertex((float)px, (float)py, (float)pz);
                ex = Math.cos(theta1) * Math.cos(theta3);
                ey = Math.sin(theta1);
                ez = Math.cos(theta1) * Math.sin(theta3);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                this.putNormal((float)ex, (float)ey, (float)ez);
                this.putVertex((float)px, (float)py, (float)pz);
            }
        }
    }

    private void processIndex(int[] idx, int i) {
        idx[0] = idx[1];
        idx[1] = idx[2];
        idx[2] = i;
        this.putTriangle(idx[0], idx[1], idx[2]);
    }

    private int getIndex(float nx, float ny, float nz, float vx, float vy, float vz) {
        int i;
        for (i = 0; i < this.vertexCount; ++i) {
            if (!this.equals(this.vertices.get(i * 3), vx) || !this.equals(this.vertices.get(i * 3 + 1), vy) || !this.equals(this.vertices.get(i * 3 + 2), vz)) continue;
            return i;
        }
        this.putVertex(vx, vy, vz);
        this.putNormal(nx, ny, nz);
        return i;
    }

    private boolean equals(float v1, float v2) {
        return Math.abs(v1 - v2) < EPSILON;
    }

    private void putVertex(float x, float y, float z) {
        this.vertices.put(x);
        this.vertices.put(y);
        this.vertices.put(z);
        ++this.vertexCount;
    }

    private void putNormal(float x, float y, float z) {
        this.normals.put(x);
        this.normals.put(y);
        this.normals.put(z);
    }

    private void putTriangle(int i1, int i2, int i3) {
        this.triangles[this.trianglePointer++] = i1;
        this.triangles[this.trianglePointer++] = i2;
        this.triangles[this.trianglePointer++] = i3;
    }

    public void createGLSphere(GL gl) {
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        gl.glBegin(5);
        if (this.precision <= 4 || this.radius == 0.0) {
            gl.glNormal3d(0.0, 0.0, 0.0);
            gl.glVertex3fv(this.center, 0);
            return;
        }
        for (int j = 0; j < this.precision / 2; ++j) {
            double theta1 = (double)j * this.TWOPI / (double)this.precision - this.PID2;
            double theta2 = (double)(j + 1) * this.TWOPI / (double)this.precision - this.PID2;
            for (int i = 0; i <= this.precision; ++i) {
                double theta3 = (double)i * this.TWOPI / (double)this.precision;
                ex = Math.cos(theta2) * Math.cos(theta3);
                ey = Math.sin(theta2);
                ez = Math.cos(theta2) * Math.sin(theta3);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                gl.glNormal3d(ex, ey, ez);
                gl.glVertex3d(px, py, pz);
                ex = Math.cos(theta1) * Math.cos(theta3);
                ey = Math.sin(theta1);
                ez = Math.cos(theta1) * Math.sin(theta3);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                gl.glNormal3d(ex, ey, ez);
                gl.glVertex3d(px, py, pz);
            }
        }
        gl.glEnd();
    }

    public void createGLSphere2(GL gl) {
        double drho = Math.PI / (double)this.precision;
        double dtheta = 2.0 * drho;
        for (int i = 0; i < this.precision; ++i) {
            double rho = (double)i * drho;
            gl.glBegin(8);
            for (int j = 0; j <= this.precision; ++j) {
                double theta = j == this.precision ? 0.0 : (double)j * dtheta;
                double x = -Math.sin(theta) * Math.sin(rho);
                double y = Math.cos(theta) * Math.sin(rho);
                double z = Math.cos(rho);
                gl.glNormal3d(x, y, z);
                gl.glVertex3d(x * this.radius, y * this.radius, z * this.radius);
                x = -Math.sin(theta) * Math.sin(rho + drho);
                y = Math.cos(theta) * Math.sin(rho + drho);
                z = Math.cos(rho + drho);
                gl.glNormal3d(x, y, z);
                gl.glVertex3d(x * this.radius, y * this.radius, z * this.radius);
            }
            gl.glEnd();
        }
    }

    public void createGLUSphere() {
        double rho;
        double theta;
        int j;
        int stacks = this.precision / 2;
        double ex = 0.0;
        double ey = 0.0;
        double ez = 0.0;
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        double drho = Math.PI / (double)stacks;
        double dtheta = Math.PI * 2 / (double)this.precision;
        double sindrho = Math.sin(drho);
        double cosdrho = Math.cos(drho);
        this.putNormal(0.0f, 0.0f, 1.0f);
        this.putVertex(0.0f, 0.0f, (float)this.radius);
        for (j = 0; j <= this.precision; ++j) {
            theta = j == this.precision ? 0.0 : (double)j * dtheta;
            ex = -Math.sin(theta) * sindrho;
            ey = Math.cos(theta) * sindrho;
            ez = cosdrho;
            px = (double)this.center[0] + this.radius * ex;
            py = (double)this.center[1] + this.radius * ey;
            pz = (double)this.center[2] + this.radius * ez;
            this.putNormal((float)ex, (float)ey, (float)ez);
            this.putVertex((float)px, (float)py, (float)pz);
        }
        int imin = 1;
        int imax = stacks - 1;
        for (int i = imin; i < imax; ++i) {
            rho = (double)i * drho;
            for (j = 0; j <= this.precision; ++j) {
                theta = j == this.precision ? 0.0 : (double)j * dtheta;
                ex = -Math.sin(theta) * Math.sin(rho);
                ey = Math.cos(theta) * Math.sin(rho);
                ez = Math.cos(rho);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                this.putNormal((float)ex, (float)ey, (float)ez);
                this.putVertex((float)px, (float)py, (float)pz);
                ex = -Math.sin(theta) * Math.sin(rho + drho);
                ey = Math.cos(theta) * Math.sin(rho + drho);
                ez = Math.cos(rho + drho);
                px = (double)this.center[0] + this.radius * ex;
                py = (double)this.center[1] + this.radius * ey;
                pz = (double)this.center[2] + this.radius * ez;
                this.putNormal((float)ex, (float)ey, (float)ez);
                this.putVertex((float)px, (float)py, (float)pz);
            }
        }
        this.putNormal(0.0f, 0.0f, -1.0f);
        this.putVertex(0.0f, 0.0f, (float)(-this.radius));
        rho = Math.PI - drho;
        for (j = this.precision; j >= 0; --j) {
            theta = j == this.precision ? 0.0 : (double)j * dtheta;
            ex = -Math.sin(theta) * Math.sin(rho);
            ey = Math.cos(theta) * Math.sin(rho);
            ez = Math.cos(rho);
            px = (double)this.center[0] + this.radius * ex;
            py = (double)this.center[1] + this.radius * ey;
            pz = (double)this.center[2] + this.radius * ez;
            this.putNormal((float)ex, (float)ey, (float)ez);
            this.putVertex((float)px, (float)py, (float)pz);
        }
    }

    public void createGLFlatSphere(GL gl) {
        gl.glBegin(6);
        gl.glNormal3d(0.0, 0.0, 1.0);
        gl.glVertex3d(0.0, 0.0, this.radius);
        for (int j = 0; j <= this.precision; ++j) {
            double theta = j == this.precision ? 0.0 : (double)j * this.dtheta;
            double x = Math.cos(theta);
            double y = Math.sin(theta);
            gl.glNormal3d(x, y, 0.5);
            gl.glVertex3d(x * this.radius, y * this.radius, 0.0);
        }
        gl.glEnd();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public float[] getCenter() {
        return this.center;
    }

    public void setCenter(float[] c) {
        this.center = c;
    }

    public void setCenter(float x, float y, float z) {
        this.center[0] = x;
        this.center[1] = y;
        this.center[2] = z;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
        this.drho = Math.PI / (double)this.precision;
        this.dtheta = 2.0 * this.drho;
    }

    @Override
    public int getVertexCount() {
        if (this.directDraw) {
            return this.precision * (this.precision - 1);
        }
        return (this.precision / 2 + 1) * this.precision - 2 * (this.precision - 1);
    }

    @Override
    public int getTriangleCount() {
        return this.precision * (this.precision + 1) - 2;
    }

    @Override
    public int getElementType() {
        return 5;
    }
}

