/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.render;

import chemaxon.common.util.GeomCalc;
import chemaxon.marvin.space.render.Renderer;

public class UniformSphere
extends Renderer {
    private static float[] center = new float[]{0.0f, 0.0f, 0.0f};
    private static float radius = 1.0f;
    private static float[] XPLUS = new float[]{1.0f, 0.0f, 0.0f};
    private static float[] XMIN = new float[]{-1.0f, 0.0f, 0.0f};
    private static float[] YPLUS = new float[]{0.0f, 1.0f, 0.0f};
    private static float[] YMIN = new float[]{0.0f, -1.0f, 0.0f};
    private static float[] ZPLUS = new float[]{0.0f, 0.0f, 1.0f};
    private static float[] ZMIN = new float[]{0.0f, 0.0f, -1.0f};
    private static final float[][][] octahedron = new float[][][]{new float[][]{XPLUS, YPLUS, ZPLUS}, new float[][]{YPLUS, XMIN, ZPLUS}, new float[][]{XMIN, YMIN, ZPLUS}, new float[][]{YMIN, XPLUS, ZPLUS}, new float[][]{XPLUS, ZMIN, YPLUS}, new float[][]{YPLUS, ZMIN, XMIN}, new float[][]{XMIN, ZMIN, YMIN}, new float[][]{YMIN, ZMIN, XPLUS}};
    private static final int DEFAULT_VERTEX_COUNT = 6;
    private static final int DEFAULT_TRIANGLE_COUNT = 8;
    private int vertexCount = 6;
    private int triangleCount = 8;
    private int maxlevel = 4;

    public UniformSphere() {
    }

    public UniformSphere(int precision) {
        this.maxlevel = precision;
    }

    public void create(boolean directDraw) {
        if (directDraw) {
            this.directDraw = true;
            this.triangleCount = (int)(8.0 * Math.pow(4.0, this.maxlevel - 1));
            this.vertexCount = this.triangleCount * 3;
            this.allocate();
            this.subdivideToDirectData();
        } else {
            this.directDraw = false;
            this.triangleCount = (int)(8.0 * Math.pow(4.0, this.maxlevel - 1));
            this.allocate();
            this.subdivide();
        }
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public int getTriangleCount() {
        return this.triangleCount;
    }

    @Override
    public int getElementType() {
        return 4;
    }

    public double getRadius() {
        return radius;
    }

    public void setRadius(float r) {
        radius = r;
    }

    public float[] getCenter() {
        return center;
    }

    public void setCenter(float[] c) {
        center = c;
    }

    public void setCenter(float x, float y, float z) {
        UniformSphere.center[0] = x;
        UniformSphere.center[1] = y;
        UniformSphere.center[2] = z;
    }

    public int getPrecision() {
        return this.maxlevel;
    }

    public void setPrecision(int n) {
        this.maxlevel = n;
    }

    private void subdivideToDirectData() {
        float[][][] polyhedron = new float[8][3][3];
        System.arraycopy(octahedron, 0, polyhedron, 0, octahedron.length);
        UniformSphere.XPLUS[0] = radius;
        UniformSphere.XMIN[0] = -radius;
        UniformSphere.YPLUS[1] = radius;
        UniformSphere.YMIN[1] = -radius;
        UniformSphere.ZPLUS[2] = radius;
        UniformSphere.ZMIN[2] = -radius;
        for (int level = 1; level < this.maxlevel; ++level) {
            float[][][] newPolyhedron = new float[polyhedron.length * 4][3][3];
            for (int i = 0; i < polyhedron.length; ++i) {
                float[][] triangle = polyhedron[i];
                int a = GeomCalc.half(triangle[0], triangle[1]);
                int b = GeomCalc.half(triangle[1], triangle[2]);
                int c = GeomCalc.half(triangle[0], triangle[2]);
                GeomCalc.normalize(a);
                GeomCalc.normalize(b);
                GeomCalc.normalize(c);
                GeomCalc.scale(a, radius);
                GeomCalc.scale(b, radius);
                GeomCalc.scale(c, radius);
                float[][] newTriangle = newPolyhedron[i * 4];
                newTriangle[0] = triangle[0];
                newTriangle[1] = GeomCalc.getFloatVector(a);
                newTriangle[2] = GeomCalc.getFloatVector(c);
                newTriangle = newPolyhedron[i * 4 + 1];
                newTriangle[0] = GeomCalc.getFloatVector(b);
                newTriangle[1] = triangle[2];
                newTriangle[2] = GeomCalc.getFloatVector(c);
                newTriangle = newPolyhedron[i * 4 + 2];
                newTriangle[0] = GeomCalc.getFloatVector(a);
                newTriangle[1] = GeomCalc.getFloatVector(b);
                newTriangle[2] = GeomCalc.getFloatVector(c);
                newTriangle = newPolyhedron[i * 4 + 3];
                newTriangle[0] = GeomCalc.getFloatVector(a);
                newTriangle[1] = triangle[1];
                newTriangle[2] = GeomCalc.getFloatVector(b);
                GeomCalc.deleteVector(a);
                GeomCalc.deleteVector(b);
                GeomCalc.deleteVector(c);
            }
            polyhedron = new float[newPolyhedron.length][3][3];
            System.arraycopy(newPolyhedron, 0, polyhedron, 0, newPolyhedron.length);
        }
        for (int i = 0; i < polyhedron.length; ++i) {
            this.vertices.put(polyhedron[i][0]);
            this.vertices.put(polyhedron[i][1]);
            this.vertices.put(polyhedron[i][2]);
            this.normals.put(polyhedron[i][0]);
            this.normals.put(polyhedron[i][1]);
            this.normals.put(polyhedron[i][2]);
        }
    }

    private void subdivide() {
    }
}

