/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.util;

import chemaxon.common.util.GeomCalc;
import chemaxon.util.StringUtil;
import com.sun.opengl.util.GLUT;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

public class GLText {
    public static final int SMALL_CHARS = 6;
    public static final int MED_CHARS = 7;
    public static final int LARGE_CHARS = 8;
    private GL gl;
    private GLU glu;
    private GLUT glut = new GLUT();
    private int font = 8;
    private byte[] foreground = new byte[]{127, 127, 127, 127};
    private byte[] background = new byte[]{0, 0, 0, 127};
    private byte[] border = new byte[]{127, 127, 127, 127};
    private double[] textPosWindow = new double[3];
    private float borderWidth = 1.0f;
    private float textLineWidth = 2.0f;
    private float scale = 1.0f;
    private boolean drawBorder = true;
    private boolean drawBackground = true;
    private int width;
    private int height;

    public GLText(GL gl, GLU glu) {
        this.gl = gl;
        this.glu = glu;
    }

    public double[] getTextPosition() {
        return this.textPosWindow;
    }

    public double getTextPositionX() {
        return this.textPosWindow[0];
    }

    public double getTextPositionY() {
        return this.textPosWindow[1];
    }

    public void printString(int position, String s) {
        this.gl.glColor3bv(this.foreground, 0);
        this.gl.glRasterPos3d((double)GeomCalc.getX(position), (double)GeomCalc.getY(position), (double)GeomCalc.getZ(position));
        this.glut.glutBitmapString(this.font, s);
    }

    public void printString2D(double x, double y, String s) {
        this.gl.glColor4bv(this.foreground, 0);
        this.gl.glRasterPos2d(x, y);
        this.glut.glutBitmapString(this.font, s);
    }

    public void drawLabel3D(int textPosition, String text, int irm) {
        float x = GeomCalc.getX(textPosition);
        float y = GeomCalc.getY(textPosition);
        float z = GeomCalc.getZ(textPosition);
        int w = this.glut.glutStrokeLength(0, text);
        int h = 119;
        this.gl.glPushMatrix();
        this.gl.glTranslated((double)x, (double)y, (double)z);
        this.gl.glMultMatrixf(GeomCalc.getMatrix(irm), 0);
        this.gl.glTranslated((double)0.3f, (double)0.3f, (double)0.3f);
        this.gl.glScalef(this.scale / 100.0f, this.scale / 100.0f, this.scale / 100.0f);
        if (this.drawBackground) {
            this.gl.glColor4bv(this.background, 0);
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glBegin(7);
            this.gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this.gl.glVertex3f(0.0f, 0.0f, 0.0f);
            this.gl.glVertex3f((float)(w + 2), 0.0f, 0.0f);
            this.gl.glVertex3f((float)(w + 2), (float)(h + 3), 0.0f);
            this.gl.glVertex3f(0.0f, (float)(h + 3), 0.0f);
            this.gl.glEnd();
        }
        if (this.drawBorder) {
            this.gl.glLineWidth(this.borderWidth);
            this.gl.glColor4bv(this.border, 0);
            this.gl.glPolygonMode(1032, 6913);
            this.gl.glBegin(7);
            this.gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this.gl.glVertex3f(0.0f, 0.0f, 0.0f);
            this.gl.glVertex3f((float)(w + 2), 0.0f, 0.0f);
            this.gl.glVertex3f((float)(w + 2), (float)(h + 3), 0.0f);
            this.gl.glVertex3f(0.0f, (float)(h + 3), 0.0f);
            this.gl.glEnd();
        }
        this.gl.glColor3bv(this.foreground, 0);
        this.gl.glLineWidth(this.textLineWidth);
        this.gl.glTranslated(1.0, 3.0, 1.0);
        int l = this.glut.glutStrokeLength(0, text);
        this.gl.glScalef((float)w / (float)l, (float)w / (float)l, (float)w / (float)l);
        this.glut.glutStrokeString(0, text);
        this.gl.glPopMatrix();
        this.gl.glPolygonMode(1032, 6914);
    }

    public void drawLabel(int mode, int mousex, int mousey, int textPosition, String text, int[] viewport, double[] modelview, double[] projection) {
        this.countTextPosWindow(textPosition, viewport, modelview, projection);
        this.drawLabel(mode, mousex, mousey, text, viewport);
    }

    public void drawLabel(int mode, int mousex, int mousey, int textPosition, String text) {
        int[] viewport = new int[4];
        this.gl.glGetIntegerv(2978, viewport, 0);
        this.countTextPosWindow(textPosition, viewport);
        this.drawLabel(mode, mousex, mousey, text, viewport);
    }

    private void drawLabel(int mode, int mousex, int mousey, String text, int[] viewport) {
        this.textPosWindow[0] = this.textPosWindow[0] - (double)viewport[0];
        this.textPosWindow[1] = this.textPosWindow[1] - (double)viewport[1];
        int x1 = (int)this.textPosWindow[0];
        int y1 = (int)this.textPosWindow[1];
        int x2 = x1 + this.getBitmapLength(this.font, text);
        int y2 = y1 + this.getBitmapHeight(this.font);
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDisable(2896);
        this.gl.glDisable(2929);
        if (mode == 7170) {
            this.glu.gluPickMatrix((double)mousex, (double)mousey, 5.0, 5.0, viewport, 0);
        }
        this.gl.glOrtho(0.0, (double)viewport[2], 0.0, (double)viewport[3], -1.0, 1.0);
        if (this.drawBackground) {
            this.gl.glColor4bv(this.background, 0);
            this.gl.glRectd((double)(x1 - 2), (double)(y1 - 2), (double)(x2 + 2), (double)(y2 + 2));
        }
        if (this.drawBorder) {
            this.gl.glLineWidth(this.borderWidth);
            this.gl.glColor4bv(this.border, 0);
            this.gl.glPolygonMode(1032, 6913);
            this.gl.glRectd((double)(x1 - 2), (double)(y1 - 2), (double)(x2 + 2), (double)(y2 + 2));
            this.gl.glPolygonMode(1032, 6914);
        }
        this.printString2D(x1, y1, text);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.gl.glEnable(2929);
        this.gl.glEnable(2896);
    }

    public void drawLabelRelatively(int mode, int mousex, int mousey, int textPosition, String text, int shiftx, int shifty) {
        int[] viewport = new int[4];
        this.gl.glGetIntegerv(2978, viewport, 0);
        this.countTextPosWindow(textPosition, viewport);
        this.textPosWindow[0] = this.textPosWindow[0] - (double)viewport[0];
        this.textPosWindow[1] = this.textPosWindow[1] - (double)viewport[1];
        this.drawLabelRelatively(mode, mousex, mousey, text, shiftx, shifty, true);
    }

    public void drawLabelRelatively(int mode, int mousex, int mousey, int textPosition, String text, int shiftx, int shifty, boolean drawRelation) {
        int[] viewport = new int[4];
        this.gl.glGetIntegerv(2978, viewport, 0);
        this.countTextPosWindow(textPosition, viewport);
        this.textPosWindow[0] = this.textPosWindow[0] - (double)viewport[0];
        this.textPosWindow[1] = this.textPosWindow[1] - (double)viewport[1];
        this.drawLabelRelatively(mode, mousex, mousey, text, shiftx, shifty, drawRelation);
    }

    public void drawLabelRelatively(int mode, int mousex, int mousey, int x, int y, String text, int shiftx, int shifty) {
        int[] viewport = new int[4];
        this.gl.glGetIntegerv(2978, viewport, 0);
        this.textPosWindow[0] = x;
        this.textPosWindow[1] = viewport[3] - y;
        this.drawLabelRelatively(mode, mousex, mousey, text, shiftx, shifty, false);
    }

    public void drawLabelRelatively(int mode, int mousex, int mousey, int x, int y, String text, int shiftx, int shifty, boolean drawRelation) {
        int[] viewport = new int[4];
        this.gl.glGetIntegerv(2978, viewport, 0);
        this.textPosWindow[0] = x;
        this.textPosWindow[1] = viewport[3] - y;
        this.drawLabelRelatively(mode, mousex, mousey, text, shiftx, shifty, drawRelation);
    }

    private void drawLabelRelatively(int mode, int mousex, int mousey, String text, int shiftx, int shifty, boolean drawRelation) {
        int[] viewport = new int[4];
        this.gl.glGetIntegerv(2978, viewport, 0);
        int x1 = (int)this.textPosWindow[0] + shiftx;
        int y1 = (int)this.textPosWindow[1] + shifty;
        String[] textlines = StringUtil.split(text, "\n");
        int height = this.getBitmapHeight(this.font);
        int x2 = x1 + this.getWidth(textlines);
        int y2 = y1 + height * textlines.length;
        this.width = x2 - x1;
        this.height = y2 - y1;
        if (x2 > viewport[2]) {
            x1 -= x2 - viewport[2];
            x2 = viewport[2];
        }
        if (x1 < 0) {
            x2 -= x1;
            x1 = 0;
        }
        if (y2 > viewport[3]) {
            y1 -= y2 - viewport[3];
            y2 = viewport[3];
        }
        if (y1 < 0) {
            y2 -= y1;
            y1 = 0;
        }
        this.gl.glDisable(2896);
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDisable(2929);
        if (mode == 7170) {
            this.glu.gluPickMatrix((double)mousex, (double)mousey, 5.0, 5.0, viewport, 0);
        }
        this.gl.glOrtho(0.0, (double)viewport[2], 0.0, (double)viewport[3], -1.0, 1.0);
        this.gl.glColor3bv(this.foreground, 0);
        this.gl.glLineWidth(1.0f);
        if (drawRelation) {
            this.gl.glEnable(3042);
            this.gl.glBegin(1);
            this.gl.glVertex2d((double)x1, (double)y1);
            this.gl.glVertex2d((double)((int)this.textPosWindow[0]), (double)((int)this.textPosWindow[1]));
            this.gl.glEnd();
            this.gl.glDisable(3042);
        }
        this.textPosWindow[0] = x1;
        this.textPosWindow[1] = y1;
        if (this.drawBackground) {
            this.gl.glColor4bv(this.background, 0);
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glRectd((double)(x1 - 2), (double)(y1 - 2), (double)(x2 + 2), (double)(y2 + 2));
        }
        if (this.drawBorder) {
            this.gl.glLineWidth(this.borderWidth);
            this.gl.glColor4bv(this.border, 0);
            this.gl.glPolygonMode(1032, 6913);
            this.gl.glRectd((double)(x1 - 2), (double)(y1 - 2), (double)(x2 + 2), (double)(y2 + 2));
        }
        if (textlines.length == 1) {
            this.printString2D(x1, y1, text);
        } else {
            for (int i = 0; i < textlines.length; ++i) {
                this.printString2D(x1, y1 + (textlines.length - 1 - i) * height, textlines[i]);
            }
        }
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glEnable(2929);
        this.gl.glEnable(2896);
    }

    private void countTextPosWindow(int textPosition, int[] viewport) {
        double[] modelview = new double[16];
        double[] projection = new double[16];
        this.gl.glGetDoublev(2982, modelview, 0);
        this.gl.glGetDoublev(2983, projection, 0);
        this.glu.gluProject((double)GeomCalc.getX(textPosition), (double)GeomCalc.getY(textPosition), (double)GeomCalc.getZ(textPosition), modelview, 0, projection, 0, viewport, 0, this.textPosWindow, 0);
    }

    private void countTextPosWindow(int textPosition, int[] viewport, double[] modelview, double[] projection) {
        this.glu.gluProject((double)GeomCalc.getX(textPosition), (double)GeomCalc.getY(textPosition), (double)GeomCalc.getZ(textPosition), modelview, 0, projection, 0, viewport, 0, this.textPosWindow, 0);
    }

    public void drawLabel2D(int x, int y, int w, int h, String text) {
        String[] textlines = StringUtil.split(text, "\n");
        this.gl.glDisable(2896);
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDisable(2929);
        this.gl.glOrtho(0.0, (double)w, 0.0, (double)h, -1.0, 1.0);
        int height = this.getBitmapHeight(this.font);
        int x2 = x + this.getWidth(textlines);
        int y2 = y + height * textlines.length;
        if (this.drawBackground) {
            this.gl.glColor3bv(this.background, 0);
            this.gl.glPolygonMode(1032, 6914);
            this.gl.glRectd((double)(x - 2), (double)(y - 2), (double)(x2 + 2), (double)(y2 + 2));
        }
        if (this.drawBorder) {
            this.gl.glLineWidth(this.borderWidth);
            this.gl.glColor3bv(this.border, 0);
            this.gl.glPolygonMode(1032, 6913);
            this.gl.glRectd((double)(x - 2), (double)(y - 2), (double)(x2 + 2), (double)(y2 + 2));
        }
        if (textlines.length == 1) {
            this.printString2D(x, y, text);
        } else {
            for (int i = 0; i < textlines.length; ++i) {
                this.printString2D(x, y + (textlines.length - 1 - i) * height, textlines[i]);
            }
        }
        this.gl.glPolygonMode(1032, 6914);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5888);
        this.gl.glPopMatrix();
        this.gl.glEnable(2929);
        this.gl.glEnable(2896);
    }

    private int getWidth(String[] textlines) {
        int maxlength = 0;
        for (int i = 0; i < textlines.length; ++i) {
            int l = this.getBitmapLength(this.font, textlines[i]);
            if (l <= maxlength) continue;
            maxlength = l;
        }
        return maxlength;
    }

    public void setFont(int font) {
        this.font = font;
    }

    public void setScale(float s) {
        this.scale = s;
    }

    public void setBorderDrawing(boolean b) {
        this.drawBorder = b;
    }

    public void setForegroundColor(byte[] color) {
        this.foreground[0] = color[0];
        this.foreground[1] = color[1];
        this.foreground[2] = color[2];
    }

    public void setBackgroundColor(byte[] color) {
        if (color == null) {
            this.drawBackground = false;
        } else {
            this.drawBackground = true;
            this.background[0] = color[0];
            this.background[1] = color[1];
            this.background[2] = color[2];
        }
    }

    public void setBorderColor(byte[] color) {
        if (color == null) {
            this.drawBorder = false;
        } else {
            this.drawBorder = true;
            this.border[0] = color[0];
            this.border[1] = color[1];
            this.border[2] = color[2];
        }
    }

    public void setForegroundTransparency(byte alpha) {
        this.foreground[3] = alpha;
    }

    public void setBackgroundTransparency(byte alpha) {
        this.background[3] = alpha;
    }

    public void setBorderTransparency(byte alpha) {
        this.border[3] = alpha;
    }

    public void setBorderWidth(float w) {
        this.borderWidth = w;
    }

    public int getBitmapLength(int font, String string) {
        return this.glut.glutBitmapLength(font, string);
    }

    public int getBitmapHeight(int font) {
        switch (font) {
            case 6: {
                return 10;
            }
            case 7: {
                return 12;
            }
            case 8: {
                return 18;
            }
        }
        return 18;
    }

    public int getLastWidth() {
        return this.width;
    }

    public int getLastHeight() {
        return this.height;
    }
}

