/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.util;

import java.util.Arrays;

public class GraphPartitions {
    protected int[][] adjMat = null;
    private boolean[] firstPartition = null;
    private int firstPartitionSize = 0;
    private int firstNode;
    private int secondNode;

    public void setGraph(int[][] adjMat) {
        this.adjMat = adjMat;
    }

    public boolean partition(int firstNode, int secondNode) {
        this.init();
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        return this.dfs(firstNode, secondNode, 0);
    }

    public int[] getFirstPartition() {
        int[] lp = new int[this.firstPartitionSize - 1];
        int lpi = 0;
        for (int i = 0; i < this.adjMat.length; ++i) {
            if (i == this.firstNode || !this.firstPartition[i]) continue;
            lp[lpi++] = i;
        }
        return lp;
    }

    public int[] getSecondPartition() {
        int[] rp = new int[this.adjMat.length - this.firstPartitionSize - 1];
        int lpi = 0;
        for (int i = 0; i < this.adjMat.length; ++i) {
            if (i == this.secondNode || this.firstPartition[i]) continue;
            rp[lpi++] = i;
        }
        return rp;
    }

    private boolean dfs(int first, int second, int depth) {
        if (this.firstPartition[first]) {
            return true;
        }
        this.firstPartition[first] = true;
        ++this.firstPartitionSize;
        int[] neighs = this.adjMat[first];
        for (int i = 0; i < neighs.length; ++i) {
            if (neighs[i] == second) {
                if (depth == 0) continue;
                return false;
            }
            if (this.dfs(neighs[i], second, depth + 1)) continue;
            return false;
        }
        return true;
    }

    private void init() {
        this.alloc();
        Arrays.fill(this.firstPartition, false);
        this.firstPartitionSize = 0;
    }

    private void alloc() {
        if (this.firstPartition == null || this.adjMat.length > this.firstPartition.length) {
            this.firstPartition = new boolean[this.adjMat.length];
        }
    }
}

