/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.util;

import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;

public class ImageUtils {
    public static BufferedImage readPixels(GL gl, int x, int y, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        ImageUtils.readPixels(gl, x, y, width, height, image);
        return image;
    }

    public static void readPixels(GL gl, int x, int y, int width, int height, BufferedImage target) {
        int[] rawData = new int[width * height];
        gl.glPushClientAttrib(1);
        gl.glPixelStorei(3333, 1);
        gl.glReadPixels(x, y, width, height, 6408, 32821, (Buffer)IntBuffer.wrap(rawData));
        gl.glPopClientAttrib();
        ImageUtils.convertGLToJava(width, height, rawData);
        target.setRGB(0, 0, width, height, rawData, 0, width);
    }

    public static void drawPixels(GL gl, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rawData = image.getRGB(0, 0, width, height, null, 0, width);
        ImageUtils.convertJavaToGL(width, height, rawData);
        gl.glPushClientAttrib(1);
        gl.glPixelStorei(3317, 4);
        gl.glDrawPixels(width, height, 6408, 32821, (Buffer)IntBuffer.wrap(rawData));
        gl.glPopClientAttrib();
    }

    public static void texImage2D(GL gl, BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rawData = image.getRGB(0, 0, width, height, null, 0, width);
        ImageUtils.convertJavaToGL(width, height, rawData);
        gl.glPushClientAttrib(1);
        gl.glPixelStorei(3317, 4);
        gl.glTexImage2D(3553, 0, 4, width, height, 0, 6408, 32821, (Buffer)IntBuffer.wrap(rawData));
        gl.glPopClientAttrib();
    }

    private static void convertJavaToGL(int width, int height, int[] rawData) {
        int y1 = 0;
        for (int y2 = height - 1; y2 >= y1; ++y1, --y2) {
            for (int x = 0; x < width; ++x) {
                int rgba2;
                int argb1 = rawData[y1 * width + x];
                int argb2 = rawData[y2 * width + x];
                int rgba1 = argb1 << 8 | argb1 >>> 24;
                rawData[y1 * width + x] = rgba2 = argb2 << 8 | argb2 >>> 24;
                rawData[y2 * width + x] = rgba1;
            }
        }
    }

    private static void convertGLToJava(int width, int height, int[] rawData) {
        int y1 = 0;
        for (int y2 = height - 1; y2 >= y1; ++y1, --y2) {
            for (int x = 0; x < width; ++x) {
                int argb2;
                int rgba1 = rawData[y1 * width + x];
                int rgba2 = rawData[y2 * width + x];
                int argb1 = rgba1 << 24 | rgba1 >>> 8;
                rawData[y1 * width + x] = argb2 = rgba2 << 24 | rgba2 >>> 8;
                rawData[y2 * width + x] = argb1;
            }
        }
    }

    private static void printData(int w, int h, int[] data) {
        System.out.println("");
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                System.out.print(data[i * w + j] + " ");
            }
            System.out.println("");
        }
        System.out.println("");
    }
}

