/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.util;

public class Palette {
    private double min = 0.0;
    private double max = 1.0;
    private boolean twoPolePalette = false;
    private double center = 0.0;
    private double lowerCutoff = 0.0;
    private double upperCutoff = 0.0;
    private boolean smoothCutoff = true;
    private float[][] colors = new float[][]{{0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f}};
    private int cp = 2;

    public Palette() {
    }

    public Palette(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public Palette(double min, double max, double center) {
        this.min = min;
        this.max = max;
        this.center = center;
        this.twoPolePalette = true;
    }

    public void setMin(double m) {
        this.min = m;
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double m) {
        this.max = m;
    }

    public double getMax() {
        return this.max;
    }

    public void setLowerCutoff(double c) {
        this.lowerCutoff = c;
    }

    public void setUpperCutoff(double c) {
        this.upperCutoff = c;
    }

    public void smoothColorToCutoffValues(boolean b) {
        this.smoothCutoff = b;
    }

    public void clear() {
        this.colors = new float[0][3];
        this.cp = 0;
    }

    public boolean inside(double v) {
        return v >= this.min && v <= this.max;
    }

    public void putColor(float[] c) {
        this.checkSpace();
        this.colors[this.cp][0] = c[0];
        this.colors[this.cp][1] = c[1];
        this.colors[this.cp][2] = c[2];
        ++this.cp;
    }

    public void putColor(byte[] c) {
        this.checkSpace();
        this.colors[this.cp][0] = (float)c[0] / 127.0f;
        this.colors[this.cp][1] = (float)c[1] / 127.0f;
        this.colors[this.cp][2] = (float)c[2] / 127.0f;
        ++this.cp;
    }

    public void putColors(byte[][] colors) {
        this.checkSpace(colors.length);
        for (int i = 0; i < colors.length; ++i) {
            this.putColor(colors[i]);
        }
    }

    public float[] getColor(double v) {
        if (this.cp == 0) {
            return new float[3];
        }
        if (!this.smoothCutoff) {
            return this.getRoughTwoPoleColor(v);
        }
        if (this.twoPolePalette) {
            return this.getTwoPoleColor(v);
        }
        float whole = this.max == this.min ? 0.0f : (float)((v - this.min) / (this.max - this.min)) * (float)(this.cp - 1);
        int index = (int)whole;
        if (index < 0) {
            return this.colors[0];
        }
        if (index >= this.colors.length - 1) {
            return this.colors[this.cp - 1];
        }
        float weight = whole - (float)index;
        float[] c = new float[]{(1.0f - weight) * this.colors[index][0] + weight * this.colors[index + 1][0], (1.0f - weight) * this.colors[index][1] + weight * this.colors[index + 1][1], (1.0f - weight) * this.colors[index][2] + weight * this.colors[index + 1][2]};
        this.checkColor(c);
        return c;
    }

    private float[] getTwoPoleColor(double v) {
        int centerColor = this.cp / 2;
        if (v < this.lowerCutoff) {
            float whole = this.lowerCutoff == this.min ? 0.0f : (float)((v - this.min) / (this.lowerCutoff - this.min)) * (float)centerColor;
            int index = (int)whole;
            if (index < 0) {
                return this.colors[0];
            }
            if (index >= centerColor) {
                return this.colors[centerColor];
            }
            float weight = whole - (float)index;
            float[] c = new float[]{(1.0f - weight) * this.colors[index][0] + weight * this.colors[index + 1][0], (1.0f - weight) * this.colors[index][1] + weight * this.colors[index + 1][1], (1.0f - weight) * this.colors[index][2] + weight * this.colors[index + 1][2]};
            this.checkColor(c);
            return c;
        }
        if (v < this.upperCutoff) {
            return this.colors[centerColor];
        }
        float whole = this.max == this.upperCutoff ? 0.0f : (float)((v - this.upperCutoff) / (this.max - this.upperCutoff)) * (float)centerColor;
        int index = (int)whole;
        if (index < 0) {
            return this.colors[centerColor];
        }
        if (index + centerColor >= this.colors.length - 1) {
            return this.colors[this.colors.length - 1];
        }
        float weight = whole - (float)index;
        int i = index + centerColor;
        float[] c = new float[]{(1.0f - weight) * this.colors[i][0] + weight * this.colors[i + 1][0], (1.0f - weight) * this.colors[i][1] + weight * this.colors[i + 1][1], (1.0f - weight) * this.colors[i][2] + weight * this.colors[i + 1][2]};
        this.checkColor(c);
        return c;
    }

    private float[] getRoughTwoPoleColor(double v) {
        if (v <= this.lowerCutoff) {
            float whole = (float)((v - this.min) / (0.0 - this.min)) * (float)(this.cp / 2);
            if (whole < 0.0f) {
                return this.colors[0];
            }
            if (whole >= (float)(this.cp / 2)) {
                return this.colors[this.cp / 2];
            }
            int i = (int)whole;
            float weight = whole - (float)i;
            float[] c = new float[]{(1.0f - weight) * this.colors[i][0] + weight * this.colors[i + 1][0], (1.0f - weight) * this.colors[i][1] + weight * this.colors[i + 1][1], (1.0f - weight) * this.colors[i][2] + weight * this.colors[i + 1][2]};
            this.checkColor(c);
            return c;
        }
        if (v < this.upperCutoff) {
            return this.colors[this.cp / 2];
        }
        float whole = (float)(v / this.max) * (float)(this.cp / 2);
        if (whole < 0.0f) {
            return this.colors[this.cp / 2];
        }
        if (whole >= (float)(this.cp / 2)) {
            return this.colors[this.cp - 1];
        }
        int i = (int)whole;
        float weight = whole - (float)i;
        float[] c = new float[]{(1.0f - weight) * this.colors[i += this.cp / 2][0] + weight * this.colors[i + 1][0], (1.0f - weight) * this.colors[i][1] + weight * this.colors[i + 1][1], (1.0f - weight) * this.colors[i][2] + weight * this.colors[i + 1][2]};
        this.checkColor(c);
        return c;
    }

    public byte[] getByteColor(double v) {
        float[] fc = this.getColor(v);
        byte[] rc = new byte[]{(byte)(fc[0] * 127.0f), (byte)(fc[1] * 127.0f), (byte)(fc[2] * 127.0f)};
        return rc;
    }

    private void checkSpace() {
        if (this.cp < this.colors.length) {
            return;
        }
        int length = this.colors.length > 0 ? this.colors.length : 2;
        float[][] newColors = new float[length + 1][3];
        System.arraycopy(this.colors, 0, newColors, 0, this.colors.length);
        this.colors = newColors;
    }

    private void checkSpace(int requiredSpace) {
        int length = this.cp + requiredSpace;
        if (length < this.colors.length) {
            return;
        }
        float[][] newColors = new float[length][3];
        System.arraycopy(this.colors, 0, newColors, 0, this.colors.length);
        this.colors = newColors;
    }

    private void checkColor(float[] c) {
        float f = c[0] > 1.0f ? 1.0f : (c[0] = c[0] < 0.0f ? 0.0f : c[0]);
        float f2 = c[1] > 1.0f ? 1.0f : (c[1] = c[1] < 0.0f ? 0.0f : c[1]);
        c[2] = c[2] > 1.0f ? 1.0f : (c[2] < 0.0f ? 0.0f : c[2]);
    }

    public void printColor(float[] c) {
        System.out.println("[ " + c[0] + ", " + c[1] + ", " + c[2] + "]");
    }

    public void printColor(int i) {
        System.out.println("[ " + this.colors[i][0] + ", " + this.colors[i][1] + ", " + this.colors[i][2] + "]");
    }

    public String toString() {
        String palette = "";
        palette = palette + "Palette [ Min:" + this.min + ", Max:" + this.max + " ]";
        palette = palette + "\n";
        for (int i = 0; i < this.cp - 1; ++i) {
            palette = palette + "[ " + this.colors[i][0] + ", " + this.colors[i][1] + ", " + this.colors[i][2] + "]";
            palette = palette + "\n";
        }
        return palette;
    }
}

