/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.space.util;

import chemaxon.common.util.GeomCalc;
import chemaxon.struc.MacroMolecule;
import chemaxon.struc.MoleculeIterators;

public class SecondaryStructureDetection {
    MacroMolecule.Protein protein;
    public static final int HELIX = 2;
    public static final int SHEET = 3;
    public static final int TURN = 1;
    public static final int NONE = 0;
    int compared = 0;
    int mismatch = 0;
    int[] backboneAtomTypes;

    public int[] detectSecondaryStructure(MacroMolecule.Protein p) {
        MoleculeIterators.AtomPropertyInterface props = p.getAtomProperty();
        MacroMolecule.Protein.CAlphaAtomIterator catoms = p.getCAlphaAtomIterator();
        int backboneAtomCount = catoms.getCaCoCount();
        this.backboneAtomTypes = new int[backboneAtomCount];
        int[][] backbone = new int[backboneAtomCount][3];
        int i = 0;
        catoms.reset();
        while (catoms.hasNext()) {
            if (catoms.getX() != Float.POSITIVE_INFINITY && catoms.getCarbonylOxygen() != -1) {
                int ca = catoms.current();
                int c = catoms.getCarbon();
                int n = catoms.getNitrogen();
                backbone[i][0] = GeomCalc.newVector(props.getX(ca), props.getY(ca), props.getZ(ca));
                backbone[i][1] = GeomCalc.newVector(props.getX(c), props.getY(c), props.getZ(c));
                backbone[i][2] = GeomCalc.newVector(props.getX(n), props.getY(n), props.getZ(n));
                ++i;
            }
            catoms.next();
        }
        i = 0;
        catoms.reset();
        while (catoms.hasNext()) {
            if (catoms.getX() != Float.POSITIVE_INFINITY && catoms.getCarbonylOxygen() != -1) {
                if (i == 0 || i == backboneAtomCount - 1) {
                    this.backboneAtomTypes[i] = catoms.getSecondaryStructureType();
                    if (i == 0) {
                        ++i;
                    }
                } else {
                    int type;
                    double phi = GeomCalc.dihedral(backbone[i - 1][1], backbone[i][2], backbone[i][0], backbone[i][1]);
                    double psi = GeomCalc.dihedral(backbone[i][2], backbone[i][0], backbone[i][1], backbone[i + 1][2]);
                    this.backboneAtomTypes[i] = type = this.classify(phi, psi, this.backboneAtomTypes[i - 1]);
                    ++i;
                }
            }
            catoms.next();
        }
        this.removeSingles();
        return this.backboneAtomTypes;
    }

    private void removeSingles() {
        for (int i = 1; i < this.backboneAtomTypes.length - 1; ++i) {
            if (this.backboneAtomTypes[i] == 0 || this.backboneAtomTypes[i] == this.backboneAtomTypes[i - 1] || this.backboneAtomTypes[i] == this.backboneAtomTypes[i + 1]) continue;
            this.backboneAtomTypes[i] = 0;
        }
    }

    private int classify(double phi, double psi, int prevType) {
        if (phi >= -100.0 && phi <= -40.0 && psi >= -65.0 && psi <= -40.0) {
            return 2;
        }
        if (prevType != 3 && phi <= 90.0 && phi >= 60.0 && psi <= -130.0 && psi >= -160.0) {
            return 0;
        }
        if (phi <= 170.0 && phi >= 60.0 && psi <= -100.0 && psi >= -173.0) {
            return 3;
        }
        if (phi <= 90.0 && phi >= 38.0 && psi >= 20.0 && psi <= 70.0) {
            return 2;
        }
        return 0;
    }

    private void compare(int type, MacroMolecule.Protein.CAlphaAtomIterator batoms, int i, double phi, double psi) {
        ++this.compared;
        if (batoms.getSecondaryStructureType() == 1 && type == 0) {
            return;
        }
        if (batoms.getSecondaryStructureType() != type) {
            ++this.mismatch;
        }
    }
}

