/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ListWithDisabledItemsRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 1L;
    private boolean[] isEnabled;

    public ListWithDisabledItemsRenderer(int nItems) {
        this.setOpaque(true);
        this.isEnabled = new boolean[nItems];
        for (int i = 0; i < nItems; ++i) {
            this.isEnabled[i] = true;
        }
    }

    public void setEnabled(int index, boolean isEnabled) {
        this.isEnabled[index] = isEnabled;
    }

    public boolean isEnabled(int index) {
        return this.isEnabled[index];
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setText(value.toString());
        if (index > -1 && this.isEnabled[index]) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(UIManager.getColor("Label.disabledForeground"));
        }
        this.setFont(list.getFont());
        return this;
    }
}

