/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import chemaxon.marvin.swing.ActionMenuItem;
import chemaxon.marvin.swing.ActionMenuItemCleanUp;
import chemaxon.marvin.swing.DelegatingAction;
import chemaxon.marvin.swing.MActionComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MAction
extends DelegatingAction {
    private static final long serialVersionUID = 7192487516820206101L;
    public static final int AUTORM = 4;
    public static final int NO_MNEMONIC = 8;
    public static final int IN_POPUP = 32;
    public static final int USE_DO_LABEL = 16;
    public static final int USE_WHAT_LABEL = 64;
    public static final int DISABLE_ACCELERATOR = 128;
    public static final int POPUP = 44;
    private String actionCommand;
    private String labelDo = null;
    private String labelWhat = null;
    private KeyStroke[] accelerators;
    private transient Object lastTarget = null;

    public MAction(String cmd, String label) {
        this(cmd, label, (KeyStroke)null);
    }

    public MAction(String cmd, String label, KeyStroke accel) {
        this.setNameAndMnemonic(label);
        this.setActionCommand(cmd);
        if (accel != null) {
            this.putValue("AcceleratorKey", accel);
        }
        this.accelerators = null;
    }

    public MAction(String cmd, String label, KeyStroke[] accel) {
        this.setNameAndMnemonic(label);
        this.setActionCommand(cmd);
        if (accel != null) {
            this.putValue("AcceleratorKey", accel[0]);
        }
        this.accelerators = accel;
    }

    public void setActionCommand(String cmd) {
        this.actionCommand = cmd;
        this.putValue("ActionCommandKey", cmd);
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setNameAndMnemonic(String label) {
        if (label.startsWith("'") && label.length() > 3 && label.charAt(2) == '\'') {
            this.putValue("MnemonicKey", new Integer(Character.toUpperCase(label.charAt(1))));
            label = label.substring(3);
        } else {
            this.putValue("MnemonicKey", null);
        }
        int ido = label.indexOf("[DO:]");
        int iwhat = label.indexOf("[WHAT:]");
        if (ido >= 0 && iwhat >= 0) {
            int i = Math.min(ido, iwhat);
            this.putValue("Name", label.substring(0, i));
            this.labelDo = label.substring(ido + 5, iwhat > ido ? iwhat : label.length());
            this.labelWhat = label.substring(iwhat + 7, ido > iwhat ? ido : label.length());
        } else if (ido >= 0) {
            this.putValue("Name", label.substring(0, ido));
            this.labelDo = label.substring(ido + 5);
            this.labelWhat = null;
        } else if (iwhat >= 0) {
            this.putValue("Name", label.substring(0, iwhat));
            this.labelDo = null;
            this.labelWhat = label.substring(iwhat + 7);
        } else {
            this.putValue("Name", label);
            this.labelDo = null;
            this.labelWhat = null;
        }
    }

    private static void setMenuItem(JMenuItem mi, String label) {
        if (label.startsWith("'") && label.length() > 3 && label.charAt(2) == '\'') {
            mi.setMnemonic(Character.toUpperCase(label.charAt(1)));
            label = label.substring(3);
        }
        mi.setText(label);
    }

    protected void setMenuItem(JMenuItem mi, int flags) {
        if ((flags & 8) != 0) {
            mi.setMnemonic(0);
        }
        if ((flags & 0x10) != 0 && this.labelDo != null) {
            MAction.setMenuItem(mi, this.labelDo);
        }
        if ((flags & 0x40) != 0 && this.labelWhat != null) {
            MAction.setMenuItem(mi, this.labelWhat);
        }
        if ((flags & 0x80) != 0) {
            SwingUtilities.replaceUIInputMap(mi, 2, null);
        }
    }

    public int getMnemonic() {
        Integer v = (Integer)this.getValue("MnemonicKey");
        return v != null ? v : 0;
    }

    public Object getCurrentTarget() {
        return this.lastTarget;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.setActionState(ev);
        Object src = ev.getSource();
        if (src instanceof MActionComponent) {
            this.lastTarget = ((MActionComponent)src).getCurrentTarget();
        }
        this.doAction(ev);
        super.actionPerformed(ev);
    }

    protected void setActionState(ActionEvent ev) {
    }

    protected void doAction(ActionEvent ev) {
    }

    public final Component addTo(Container menu) {
        return this.addTo(menu, 0, null);
    }

    public final Component addTo(Container menu, int flags) {
        return this.addTo(menu, flags, null);
    }

    public Component addTo(Container menu, int flags, Object t) {
        ActionMenuItem mi = new ActionMenuItem(this, t);
        this.setMenuItem(mi, flags);
        menu.add(mi);
        if ((flags & 4) != 0) {
            new ActionMenuItemCleanUp(menu, mi);
        }
        return mi;
    }

    public void insertTo(Container menu, int i, int flags) {
        ActionMenuItem mi = new ActionMenuItem(this);
        this.setMenuItem(mi, flags);
        if (menu instanceof JMenu) {
            ((JMenu)menu).insert(mi, i);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).insert(mi, i);
        } else {
            throw new ClassCastException("ActionMenuItem cannot be inserted into " + menu);
        }
        if ((flags & 4) != 0) {
            new ActionMenuItemCleanUp(menu, mi);
        }
    }

    public void initAccelerators(JComponent c) {
        KeyStroke[] accel = this.accelerators;
        if (accel != null) {
            this.initAccelerators(accel, c);
        }
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        sb.append('[');
        sb.append(this.actionCommand);
        sb.append(']');
        return sb.toString();
    }

    protected void initAccelerators(KeyStroke[] strokes, JComponent c) {
        Object key = this.getValue("ActionCommandKey");
        for (int i = 0; i < strokes.length; ++i) {
            KeyStroke stroke = strokes[i];
            c.getInputMap(0).put(stroke, key);
            c.getInputMap(1).put(stroke, key);
        }
        c.getActionMap().put(key, this);
    }
}

