/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing;

import chemaxon.common.util.MProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class MDialogProgressMonitor
implements MProgressMonitor {
    private Component parentComponent = null;
    private boolean progressCanceled = false;
    private int numLevels = 1;
    private Child childProgressMonitor = null;
    private JDialog dialog;
    private JOptionPane optionPane;
    private boolean visible;
    private JProgressBar[] progressBars;
    private int[] progressValues;
    private JLabel[] noteLabels;
    private String[] notes;
    private Object theMessage;
    private Object[] cancelOption = null;
    private long startTime;
    private int millisToDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int[] minimumValues;
    private int[] maximumValues;
    private int[] lastDisplayedValues;
    private int[] reportDeltas;
    private boolean modal = false;

    public MDialogProgressMonitor(Component parent, Object msg) {
        this(parent, msg, 1);
    }

    public MDialogProgressMonitor(Component parent, Object msg, int levels2) {
        this.parentComponent = parent;
        this.theMessage = msg;
        this.cancelOption = new Object[1];
        this.cancelOption[0] = "Cancel";
        this.numLevels = levels2;
        this.childProgressMonitor = levels2 > 1 ? new Child(1) : null;
    }

    public void setModal(boolean v) {
        this.modal = v;
    }

    @Override
    public MProgressMonitor newInstance() {
        MDialogProgressMonitor pmon = new MDialogProgressMonitor(this.parentComponent, this.theMessage, this.numLevels);
        pmon.setMillisToDecideToPopup(this.millisToDecideToPopup);
        pmon.setMillisToPopup(this.millisToPopup);
        return pmon;
    }

    @Override
    public MProgressMonitor getChild() {
        return this.childProgressMonitor;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    public void close() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MDialogProgressMonitor.this.dialog != null) {
                    MDialogProgressMonitor.this.dialog.setVisible(false);
                    MDialogProgressMonitor.this.dialog.dispose();
                    MDialogProgressMonitor.this.dialog = null;
                    MDialogProgressMonitor.this.optionPane = null;
                    MDialogProgressMonitor.access$1002(MDialogProgressMonitor.this, null);
                    MDialogProgressMonitor.this.visible = false;
                }
            }
        });
    }

    @Override
    public boolean isCanceled() {
        if (this.progressCanceled) {
            return true;
        }
        if (this.optionPane == null) {
            return false;
        }
        Object v = this.optionPane.getValue();
        return v != null && this.cancelOption.length == 1 && v.equals(this.cancelOption[0]);
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    @Override
    public void initProgressMonitor(String note, int min, int max) {
        this.initProgressMonitorAt(note, min, max, 0);
    }

    private void initProgressMonitorAt(String note, int min, int max, int l) {
        if (this.progressValues == null) {
            this.progressValues = new int[this.numLevels];
            this.minimumValues = new int[this.numLevels];
            this.maximumValues = new int[this.numLevels];
            this.lastDisplayedValues = new int[this.numLevels];
            this.reportDeltas = new int[this.numLevels];
            this.noteLabels = new JLabel[this.numLevels];
            this.notes = new String[this.numLevels];
        }
        this.progressValues[l] = 0;
        this.minimumValues[l] = min;
        this.maximumValues[l] = max;
        this.reportDeltas[l] = (max - min) / 100;
        if (this.reportDeltas[l] < 1) {
            this.reportDeltas[l] = 1;
        }
        this.notes[l] = note;
        if (l == 0) {
            this.startTime = System.currentTimeMillis();
            this.progressCanceled = false;
        }
    }

    @Override
    public boolean setProgressValue(int x) {
        return this.setProgressValueAt(x, 0);
    }

    private boolean setProgressValueAt(int x, int l) {
        this.progressValues[l] = x;
        if (l == 0 && x >= this.maximumValues[0]) {
            this.close();
        } else if (x >= this.lastDisplayedValues[l] + this.reportDeltas[l] || x < this.lastDisplayedValues[l]) {
            this.lastDisplayedValues[l] = x;
            if (this.visible) {
                this.setNote(l);
                JProgressBar pbar = this.progressBars[l];
                if (pbar != null) {
                    pbar.setValue(x);
                }
            } else {
                long t = System.currentTimeMillis();
                long dt = (int)(t - this.startTime);
                if (dt >= (long)this.millisToDecideToPopup) {
                    int dv = this.maximumValues[l] - this.minimumValues[l];
                    if (x > this.minimumValues[0]) {
                        if ((int)(dt * (long)dv / (long)(x - this.minimumValues[l])) >= this.millisToPopup) {
                            this.show();
                        }
                    } else {
                        this.show();
                    }
                }
            }
        }
        boolean canceled = this.isCanceled();
        if (canceled) {
            this.progressCanceled = true;
            return false;
        }
        return true;
    }

    @Override
    public int getMaximum() {
        return this.maximumValues[0];
    }

    @Override
    public void setMaximum(int v) {
        this.setMaximumValueAt(v, 0);
    }

    private void setMaximumValueAt(int v, int l) {
        if (this.maximumValues[l] != v) {
            this.maximumValues[l] = v;
            this.setNote(l);
            JProgressBar[] pbars = this.progressBars;
            if (pbars != null && pbars[l] != null) {
                pbars[l].setMaximum(v);
                if (l == 0 && this.progressValues[0] >= v) {
                    this.close();
                }
            }
        }
    }

    public void show() {
        final Object[] comps = new Object[1 + 2 * this.numLevels + 1];
        comps[0] = this.theMessage;
        this.progressBars = new JProgressBar[this.numLevels];
        this.visible = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int l = 0; l < MDialogProgressMonitor.this.numLevels; ++l) {
                    ((MDialogProgressMonitor)MDialogProgressMonitor.this).progressBars[l] = new JProgressBar();
                    MDialogProgressMonitor.this.progressBars[l].setMinimum(MDialogProgressMonitor.this.minimumValues[l]);
                    MDialogProgressMonitor.this.progressBars[l].setMaximum(MDialogProgressMonitor.this.maximumValues[l]);
                    MDialogProgressMonitor.this.progressBars[l].setValue(MDialogProgressMonitor.this.progressValues[l]);
                    ((MDialogProgressMonitor)MDialogProgressMonitor.this).noteLabels[l] = new JLabel();
                    MDialogProgressMonitor.this.setNote(l);
                    comps[1 + 2 * (((MDialogProgressMonitor)MDialogProgressMonitor.this).numLevels - 1 - l)] = MDialogProgressMonitor.this.noteLabels[l];
                    comps[2 + 2 * (((MDialogProgressMonitor)MDialogProgressMonitor.this).numLevels - 1 - l)] = MDialogProgressMonitor.this.progressBars[l];
                }
                MDialogProgressMonitor.this.optionPane = new ProgressOptionPane(comps);
                MDialogProgressMonitor.this.dialog = MDialogProgressMonitor.this.optionPane.createDialog(MDialogProgressMonitor.this.parentComponent, "Progress...");
                MDialogProgressMonitor.this.dialog.show();
            }
        });
    }

    private void setNote(int l) {
        JLabel[] labels = this.noteLabels;
        if (labels != null && labels[l] != null) {
            String fmt = this.notes[l];
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < fmt.length(); ++i) {
                char c = fmt.charAt(i);
                if (c == '%' && i < fmt.length() - 1) {
                    c = fmt.charAt(i + 1);
                    if (c == 'k') {
                        sb.append(this.progressValues[l]);
                        ++i;
                        continue;
                    }
                    if (c == 'M') {
                        sb.append(this.maximumValues[l]);
                        ++i;
                        continue;
                    }
                    sb.append('%');
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
            labels[l].setText(sb.toString());
        }
    }

    @Override
    public boolean isDialogVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    static /* synthetic */ JProgressBar[] access$1002(MDialogProgressMonitor x0, JProgressBar[] x1) {
        x0.progressBars = x1;
        return x1;
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object msglist) {
            super(msglist, 1, -1, null, MDialogProgressMonitor.this.cancelOption, null);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        @Override
        public JDialog createDialog(Component parentComponent, String title) {
            Frame frame = JOptionPane.getFrameForComponent(parentComponent);
            final JDialog dialog = new JDialog(frame, title, false);
            dialog.setModal(MDialogProgressMonitor.this.modal);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parentComponent);
            dialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                @Override
                public void windowClosing(WindowEvent we) {
                    ProgressOptionPane.this.setValue(MDialogProgressMonitor.this.cancelOption[0]);
                }

                @Override
                public void windowActivated(WindowEvent we) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    Object src = ev.getSource();
                    String name = ev.getPropertyName();
                    if (dialog.isVisible() && src == ProgressOptionPane.this && (name.equals("value") || name.equals("inputValue"))) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            return dialog;
        }
    }

    public class Child
    implements MProgressMonitor {
        private int myLevel;
        private Child child;

        private Child(int level) {
            this.myLevel = level;
            if (MDialogProgressMonitor.this.numLevels - 1 > level) {
                this.child = new Child(level + 1);
            }
        }

        @Override
        public MProgressMonitor getChild() {
            return this.child;
        }

        @Override
        public int getLevel() {
            return this.myLevel;
        }

        @Override
        public MProgressMonitor newInstance() {
            return new Child(this.myLevel);
        }

        @Override
        public void initProgressMonitor(String note, int min, int max) {
            MDialogProgressMonitor.this.initProgressMonitorAt(note, min, max, this.myLevel);
        }

        @Override
        public boolean setProgressValue(int x) {
            return MDialogProgressMonitor.this.setProgressValueAt(x, this.myLevel);
        }

        @Override
        public int getMaximum() {
            return MDialogProgressMonitor.this.maximumValues[this.myLevel];
        }

        @Override
        public void setMaximum(int v) {
            MDialogProgressMonitor.this.setMaximumValueAt(v, this.myLevel);
        }

        @Override
        public boolean isCanceled() {
            return MDialogProgressMonitor.this.isCanceled();
        }

        @Override
        public boolean isDialogVisible() {
            return MDialogProgressMonitor.this.isDialogVisible();
        }
    }
}

