/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.modules;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.image.exporter.ImageExport;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.swing.SaveImageTool;
import chemaxon.marvin.swing.modules.ExportImage;
import chemaxon.marvin.util.MarvinModule;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class Export2dImage
extends ExportImage {
    private static final long serialVersionUID = 1L;
    private static final int SAVE_OVERWRITE = 0;
    private static final int SAVE_OVERWRITE_ALL = 1;
    private static final int SAVE_CANCEL = 3;
    private Object[] images = null;
    private ImageExport exportModule;
    private boolean overwriteAll = false;
    private boolean fileChooserNeededAgain = false;

    public Export2dImage() {
    }

    private Export2dImage(Export2dImage p, String imgf) {
        super(p, imgf);
        this.images = p.images;
        this.exportModule = p.exportModule;
        if (this.images.length > 1) {
            StringBuffer sbuf = new StringBuffer("You are saving an animation into multiple image files:\n");
            sbuf.append(new File(this.getAnimFile(imgf, 0, this.images.length)).getName());
            sbuf.append("\n");
            if (this.images.length == 3) {
                sbuf.append(new File(this.getAnimFile(imgf, 1, this.images.length)).getName());
                sbuf.append("\n");
            } else if (this.images.length > 3) {
                sbuf.append("...\n");
            }
            sbuf.append(new File(this.getAnimFile(imgf, this.images.length - 1, this.images.length)).getName());
            sbuf.append("\n\nDo you want to continue?");
            SaveImageTool sit = this.getSaveImageTool();
            int res = JOptionPane.showConfirmDialog(sit.getParentContainer(), sbuf.toString(), "Save multiple image files?", 0);
            if (res != 0) {
                this.fileChooserNeededAgain = true;
                return;
            }
        }
    }

    @Override
    public Object modfunc(Object arg) {
        if (arg instanceof Hashtable) {
            Hashtable args = (Hashtable)arg;
            this.images = (Object[])args.get("images");
            this.exportModule = (ImageExport)args.get("exportModule");
            String fmt = (String)args.get("format");
            fmt = this.exportModule.modifyFormat(fmt);
            args.put("format", fmt);
            String file = (String)super.modfunc(args);
            this.saveImage(file);
        }
        return null;
    }

    @Override
    public void run() {
        if (this.images != null) {
            this.saveImage(this.images, this.imageFile);
        }
    }

    public MProgressMonitor createMProgressMonitor() {
        MDialogProgressMonitor p = null;
        if (this.images[0] instanceof Image) {
            Image img = (Image)this.images[0];
            StringBuffer sb = new StringBuffer();
            sb.append("Creating ");
            sb.append(img.getWidth(null));
            sb.append('x');
            sb.append(img.getHeight(null));
            sb.append(" ");
            sb.append(this.getFileFilter().getFormat().toUpperCase());
            SaveImageTool sit = this.getSaveImageTool();
            p = new MDialogProgressMonitor(sit.getParentContainer(), sb.toString());
        }
        return p;
    }

    private String getAnimFile(String path, int i, int n) {
        char c;
        int dot;
        if (n == 1) {
            return path;
        }
        int index = dot = path.lastIndexOf(46);
        for (int j = dot + 1; j < path.length(); ++j) {
            char c2 = path.charAt(j);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') continue;
            index = path.length();
            break;
        }
        if (index < 0) {
            index = path.length();
        }
        String number = "000000000" + i;
        int l = String.valueOf(n - 1).length();
        number = number.substring(number.length() - l);
        String s = path.substring(0, index);
        if (s.length() > 0 && (c = s.charAt(s.length() - 1)) >= '0' && c <= '9') {
            s = s + "-";
        }
        return s + number + path.substring(index);
    }

    private boolean saveImage(Object[] imgs, String fpath) {
        String format2 = this.getFileFilter().getFormat();
        String fp = fpath;
        int task = this.getTask();
        SaveImageTool sit = this.getSaveImageTool();
        try {
            if (this.exportModule == null) {
                String modName = format2.substring(0, 1).toUpperCase() + format2.substring(1).toLowerCase() + "Export";
                this.exportModule = (ImageExport)MarvinModule.load(modName, null);
            }
            ProgressMonitor pm = null;
            if (imgs.length > 1) {
                pm = new ProgressMonitor(sit.getParentContainer(), "Creating " + format2.toUpperCase() + " files for " + imgs.length + " images", null, 0, imgs.length);
            }
            for (int i = 0; i < imgs.length; ++i) {
                fp = this.getAnimFile(fpath, i, imgs.length);
                File f = new File(fp);
                if (i != 0 && task == 0 && f.exists() && !this.overwriteAll) {
                    int r = Export2dImage.showOverwriteDialog(f, imgs.length > 1, "Cancel", 3);
                    if (r == 1) {
                        this.overwriteAll = true;
                    } else if (r != 0) {
                        pm.setProgress(imgs.length);
                        return i > 0;
                    }
                }
                if (pm != null) {
                    pm.setProgress(i);
                }
                StringBuffer sbuf = null;
                byte[] ret = null;
                MProgressMonitor mpm = this.createMProgressMonitor();
                try {
                    ret = this.exportModule.doExportImage(imgs[i], mpm);
                }
                catch (IOException ex) {
                    sbuf = new StringBuffer("Cannot export image in ");
                    sbuf.append(format2);
                    sbuf.append(" format:\n");
                    sbuf.append(ex.toString());
                    JOptionPane.showMessageDialog(sit.getParentContainer(), sbuf.toString(), format2 + " export error", 0);
                }
                if (pm != null && pm.isCanceled() || mpm != null && mpm.isCanceled()) {
                    return false;
                }
                if (ret == null) continue;
                if (task == 1) {
                    this.postData(fp, ret, format2);
                    continue;
                }
                if (task != 0) continue;
                FileOutputStream os = new FileOutputStream(f);
                ((OutputStream)os).write(ret);
                ((OutputStream)os).close();
            }
            if (pm != null) {
                pm.setProgress(imgs.length);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(sit.getParentContainer(), "Cannot write file " + fp, "Write error", 0);
            return false;
        }
        return true;
    }

    private static int showOverwriteDialog(File f, boolean multipleImages, String noOptStr, int noOpt) {
        Object[] opts = new String[multipleImages ? 3 : 2];
        opts[0] = "Yes";
        if (multipleImages) {
            opts[1] = "All";
            opts[2] = noOptStr;
        } else {
            opts[1] = noOptStr;
        }
        int r = JOptionPane.showOptionDialog(null, "File " + f.getName() + " exists. Overwrite?", "File exists", 1, 3, null, opts, opts[0]);
        if (r == 0) {
            return 0;
        }
        if (!multipleImages) {
            return noOpt;
        }
        return r == 1 ? 1 : noOpt;
    }

    @Override
    protected ExportImage createExportImage(String f) {
        return new Export2dImage(this, f);
    }

    @Override
    protected boolean isExportPossible() {
        return !this.fileChooserNeededAgain;
    }
}

