/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.modules;

import chemaxon.marvin.swing.ImageFileFilter;
import chemaxon.marvin.swing.SaveImageTool;
import chemaxon.marvin.util.MarvinModule;
import java.applet.Applet;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

abstract class ExportImage
extends MarvinModule
implements Runnable {
    public static final int TASK_SAVE = 0;
    public static final int TASK_POST = 1;
    private SaveImageTool saveImageTool = null;
    private ImageFileFilter fileFilter = null;
    protected String imageFile = null;
    private int exportTask = 0;

    public ExportImage() {
    }

    protected ExportImage(ExportImage p, String f) {
        this.saveImageTool = p.saveImageTool;
        this.imageFile = f;
        this.fileFilter = p.fileFilter;
        this.exportTask = p.exportTask;
    }

    @Override
    public Object modfunc(Object arg) {
        if (arg instanceof Hashtable) {
            Hashtable args = (Hashtable)arg;
            this.saveImageTool = (SaveImageTool)args.get("saveImageTool");
            String format2 = (String)args.get("format");
            String file = (String)args.get("file");
            this.exportTask = file != null ? 0 : 1;
            this.fileFilter = new ImageFileFilter(format2);
            this.imageFile = this.exportTask == 1 ? null : file;
            return file;
        }
        return null;
    }

    protected int getTask() {
        return this.exportTask;
    }

    protected ImageFileFilter getFileFilter() {
        return this.fileFilter;
    }

    protected SaveImageTool getSaveImageTool() {
        return this.saveImageTool;
    }

    protected abstract ExportImage createExportImage(String var1);

    protected abstract boolean isExportPossible();

    protected final void saveImage(String file) {
        if (this.exportTask == 1) {
            URL uPost = this.saveImageTool.getImageSaveURL();
            URL uGet = this.saveImageTool.getImageShowURL();
            if (uPost == null || uGet == null) {
                throw new IllegalArgumentException("CGI URL not specified");
            }
            ExportImage xi = this.createExportImage(uPost.toString() + ";" + uGet.toString());
            if (xi.isExportPossible()) {
                new Thread(xi).start();
            }
        } else {
            ExportImage xi = this.createExportImage(file);
            if (xi.isExportPossible()) {
                new Thread(xi).start();
            }
        }
    }

    protected final void postData(String fp, byte[] data, String format2) throws IOException {
        URL up = new URL(fp.substring(0, fp.indexOf(";")));
        URLConnection uc = up.openConnection();
        uc.setDoOutput(true);
        uc.setDoInput(true);
        uc.setAllowUserInteraction(false);
        DataOutputStream os = new DataOutputStream(uc.getOutputStream());
        ((OutputStream)os).write(data);
        ((OutputStream)os).close();
        BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
        String tmpFileName = in.readLine();
        in.close();
        Container parent = this.saveImageTool.getParentContainer();
        while (!(parent instanceof Applet)) {
            parent = parent.getParent();
        }
        URL ug = new URL(fp.substring(fp.indexOf(";") + 1, fp.length()) + (fp.indexOf("?") == -1 ? "?" : "&") + "filename=" + tmpFileName + "&type=" + format2);
        ((Applet)parent).getAppletContext().showDocument(ug, "_blank");
        if (this.saveImageTool.getImageShowURL().toString().indexOf("?") != -1) {
            this.saveImageTool.setImageShowURL(new URL(ug.toString().substring(0, ug.toString().indexOf("?"))));
        }
    }
}

