/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.modules;

import chemaxon.marvin.io.image.exporter.PngExport;
import chemaxon.marvin.swing.modules.ImageExportOptsDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PngExportOptsDialog
extends ImageExportOptsDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox bitrateCombo;
    private static final String[] bitrates = new String[]{"1", "2", "4", "8", "24", "32"};
    private String bitrate = "32";

    @Override
    protected Object createExportModule() {
        PngExport p = new PngExport();
        p.bitsPerPixel = Integer.valueOf(this.bitrate);
        p.saveSource = this.saveSource;
        return p;
    }

    @Override
    protected void addPanels(GridBagLayout gbl, GridBagConstraints gbc, JDialog dial) {
        ++gbc.gridy;
        gbc.anchor = 18;
        gbl.setConstraints(this.addSaveSourcePanel(dial), gbc);
        ++gbc.gridy;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbl.setConstraints(this.addBitratePanel(dial), gbc);
        ++gbc.gridx;
        gbl.setConstraints(this.addAlphaPanel(dial), gbc);
    }

    @Override
    protected boolean isAlphaSupported() {
        return true;
    }

    private JPanel addBitratePanel(JDialog dial) {
        JPanel panel = new JPanel();
        dial.getContentPane().add(panel);
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Color Depth"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        GridBagLayout gbl1 = new GridBagLayout();
        panel.setLayout(gbl1);
        JLabel label = new JLabel("Bitrate:");
        panel.add(label);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.insets.right = 10;
        gbl1.setConstraints(label, gbc1);
        this.bitrateCombo = new JComboBox<String>(bitrates);
        panel.add(this.bitrateCombo);
        this.bitrateCombo.setSelectedItem(this.bitrate);
        this.bitrateCombo.addItemListener(this);
        return panel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        Object t = e.getSource();
        if (t == this.bitrateCombo) {
            this.bitrate = this.bitrateCombo.getSelectedItem().toString();
        }
    }

    @Override
    protected void setAlpha() {
        super.setAlpha();
        if (this.encodeAlpha) {
            this.bitrateCombo.setSelectedItem("32");
            this.bitrateCombo.setEnabled(false);
            this.bitrate = "32";
        } else {
            this.bitrateCombo.setEnabled(true);
        }
    }
}

