/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.moleculeview;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.swing.moleculeview.MarkableMoleculeViewComponent;
import chemaxon.marvin.util.ColorGenerator;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MarkController {
    private boolean highlightEnabled = false;
    private int atomMarkMode = 0;
    public static final Color DEFAULT_ATOM_HIGHLIGHT_COLOR = new Color(200, 200, 255);
    public static final Color DEFAULT_ATOM_MARK_COLOR = new Color(150, 150, 255);
    public static final int NO_ATOM_MARK = 0;
    public static final int ATOM_MARK_CIRCLE = 1;
    public static final int ATOM_MARK_ATOM_MAP_NUMBER = 2;
    public static final String PROPERTY_NAME_ATOM_HOVERED = "atomHovered";
    public static final String PROPERTY_NAME_ATOM_CLICKED = "atomClicked";
    public static final int NO_SIGN = -1;
    private Map<Color, Set<Integer>> highlights;
    private Map<Color, Set<Integer>> colorMarks;
    private int lastClickedAtom = -1;
    private int lastHoveredAtom = -1;
    private boolean unmarkAndUnhighlightEqualSetsOnly = false;
    private MarkableMoleculeViewComponent view;

    public MarkController(boolean isHighlightEnabled, int markMode, boolean isUnmarkAndUnhighlightEqualSetsOnly) {
        this.setHighlightEnabled(isHighlightEnabled);
        this.setAtomMarkMode(markMode);
        this.setUnmarkAndUnhighlightEqualSetsOnly(isUnmarkAndUnhighlightEqualSetsOnly);
    }

    private void addListeners() {
        if (this.getView() == null) {
            return;
        }
        this.getView().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index;
                super.mouseMoved(e);
                if (MarkController.this.getView().getMolecule() != null && MarkController.this.isHighlightEnabled() && (index = MarkController.this.findTopAtomIndex(e.getPoint())) != MarkController.this.getLastHoveredAtom()) {
                    MarkController.this.getView().changeProperty(MarkController.PROPERTY_NAME_ATOM_HOVERED, MarkController.this.lastHoveredAtom, index);
                    MarkController.this.setLastHoveredAtom(index);
                }
            }
        });
        this.getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (MarkController.this.getView().getMolecule() != null && MarkController.this.getAtomMarkMode() != 0) {
                    int index = MarkController.this.findTopAtomIndex(e.getPoint());
                    MarkController.this.getView().changeProperty(MarkController.PROPERTY_NAME_ATOM_CLICKED, MarkController.this.lastClickedAtom == index ? null : Integer.valueOf(MarkController.this.lastClickedAtom), index);
                    MarkController.this.setLastClickedAtom(index);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                if (MarkController.this.getView().getMolecule() != null && MarkController.this.isHighlightEnabled() && MarkController.this.lastHoveredAtom != -1) {
                    MarkController.this.getView().changeProperty(MarkController.PROPERTY_NAME_ATOM_HOVERED, MarkController.this.lastHoveredAtom, -1);
                    MarkController.this.setLastHoveredAtom(-1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                if (MarkController.this.getView().getMolecule() != null && MarkController.this.isHighlightEnabled() && MarkController.this.lastHoveredAtom != -1) {
                    MarkController.this.getView().changeProperty(MarkController.PROPERTY_NAME_ATOM_HOVERED, MarkController.this.lastHoveredAtom, -1);
                    MarkController.this.setLastHoveredAtom(-1);
                }
            }
        });
    }

    public boolean isHighlightEnabled() {
        return this.highlightEnabled;
    }

    public void setHighlightEnabled(boolean highlightEnabled) {
        this.highlightEnabled = highlightEnabled;
    }

    public int getAtomMarkMode() {
        return this.atomMarkMode;
    }

    public void setAtomMarkMode(int mode) {
        if (mode == 0 || mode == 1 || mode == 2) {
            this.atomMarkMode = mode;
            if (mode == 2) {
                this.getView().getPainter().getCommon().setAtomMappingVisible(true);
                this.getView().repaint();
            }
        }
    }

    public void highlightAtoms(Set<Integer> atomIndexes, Color color) {
        if (!this.hasViewAndMolecule() || !this.isHighlightEnabled() || atomIndexes == null || atomIndexes.isEmpty() || color == null) {
            return;
        }
        MarkController.addSigns(atomIndexes, color, this.getHighlights());
        this.repaintSigns();
    }

    public void markAtoms(Set<Integer> atomIndexes, Color color) {
        if (!this.hasViewAndMolecule() || this.getAtomMarkMode() != 1 || atomIndexes == null || atomIndexes.isEmpty() || color == null) {
            return;
        }
        MarkController.addSigns(atomIndexes, color, this.getColorMarks());
        this.repaintSigns();
    }

    public void markAtoms(Set<Integer> atomIndexes, int markNumber) {
        if (!this.hasViewAndMolecule() || this.getAtomMarkMode() != 2 || atomIndexes == null || atomIndexes.isEmpty()) {
            return;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        for (int index : atomIndexes) {
            this.getView().getMolecule().getAtom(index).setAtomMap(markNumber);
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
        this.getView().repaint();
    }

    private static final void addSigns(Set<Integer> atomIndexes, Color color, Map<Color, Set<Integer>> signMap) {
        if (signMap.containsKey(color)) {
            signMap.get(color).addAll(atomIndexes);
        } else {
            signMap.put(color, atomIndexes);
        }
    }

    public void removeHighLight(Set<Integer> atomIndexes) {
        if (!this.hasViewAndMolecule() || atomIndexes == null || atomIndexes.isEmpty()) {
            return;
        }
        if (this.isUnmarkAndUnhighlightEqualSetsOnly()) {
            MarkController.removeSigns(atomIndexes, this.getHighlights());
        } else {
            MarkController.removeAnySigns(atomIndexes, this.getHighlights());
        }
        this.repaintSigns();
    }

    public void removeHighLight(Color color) {
        if (!this.hasViewAndMolecule() || color == null) {
            return;
        }
        MarkController.removeSigns(color, this.getHighlights());
        this.repaintSigns();
    }

    public void removeColorMark(Set<Integer> atomIndexes) {
        if (!this.hasViewAndMolecule() || atomIndexes == null || atomIndexes.isEmpty()) {
            return;
        }
        if (this.isUnmarkAndUnhighlightEqualSetsOnly()) {
            MarkController.removeSigns(atomIndexes, this.getColorMarks());
        } else {
            MarkController.removeAnySigns(atomIndexes, this.getColorMarks());
        }
        this.repaintSigns();
    }

    public void removeColorMark(Color color) {
        if (!this.hasViewAndMolecule() || color == null) {
            return;
        }
        MarkController.removeSigns(color, this.getColorMarks());
        this.repaintSigns();
    }

    public void removeNumberMark(int markNumber) {
        if (!this.hasViewAndMolecule()) {
            return;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        for (MolAtom atom : this.getView().getMolecule().getAtomArray()) {
            if (atom.getAtomMap() != markNumber) continue;
            atom.setAtomMap(0);
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
        this.getView().repaint();
    }

    public void removeNumberMark(Set<Integer> atomIndexes) {
        if (!this.hasViewAndMolecule() || atomIndexes == null || atomIndexes.isEmpty()) {
            return;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        for (int index : atomIndexes) {
            this.getView().getMolecule().getAtom(index).setAtomMap(0);
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
        this.getView().repaint();
    }

    private static final void removeSigns(Set<Integer> atomIndexes, Map<Color, Set<Integer>> signMap) {
        for (Map.Entry<Color, Set<Integer>> sign : signMap.entrySet()) {
            if (!((Object)atomIndexes).equals(sign.getValue())) continue;
            signMap.remove(sign.getKey());
        }
    }

    private static final void removeSigns(Color color, Map<Color, Set<Integer>> signMap) {
        if (signMap.containsKey(color)) {
            signMap.remove(color);
        }
    }

    private static final void removeAnySigns(Set<Integer> atomIndexes, Map<Color, Set<Integer>> signMap) {
        Set<Map.Entry<Color, Set<Integer>>> entries = signMap.entrySet();
        block0: for (Map.Entry<Color, Set<Integer>> sign : entries) {
            for (int index : atomIndexes) {
                if (!sign.getValue().contains(index)) continue;
                entries.remove(sign);
                continue block0;
            }
        }
    }

    private void repaintSigns() {
        if (!this.hasViewAndMolecule()) {
            return;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        this.getView().getDocument().clearCheckerMarks();
        if (this.isHighlightEnabled()) {
            this.createSigns(this.highlights);
        }
        if (this.getAtomMarkMode() == 1) {
            this.createSigns(this.colorMarks);
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
        this.getView().repaint();
    }

    private void createSigns(Map<Color, Set<Integer>> signs) {
        for (Map.Entry<Color, Set<Integer>> sign : signs.entrySet()) {
            this.getView().getDocument().addCheckerMark(new MDocument.CheckerMark(this.getAtomsFromIndexes(sign.getValue()), null, sign.getKey()));
        }
    }

    private MolAtom[] getAtomsFromIndexes(Set<Integer> indexes) {
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        for (int index : indexes) {
            atoms.add(this.getView().getMolecule().getAtom(index));
        }
        return atoms.toArray(new MolAtom[atoms.size()]);
    }

    private Map<Color, Set<Integer>> getHighlights() {
        if (this.highlights == null) {
            this.highlights = new HashMap<Color, Set<Integer>>();
        }
        return this.highlights;
    }

    private Map<Color, Set<Integer>> getColorMarks() {
        if (this.colorMarks == null) {
            this.colorMarks = new HashMap<Color, Set<Integer>>();
        }
        return this.colorMarks;
    }

    public void removeHighLights() {
        this.getHighlights().clear();
        this.repaintSigns();
    }

    public void removeColorMarks() {
        this.getColorMarks().clear();
        this.repaintSigns();
    }

    public void removeNumberMarks() {
        if (!this.hasViewAndMolecule()) {
            return;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        for (MolAtom atom : this.getView().getMolecule().getAtomArray()) {
            atom.setAtomMap(0);
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
    }

    public void clearAll() {
        this.removeHighLights();
        this.removeColorMarks();
        this.removeNumberMarks();
        this.setLastClickedAtom(-1);
        this.setLastHoveredAtom(-1);
        this.getView().repaint();
    }

    private void setLastClickedAtom(int lastClickedAtom) {
        this.lastClickedAtom = lastClickedAtom;
    }

    private int getLastHoveredAtom() {
        return this.lastHoveredAtom;
    }

    private void setLastHoveredAtom(int lastHoveredAtom) {
        this.lastHoveredAtom = lastHoveredAtom;
    }

    private int findTopAtomIndex(Point point) {
        if (!this.hasViewAndMolecule()) {
            return -1;
        }
        MolPainter painter = this.getView().getPainter();
        int diameter = (int)Math.round(2.0 * painter.getAtomSize() * painter.getRTransform().getScale() * painter.getScale() / 1.54);
        Rectangle hitBox = new Rectangle(point.x - diameter / 2, point.y - diameter / 2, diameter, diameter);
        int focused = -1;
        boolean found = false;
        double topZ = Double.MIN_VALUE;
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
        for (int i = 0; i < this.view.getMolecule().getAtomArray().length; ++i) {
            MolAtom atom = this.view.getMolecule().getAtom(i);
            DPoint3 viewPoint = new DPoint3(atom.getX(), atom.getY(), atom.getZ());
            if (!hitBox.contains(painter.calcGP(viewPoint.x, viewPoint.y, viewPoint.z))) continue;
            painter.getTransformMatrix().transform(viewPoint);
            if (!found) {
                topZ = viewPoint.z;
                found = true;
                focused = i;
                continue;
            }
            if (!(viewPoint.z > topZ)) continue;
            focused = i;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        return focused;
    }

    public boolean isUnmarkAndUnhighlightEqualSetsOnly() {
        return this.unmarkAndUnhighlightEqualSetsOnly;
    }

    public void setUnmarkAndUnhighlightEqualSetsOnly(boolean markEqualSetsOnly) {
        this.unmarkAndUnhighlightEqualSetsOnly = markEqualSetsOnly;
    }

    public MarkableMoleculeViewComponent getView() {
        return this.view;
    }

    public void setView(MarkableMoleculeViewComponent view) {
        if (view != null) {
            this.view = view;
            if (view.getMarkController() != this) {
                view.setMarkController(this);
            }
            this.addListeners();
            this.clearAll();
        }
    }

    private boolean hasViewAndMolecule() {
        return this.getView() != null && this.getView().getMolecule() != null;
    }

    public Map<Color, Set<Integer>> convertNumberMarksToColorMarks(Collection<Color> forbiddenColors) {
        List<NumberMark> numberMarks;
        if (!this.hasViewAndMolecule() || this.getAtomMarkMode() == 2) {
            return null;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        if ((numberMarks = this.createNumberMarkList()).isEmpty()) {
            return null;
        }
        List<Color> newColors = ColorGenerator.generateColors(numberMarks.size(), forbiddenColors == null ? ColorGenerator.gatherBaseColorsAndBaseMoleculeColors(true) : forbiddenColors);
        for (int k = 0; k < newColors.size(); ++k) {
            this.getColorMarks().put(newColors.get(k), numberMarks.get(k).getIndexes());
        }
        this.setAtomMarkMode(1);
        this.repaintSigns();
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
        HashMap<Color, Set<Integer>> result = new HashMap<Color, Set<Integer>>();
        result.putAll(this.getColorMarks());
        return result;
    }

    private List<NumberMark> createNumberMarkList() {
        if (!this.hasViewAndMolecule() || this.getAtomMarkMode() == 2) {
            return null;
        }
        ArrayList<NumberMark> numberMarks = new ArrayList<NumberMark>();
        MolAtom[] atoms = this.getView().getMolecule().getAtomArray();
        for (int i = 0; i < atoms.length; ++i) {
            if (atoms[i].getAtomMap() == 0) continue;
            boolean foundIndex = false;
            for (NumberMark mark : numberMarks) {
                if (mark.getMarkIndex().intValue() != atoms[i].getAtomMap()) continue;
                mark.add(i);
                foundIndex = true;
            }
            if (!foundIndex) {
                numberMarks.add(new NumberMark(atoms[i].getAtomMap(), i));
            }
            atoms[i].setAtomMap(0);
        }
        if (numberMarks.isEmpty()) {
            Collections.sort(numberMarks, new NumberMarkComparator());
        }
        return numberMarks;
    }

    public Map<Integer, Set<Integer>> convertColorMarksToNumberMarks() {
        if (!this.hasViewAndMolecule() || this.getAtomMarkMode() != 1 || this.getColorMarks().isEmpty()) {
            return null;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(false);
        }
        HashMap<Integer, Set<Integer>> numberMarks = new HashMap<Integer, Set<Integer>>();
        int markIndex = 1;
        for (Set<Integer> atomIndexes : this.getColorMarks().values()) {
            for (int index : atomIndexes) {
                this.getView().getMolecule().getAtom(index).setAtomMap(markIndex);
            }
            numberMarks.put(markIndex, atomIndexes);
            ++markIndex;
        }
        if (this.getView().isContractVisibleMolecule()) {
            this.getView().getMolecule().setGUIContracted(true);
        }
        this.setAtomMarkMode(2);
        this.getColorMarks().clear();
        this.repaintSigns();
        return numberMarks;
    }

    private class NumberMarkComparator
    implements Comparator<NumberMark> {
        private NumberMarkComparator() {
        }

        @Override
        public int compare(NumberMark left, NumberMark right) {
            return left.getMarkIndex().compareTo(right.getMarkIndex());
        }
    }

    private class NumberMark {
        private int markIndex;
        private Set<Integer> indexes;

        private NumberMark(int index, int firstValue) {
            this.markIndex = index;
            this.indexes = new HashSet<Integer>();
            this.indexes.add(firstValue);
        }

        private void add(int index) {
            this.getIndexes().add(index);
        }

        private Set<Integer> getIndexes() {
            return this.indexes;
        }

        private Integer getMarkIndex() {
            return this.markIndex;
        }
    }
}

