/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.swing.moleculeview;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.swing.moleculeview.MolTransformUtil;
import chemaxon.marvin.swing.moleculeview.RGMoleculeGraphUtils;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RgMoleculeGraphIface;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MoleculeViewComponent
extends JComponent {
    private static final long serialVersionUID = -1911964249431296350L;
    private Molecule molecule = null;
    private MolPainter painter;
    private MDocument document;
    private Point mousePos;
    private DPoint3 molcenter;
    private DPoint3 componentCenterInMolCoords;
    private boolean initialized = false;
    private Dimension storedSize;
    private boolean contractVisibleMolecule = true;
    private boolean autofit = true;
    private boolean ctrlMouseWheelZoomEnabled = false;
    private boolean mouseDragRotateEnabled = false;
    private boolean ctrlMouseDragTranslateEnabled = false;
    private boolean shiftMouseDragRotate3DEnabled = false;
    private boolean resizeOnDoubleClick = false;
    private MouseAdapter resizeAdapter;
    private MouseMotionAdapter translateAdapter;
    private MouseMotionAdapter rotate3DAdapter;
    private MouseMotionAdapter rotateAdapter;
    private MouseWheelListener zoomListener;
    public static final String PROPERTY_KEY_LOADING = "loading";
    private double relativeScaleFactor = 0.6;

    public MoleculeViewComponent() {
        this.setPainter(new MolPainter(new MolPainterCommon()));
        this.getPainter().setCentralized(false);
        this.init();
    }

    public MoleculeViewComponent(MolPainterCommon common) {
        this.setPainter(new MolPainter(common == null ? new MolPainterCommon() : common));
        this.getPainter().setCentralized(false);
        this.init();
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    public void setDisplayOptions(Integer dispOpts, Integer dispOptsExt) {
        if (dispOpts != null) {
            this.getPainter().getCommon().setDispopts(dispOpts);
        }
        if (dispOptsExt != null) {
            this.getPainter().getCommon().setDispoptsExt(dispOptsExt);
        }
        this.repaint();
    }

    MolPainter getPainter() {
        return this.painter;
    }

    private void setPainter(MolPainter painter) {
        this.painter = painter;
    }

    public void setRelativeScaleFactor(double value) {
        if (value < 1.0 && value > 0.0) {
            this.relativeScaleFactor = value;
            this.centerize();
        }
    }

    public void setMolecule(Molecule molecule) {
        if (this.isContractVisibleMolecule()) {
            molecule.setGUIContracted(true);
        }
        this.molecule = molecule;
        this.getPainter().resetMolPainter();
        this.getPainter().setBoundsFor(this.getDocument());
        this.setMoleculeCenter(this.getMolecule().calcCenter());
        MolTransformUtil.zoomToFragment(new MoleculeGraph[]{this.getDocument().getMainMoleculeGraph()}, this.getMoleculeCenter(), this.getSize(), this.getPainter());
        this.updateCenter();
        this.storedSize = this.getSize();
        this.repaint();
    }

    protected MDocument getDocument() {
        this.document = this.getMolecule().getDocument();
        if (this.document == null) {
            this.document = new MDocument(this.getMolecule());
        }
        return this.document;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(this.getBackground());
        Rectangle rect = g2.getClipBounds();
        g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        if (this.getMolecule() != null) {
            this.getPainter().paintDocument(g2, this.getDocument(), null);
        }
        g2.dispose();
    }

    private void init() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MoleculeViewComponent.this.getMolecule() == null || MoleculeViewComponent.this.getMoleculeCenter() == null) {
                    return;
                }
                Dimension size = MoleculeViewComponent.this.getHeight() * MoleculeViewComponent.this.getWidth() > 0 ? MoleculeViewComponent.this.getSize() : new Dimension(1, 1);
                MoleculeViewComponent.this.getPainter().setScreen(size);
                if (!MoleculeViewComponent.this.initialized) {
                    MoleculeViewComponent.this.getPainter().setScale(MoleculeViewComponent.this.relativeScaleFactor * MoleculeViewComponent.this.getPainter().maxScale(size));
                    MoleculeViewComponent.this.initialized = true;
                    Point centerInPixels = MoleculeViewComponent.this.getPainter().calcGP(((MoleculeViewComponent)MoleculeViewComponent.this).getMoleculeCenter().x, ((MoleculeViewComponent)MoleculeViewComponent.this).getMoleculeCenter().y, ((MoleculeViewComponent)MoleculeViewComponent.this).getMoleculeCenter().z);
                    Point panelCenter = new Point(MoleculeViewComponent.this.getWidth() / 2, MoleculeViewComponent.this.getHeight() / 2);
                    MolTransformUtil.translate(centerInPixels.x - panelCenter.x, centerInPixels.y - panelCenter.y, MoleculeViewComponent.this.getPainter());
                } else if (MoleculeViewComponent.this.autofit || MoleculeViewComponent.this.storedSize.equals(new Dimension(1, 1))) {
                    MoleculeViewComponent.this.centerize();
                } else {
                    Point centerInPixels = MoleculeViewComponent.this.getPainter().calcGP(((MoleculeViewComponent)MoleculeViewComponent.this).componentCenterInMolCoords.x, ((MoleculeViewComponent)MoleculeViewComponent.this).componentCenterInMolCoords.y, ((MoleculeViewComponent)MoleculeViewComponent.this).componentCenterInMolCoords.z);
                    Point panelCenter = new Point(MoleculeViewComponent.this.getWidth() / 2, MoleculeViewComponent.this.getHeight() / 2);
                    MolTransformUtil.scale(Math.max(1.0, (double)Math.min(MoleculeViewComponent.this.getWidth(), MoleculeViewComponent.this.getHeight())) / Math.max(1.0, Math.min(MoleculeViewComponent.this.storedSize.getWidth(), MoleculeViewComponent.this.storedSize.getHeight())), panelCenter, MoleculeViewComponent.this.getPainter());
                    MolTransformUtil.translate(centerInPixels.x - panelCenter.x, centerInPixels.y - panelCenter.y, MoleculeViewComponent.this.getPainter());
                }
                MoleculeViewComponent.this.repaint();
                MoleculeViewComponent.this.updateCenter();
                MoleculeViewComponent.this.storedSize = size;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MoleculeViewComponent.this.mousePos = e.getPoint();
            }
        });
        this.setBackground(this.getPainter().getBackground());
    }

    public Point getMousePos() {
        return this.mousePos;
    }

    public void setMousePos(Point mousePos) {
        this.mousePos = mousePos;
    }

    private void updateCenter() {
        this.componentCenterInMolCoords = this.getPainter().calcMolP(this.getWidth() / 2, this.getHeight() / 2);
    }

    public void centerize() {
        this.centerize(this.getSize());
        this.repaint();
    }

    private void centerize(Dimension size) {
        if (this.getMolecule() == null) {
            return;
        }
        MolTransformUtil.zoomToFragment(new MoleculeGraph[]{this.getDocument().getMainMoleculeGraph()}, this.getMoleculeCenter(), size, this.getPainter(), this.relativeScaleFactor);
    }

    public void rotate(double xAngle, double yAngle, double zAngle) {
        if (this.getMolecule() == null) {
            return;
        }
        MolTransformUtil.rotate(this.getMoleculeCenter(), xAngle, yAngle, zAngle, this.getPainter());
        this.repaint();
        this.updateCenter();
    }

    public void translate(int dX, int dY) {
        if (this.getMolecule() == null) {
            return;
        }
        MolTransformUtil.translate(dX, dY, this.getPainter());
        this.repaint();
        this.updateCenter();
    }

    public void scale(double scale, Point fixPoint) {
        if (this.getMolecule() == null) {
            return;
        }
        MolTransformUtil.scale(scale, fixPoint, this.getPainter());
        this.repaint();
        this.updateCenter();
    }

    public void zoomToScaffold() {
        if (!this.isRGMolecule()) {
            return;
        }
        this.zoomTo(new MoleculeGraph[]{((RgMoleculeGraphIface)((Object)this.getDocument().getMainMoleculeGraph())).getRootG()}, -1);
    }

    public void zoomToRGroup(int rGroupNumber) {
        if (!this.isRGMolecule()) {
            return;
        }
        MoleculeGraph[] moleculeGraphs = RGMoleculeGraphUtils.getRGroupGraphArray(rGroupNumber, (RgMolecule)this.getMolecule());
        if (moleculeGraphs != null) {
            this.zoomTo(moleculeGraphs, rGroupNumber);
        }
    }

    public void zoomToRGroups(Set<Integer> rGroupNumbers) {
        if (!this.isRGMolecule()) {
            return;
        }
        ArrayList<MoleculeGraph> fusedGraph = new ArrayList<MoleculeGraph>();
        for (int rGroupNumber : rGroupNumbers) {
            if (rGroupNumber == -1) {
                fusedGraph.add(((RgMoleculeGraphIface)((Object)this.getDocument().getMainMoleculeGraph())).getRootG());
            } else {
                MoleculeGraph[] moleculeGraphs = RGMoleculeGraphUtils.getRGroupGraphArray(rGroupNumber, (RgMolecule)this.getMolecule());
                if (moleculeGraphs != null) {
                    for (MoleculeGraph graph : moleculeGraphs) {
                        fusedGraph.add(graph);
                    }
                }
            }
            if (fusedGraph.isEmpty()) continue;
            this.zoomTo(fusedGraph.toArray(new MoleculeGraph[fusedGraph.size()]), 0);
        }
    }

    public void zoomTo(MoleculeGraph[] fragment) {
        this.zoomTo(fragment, -1);
    }

    private void zoomTo(MoleculeGraph[] fragment, int rGroupNumber) {
        if (this.getMolecule() == null) {
            return;
        }
        MolTransformUtil.zoomToFragment(fragment, this.getSize(), this.getPainter(), rGroupNumber);
        this.repaint();
        this.updateCenter();
    }

    private boolean isRGMolecule() {
        return this.getDocument().getMainMoleculeGraph() instanceof RgMoleculeGraphIface;
    }

    public Point getMoleculePointInPixels(DPoint3 point) {
        return this.getPainter().calcGP(point.x, point.y, point.z);
    }

    private DPoint3 getMoleculeCenter() {
        return this.molcenter;
    }

    private void setMoleculeCenter(DPoint3 center) {
        this.molcenter = center;
    }

    public void setFitOnResize(boolean fit) {
        this.autofit = fit;
    }

    public boolean getFitonResize() {
        return this.autofit;
    }

    public boolean isZoomEnabled() {
        return this.ctrlMouseWheelZoomEnabled;
    }

    public void setZoomEnabled(boolean mouseWheelZoomEnabled) {
        if (mouseWheelZoomEnabled != this.isZoomEnabled()) {
            if (mouseWheelZoomEnabled) {
                this.addMouseWheelListener(this.getZoomListener());
            } else {
                this.removeMouseWheelListener(this.getZoomListener());
            }
        }
        this.ctrlMouseWheelZoomEnabled = mouseWheelZoomEnabled;
    }

    public boolean isRotateEnabled() {
        return this.mouseDragRotateEnabled;
    }

    public void setRotateEnabled(boolean mouseDragRotateEnabled) {
        if (mouseDragRotateEnabled != this.isRotateEnabled()) {
            if (mouseDragRotateEnabled) {
                this.addMouseMotionListener(this.getRotateAdapter());
            } else {
                this.removeMouseMotionListener(this.getRotateAdapter());
            }
        }
        this.mouseDragRotateEnabled = mouseDragRotateEnabled;
    }

    public boolean isTranslateEnabled() {
        return this.ctrlMouseDragTranslateEnabled;
    }

    public void setTranslateEnabled(boolean ctrlMouseDragTranslateEnabled) {
        if (ctrlMouseDragTranslateEnabled != this.isTranslateEnabled()) {
            if (ctrlMouseDragTranslateEnabled) {
                this.addMouseMotionListener(this.getTranslateAdapter());
            } else {
                this.removeMouseMotionListener(this.getTranslateAdapter());
            }
        }
        this.ctrlMouseDragTranslateEnabled = ctrlMouseDragTranslateEnabled;
    }

    public boolean isRotate3DEnabled() {
        return this.shiftMouseDragRotate3DEnabled;
    }

    public void setRotate3DEnabled(boolean shiftMouseDragRotate3DEnabled) {
        if (shiftMouseDragRotate3DEnabled != this.isRotate3DEnabled()) {
            if (shiftMouseDragRotate3DEnabled) {
                this.addMouseMotionListener(this.getRotate3DAdapter());
            } else {
                this.removeMouseMotionListener(this.getRotate3DAdapter());
            }
        }
        this.shiftMouseDragRotate3DEnabled = shiftMouseDragRotate3DEnabled;
    }

    public boolean isResizeOnDoubleClick() {
        return this.resizeOnDoubleClick;
    }

    public void setResizeOnDoubleClick(boolean resizeOnDoubleClick) {
        if (resizeOnDoubleClick != this.isResizeOnDoubleClick()) {
            if (resizeOnDoubleClick) {
                this.addMouseListener(this.getResizeAdapter());
            } else {
                this.removeMouseListener(this.getResizeAdapter());
            }
        }
        this.resizeOnDoubleClick = resizeOnDoubleClick;
    }

    private MouseAdapter getResizeAdapter() {
        if (this.resizeAdapter == null) {
            this.resizeAdapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        MoleculeViewComponent.this.centerize();
                    }
                }
            };
        }
        return this.resizeAdapter;
    }

    private MouseMotionAdapter getTranslateAdapter() {
        if (this.translateAdapter == null) {
            this.translateAdapter = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (MoleculeViewComponent.this.getMolecule() == null) {
                        return;
                    }
                    if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                        MoleculeViewComponent.this.translate(MoleculeViewComponent.this.getMousePos().x - e.getX(), MoleculeViewComponent.this.getMousePos().y - e.getY());
                        MoleculeViewComponent.this.setMousePos(e.getPoint());
                    }
                }
            };
        }
        return this.translateAdapter;
    }

    private MouseMotionAdapter getRotate3DAdapter() {
        if (this.rotate3DAdapter == null) {
            this.rotate3DAdapter = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (MoleculeViewComponent.this.getMolecule() == null) {
                        return;
                    }
                    if (e.isShiftDown()) {
                        MoleculeViewComponent.this.rotate(Math.toRadians(MoleculeViewComponent.this.getMousePos().y - e.getY()), Math.toRadians(MoleculeViewComponent.this.getMousePos().x - e.getX()), 0.0);
                        MoleculeViewComponent.this.setMousePos(e.getPoint());
                    }
                }
            };
        }
        return this.rotate3DAdapter;
    }

    private MouseMotionAdapter getRotateAdapter() {
        if (this.rotateAdapter == null) {
            this.rotateAdapter = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (MoleculeViewComponent.this.getMolecule() == null) {
                        return;
                    }
                    if (!e.isShiftDown() && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                        MoleculeViewComponent.this.rotate(0.0, 0.0, MolTransformUtil.calcAngle(MoleculeViewComponent.this.getMousePos(), MoleculeViewComponent.this.getMoleculePointInPixels(MoleculeViewComponent.this.getMoleculeCenter()), e.getPoint()));
                        MoleculeViewComponent.this.setMousePos(e.getPoint());
                    }
                }
            };
        }
        return this.rotateAdapter;
    }

    private MouseWheelListener getZoomListener() {
        if (this.zoomListener == null) {
            this.zoomListener = new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (MoleculeViewComponent.this.getMolecule() == null) {
                        return;
                    }
                    if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                        MoleculeViewComponent.this.scale(Math.pow(0.9, e.getWheelRotation()), e.getPoint());
                    } else {
                        MoleculeViewComponent.this.getParent().dispatchEvent(SwingUtilities.convertMouseEvent(MoleculeViewComponent.this, e, MoleculeViewComponent.this.getParent()));
                    }
                }
            };
        }
        return this.zoomListener;
    }

    public boolean isContractVisibleMolecule() {
        return this.contractVisibleMolecule;
    }

    public void setContractVisibleMolecule(boolean contractVisibleMolecule) {
        if (this.getMolecule() != null && contractVisibleMolecule != this.getMolecule().isGUIContracted()) {
            this.getMolecule().setGUIContracted(contractVisibleMolecule);
        }
        this.contractVisibleMolecule = contractVisibleMolecule;
    }
}

