/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.manager;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.action.PropertiesConfigurer;
import chemaxon.marvin.uif.action.RegistryEvent;
import chemaxon.marvin.uif.action.RegistryListener;
import chemaxon.marvin.uif.action.support.ActionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.event.EventListenerList;

public class ActionMapAdapter
implements ActionRegistry {
    private final String[] EMPTY_ARRAY = new String[0];
    private ActionMap map;
    private Map<String, ActionAdapter> adapters;
    private final Category defaultCategory;
    private EventListenerList listenerList;

    public ActionMapAdapter(Category defaultCategory) {
        this(null, defaultCategory);
    }

    public ActionMapAdapter(ActionMap map, Category defaultCategory) {
        this.map = map;
        this.defaultCategory = defaultCategory;
        this.adapters = new HashMap<String, ActionAdapter>();
        this.listenerList = new EventListenerList();
    }

    @Override
    public void addConfigurer(PropertiesConfigurer configurer) {
    }

    @Override
    public Action getAction(String id) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(id);
    }

    @Override
    public String getID(Action action) {
        String[] ids;
        for (String id : ids = this.getActionIDs()) {
            if (this.getAction(id) != action) continue;
            return id;
        }
        return null;
    }

    @Override
    public boolean hasAction(String id) {
        return this.getAction(id) != null;
    }

    @Override
    public void register(String id, Action action) {
        if (this.map == null) {
            throw new IllegalStateException();
        }
        this.map.put(id, action);
        this.fireRegistryEvent(id, true);
    }

    @Override
    public void register(String id, String categoryID, Action action) {
        this.register(id, action);
    }

    @Override
    public void remove(String id) {
        if (this.map == null || !this.hasAction(id)) {
            return;
        }
        this.map.remove(id);
        this.removeAdapter(id);
        this.fireRegistryEvent(id, false);
    }

    private void removeAdapters() {
        for (String id : this.getActionIDs()) {
            this.removeAdapter(id);
        }
    }

    private void removeAdapter(String id) {
        ActionAdapter adapter = this.adapters.remove(id);
        if (adapter != null) {
            adapter.dispose();
        }
    }

    @Override
    public Category getCategory(String categoryID) {
        return categoryID.equals(this.defaultCategory.getID()) ? this.defaultCategory : null;
    }

    @Override
    public void registerCategory(Category category) {
    }

    @Override
    public String getActionCategoryID(String id) {
        return this.defaultCategory != null ? this.defaultCategory.getID() : null;
    }

    @Override
    public ActionProperties getActionFace(String id, String context) {
        if (!this.hasAction(id)) {
            return null;
        }
        ActionAdapter result = this.adapters.get(id);
        if (result == null) {
            result = new ActionAdapter(this.getAction(id));
            this.adapters.put(id, result);
        }
        return result;
    }

    @Override
    public String[] getCategoryIDs() {
        String[] stringArray;
        if (this.defaultCategory != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.defaultCategory.getID();
        } else {
            stringArray = this.EMPTY_ARRAY;
        }
        return stringArray;
    }

    @Override
    public String[] getActionIDs() {
        if (this.map == null || this.map.size() == 0) {
            return this.EMPTY_ARRAY;
        }
        Object[] keys = this.map.keys();
        ArrayList<String> result = new ArrayList<String>(keys.length);
        for (Object key : keys) {
            if (!(key instanceof String)) continue;
            result.add((String)key);
        }
        return result.toArray(new String[result.size()]);
    }

    protected void fireRegistryEvent(String id, boolean added) {
        Object[] listeners = this.listenerList.getListenerList();
        RegistryEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegistryListener.class) continue;
            if (event == null) {
                event = new RegistryEvent(this, id);
            }
            if (added) {
                ((RegistryListener)listeners[i + 1]).actionRegistered(event);
                continue;
            }
            ((RegistryListener)listeners[i + 1]).actionRemoved(event);
        }
    }

    public void setActionMap(ActionMap map) {
        this.fireEvents(false);
        this.removeAdapters();
        this.map = map;
        this.fireEvents(true);
    }

    private void fireEvents(boolean b) {
        String[] ids;
        for (String id : ids = this.getActionIDs()) {
            this.fireRegistryEvent(id, b);
        }
    }

    @Override
    public void addRegistryListener(RegistryListener l) {
        this.listenerList.add(RegistryListener.class, l);
    }

    @Override
    public void removeRegistryListener(RegistryListener l) {
        this.listenerList.remove(RegistryListener.class, l);
    }
}

