/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.action.support;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.PropertiesConfigurer;
import chemaxon.marvin.uif.action.support.DefaultActionProperties;
import chemaxon.marvin.uif.action.support.PropertiesUtil;
import chemaxon.marvin.uif.resource.LazyIcon;
import chemaxon.marvin.uif.util.Utils;
import java.util.ResourceBundle;
import javax.swing.KeyStroke;

public class BundleBasedConfigurer
implements PropertiesConfigurer {
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String LARGE_ICON = "largeicon";
    public static final String SHORT_DESCRIPTION = "tooltip";
    public static final String LONG_DESCTIPTION = "helptext";
    public static final String ACCELERATOR = "accelerator";
    public static final String NAME_PATTERN = "namepattern";
    private final ResourceBundle bundle;

    public BundleBasedConfigurer(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public void configure(String id, String context, ActionProperties properties) {
        DefaultActionProperties p = this.loadFromBundle(id, context);
        PropertiesUtil.copy(p, properties);
    }

    private DefaultActionProperties loadFromBundle(String prefix, String suffix) {
        DefaultActionProperties result = new DefaultActionProperties();
        if (this.bundle == null) {
            return result;
        }
        String nameStr = Utils.getString(this.bundle, prefix, NAME, suffix, null);
        PropertiesUtil.configure(result, nameStr);
        result.setNamePattern(Utils.getString(this.bundle, prefix, NAME_PATTERN, suffix, null));
        result.setShortDescription(Utils.getString(this.bundle, prefix, SHORT_DESCRIPTION, suffix, result.getName()));
        result.setLongDescription(Utils.getString(this.bundle, prefix, LONG_DESCTIPTION, suffix, result.getName()));
        result.setSmallIcon(LazyIcon.createIcon(Utils.getString(this.bundle, prefix, ICON, suffix, null)));
        result.setLargeIcon(LazyIcon.createIcon(Utils.getString(this.bundle, prefix, LARGE_ICON, suffix, null)));
        result.setAccelerator(BundleBasedConfigurer.getAccelerator(Utils.getString(this.bundle, prefix, ACCELERATOR, suffix, null)));
        return result;
    }

    private static KeyStroke getAccelerator(String acceleratorString) {
        if (acceleratorString == null) {
            return null;
        }
        return KeyStroke.getKeyStroke(acceleratorString);
    }
}

