/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder;

import chemaxon.marvin.uif.builder.DefaultModuleConfiguration;
import chemaxon.marvin.uif.builder.impl.action.ActionSet;
import chemaxon.marvin.uif.builder.impl.action.Module;
import chemaxon.marvin.uif.builder.impl.config.Configuration;
import chemaxon.marvin.uif.builder.parser.ObjectParser;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.ModuleConfiguration;
import chemaxon.marvin.uif.module.support.DefaultGUIRegistry;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

final class ConfigurationRegistry {
    private static final Logger logger = Logger.getLogger(ConfigurationRegistry.class.getName());
    private static final ConfigurationRegistry INSTANCE = new ConfigurationRegistry();
    private Map<String, Module> modules;
    private Map<String, ActionSet> actions;
    private Map<String, Configuration> configurations;
    private Map<String, GUIRegistry> registries;
    private boolean disableSerialization;
    private boolean debug;

    public static ConfigurationRegistry getInstance() {
        return INSTANCE;
    }

    ConfigurationRegistry() {
        this.clear();
    }

    public synchronized GUIRegistry getRegistry(Class<?> clazz, String resource) throws ConfigurationException {
        String name = ConfigurationRegistry.resolveName(clazz, resource);
        ClassLoader loader = clazz != null ? clazz.getClassLoader() : null;
        GUIRegistry result = this.registries.get(name);
        if (result == null && (result = (GUIRegistry)this.readSerializedObject(loader, name + ".ser")) == null) {
            Configuration config = this.getActionUI(clazz, resource);
            result = new DefaultGUIRegistry(config.getID());
            config.configure(result);
        }
        return (GUIRegistry)result.clone();
    }

    public synchronized ModuleConfiguration getConfiguration(Class<?> clazz, String resource, String actionsResource) throws ConfigurationException {
        DefaultModuleConfiguration result = (DefaultModuleConfiguration)this.getConfiguration(clazz, resource);
        if (actionsResource != null) {
            ActionSet actionSet = this.getActionSet(clazz, actionsResource);
            if (this.actions != null) {
                result.load(new Module(actionSet, null));
            }
        }
        return result;
    }

    public synchronized ModuleConfiguration getConfiguration(Class<?> clazz, String resource) throws ConfigurationException {
        String resolvedName = ConfigurationRegistry.resolveName(clazz, resource);
        this.ensureExists(clazz != null ? clazz.getClassLoader() : null, resolvedName, Module.class, this.modules);
        Module module = this.modules.get(resolvedName);
        if (module == null) {
            return null;
        }
        DefaultModuleConfiguration result = new DefaultModuleConfiguration();
        result.setPath(ConfigurationRegistry.getPath(resolvedName));
        result.load(module.clone());
        return result;
    }

    public synchronized void clear() {
        this.modules = new HashMap<String, Module>();
        this.configurations = new HashMap<String, Configuration>();
        this.actions = new HashMap<String, ActionSet>(3);
        this.registries = new HashMap<String, GUIRegistry>(3);
        this.disableSerialization = Boolean.getBoolean("chemaxon.marvin.uif.builder.ConfigurationRegistry.disableSerialization");
        this.debug = Boolean.getBoolean("chemaxon.marvin.uif.builder.ConfigurationRegistry.debug");
    }

    synchronized Module getModule(String resource) throws ConfigurationException {
        String resolvedName = ConfigurationRegistry.resolveName(null, resource);
        this.ensureExists(null, resolvedName, Module.class, this.modules);
        return this.modules.get(resolvedName);
    }

    synchronized ActionSet getActionSet(Class<?> clazz, String resource) throws ConfigurationException {
        String resolvedName = ConfigurationRegistry.resolveName(clazz, resource);
        ClassLoader loader = clazz != null ? clazz.getClassLoader() : null;
        this.ensureExists(loader, resolvedName, ActionSet.class, this.actions);
        return this.actions.get(resolvedName);
    }

    synchronized Configuration getActionUI(Class<?> clazz, String resource) throws ConfigurationException {
        String resolvedName = ConfigurationRegistry.resolveName(clazz, resource);
        ClassLoader loader = clazz != null ? clazz.getClassLoader() : null;
        this.ensureExists(loader, resolvedName, Configuration.class, this.configurations);
        Configuration result = this.configurations.get(resolvedName);
        return result != null ? result.clone() : null;
    }

    private <E> void ensureExists(ClassLoader classLoader, String resource, Class<E> clazz, Map<String, E> cache) throws ConfigurationException {
        if (cache.containsKey(resource)) {
            return;
        }
        E result = clazz.cast(this.readSerializedObject(classLoader, resource + ".ser"));
        if (result == null) {
            result = this.parse(classLoader, resource, clazz);
        }
        cache.put(resource, result);
    }

    private <E> E parse(ClassLoader classLoader, String resource, Class<E> clazz) throws ConfigurationException {
        InputStream is = ConfigurationRegistry.getInputStream(classLoader, resource);
        if (is == null) {
            return null;
        }
        try {
            return clazz.cast(ObjectParser.parse(new BufferedInputStream(is), null));
        }
        catch (ClassCastException e) {
            throw new ConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
    }

    private static String getPath(String name) {
        int i = name.lastIndexOf(47);
        if (i == -1) {
            return name;
        }
        return name.substring(0, i);
    }

    private static String resolveName(Class<?> clazz, String name) {
        String result;
        if (name == null || clazz == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            Class<?> c = clazz;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            result = index != -1 ? baseName.substring(0, index).replace('.', '/') + "/" + name : name;
        } else {
            result = name.substring(1);
        }
        return result;
    }

    private static InputStream getInputStream(ClassLoader classLoader, String resource) {
        return classLoader != null ? classLoader.getResourceAsStream(resource) : ClassLoader.getSystemResourceAsStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readSerializedObject(ClassLoader loader, String resource) {
        if (this.disableSerialization) {
            return null;
        }
        InputStream is = ConfigurationRegistry.getInputStream(loader, resource);
        if (is == null) {
            return null;
        }
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(is);
            Object object = in.readObject();
            return object;
        }
        catch (IOException e) {
            this.handleException(e);
            Object var6_9 = null;
            return var6_9;
        }
        catch (ClassNotFoundException e) {
            this.handleException(e);
            Object var6_10 = null;
            return var6_10;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private void handleException(Exception e) {
        logger.log(Level.WARNING, e.getMessage(), e);
        if (this.debug) {
            throw new RuntimeException(e);
        }
    }
}

