/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.action;

import chemaxon.marvin.uif.builder.impl.action.ActionDescriptor;
import chemaxon.marvin.uif.util.SerialUtils;
import chemaxon.marvin.uif.util.Utils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class ActionGroupDescriptor
extends ActionDescriptor {
    private static final long serialVersionUID = 0L;
    private List<String> refIDs;
    private String defaultID;

    public ActionGroupDescriptor() {
        this.init();
    }

    private void init() {
        this.refIDs = new ArrayList<String>(5);
    }

    public void addEntry(String actionID) {
        this.refIDs.add(actionID);
        if (this.defaultID == null) {
            this.defaultID = actionID;
        }
    }

    public String[] getEntries() {
        return this.refIDs.toArray(new String[this.refIDs.size()]);
    }

    public String getDefaultID() {
        return this.defaultID;
    }

    public void setDefaultID(String defaultID) {
        this.defaultID = defaultID;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.defaultID = SerialUtils.readString(in);
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            this.refIDs.add(SerialUtils.readString(in));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        SerialUtils.writeString(out, this.defaultID);
        out.writeInt(this.refIDs.size());
        for (String id : this.refIDs) {
            SerialUtils.writeString(out, id);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ActionGroupDescriptor)) {
            return false;
        }
        ActionGroupDescriptor other = (ActionGroupDescriptor)obj;
        return super.equals(obj) && Utils.equals(this.refIDs, other.refIDs) && Utils.equals(this.defaultID, other.defaultID);
    }
}

