/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.action;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.Category;
import chemaxon.marvin.uif.action.PropertiesConfigurer;
import chemaxon.marvin.uif.action.manager.DefaultActionStub;
import chemaxon.marvin.uif.action.support.DefaultActionGroup;
import chemaxon.marvin.uif.action.support.DefaultActionProperties;
import chemaxon.marvin.uif.builder.impl.action.ActionDescriptor;
import chemaxon.marvin.uif.builder.impl.action.ActionFactoryDescriptor;
import chemaxon.marvin.uif.builder.impl.action.ActionGroupDescriptor;
import chemaxon.marvin.uif.builder.impl.action.PropertiesConfigurerImpl;
import chemaxon.marvin.uif.builder.impl.action.SchemeInfo;
import chemaxon.marvin.uif.builder.impl.action.ShortcutInfo;
import chemaxon.marvin.uif.builder.impl.action.ShortcutsInfo;
import chemaxon.marvin.uif.module.ActionFactory;
import chemaxon.marvin.uif.module.Configurer;
import chemaxon.marvin.uif.shortcut.ShortcutManager;
import chemaxon.marvin.uif.util.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;

public class ActionSet
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private List<ActionDescriptor> actions = new ArrayList<ActionDescriptor>();
    private List<ActionFactoryDescriptor> factories = new ArrayList<ActionFactoryDescriptor>(5);
    private List<Category> categories = new ArrayList<Category>(5);
    private ShortcutsInfo shortcuts = new ShortcutsInfo();

    private PropertiesConfigurer createConfigurer() {
        PropertiesConfigurerImpl result = new PropertiesConfigurerImpl();
        for (ActionDescriptor descriptor : this.actions) {
            this.fillConfigurer(result, descriptor);
            for (ActionDescriptor childDescriptor : descriptor.getChilds()) {
                this.fillConfigurer(result, childDescriptor);
            }
        }
        return result;
    }

    private void fillConfigurer(PropertiesConfigurerImpl result, ActionDescriptor descriptor) {
        Map<String, DefaultActionProperties> contexts = descriptor.getProperties();
        for (String contextID : contexts.keySet()) {
            result.addActionProperties(descriptor.getID(), contextID, contexts.get(contextID));
        }
    }

    public void add(ActionSet actionSet) {
        this.addActions(actionSet);
        this.addCategories(actionSet);
        this.addShortcuts(actionSet);
    }

    private void addCategories(ActionSet actionSet) {
        for (Category category : actionSet.categories) {
            this.addCategory(category);
        }
    }

    private void addActions(ActionSet actionSet) {
        this.actions.addAll(actionSet.actions);
        this.factories.addAll(actionSet.factories);
    }

    private void addShortcuts(ActionSet actionSet) {
        this.shortcuts.add(actionSet.shortcuts);
    }

    public void addAction(ActionDescriptor descriptor) {
        this.actions.add(descriptor);
    }

    public void addFactory(ActionFactoryDescriptor descriptor) {
        this.factories.add(descriptor);
    }

    public ActionDescriptor[] getLocalActions() {
        return this.actions.toArray(new ActionDescriptor[this.actions.size()]);
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public Category[] getCategories() {
        return this.categories.toArray(new Category[this.categories.size()]);
    }

    public void addShortcut(ShortcutInfo shortcut) {
        this.shortcuts.addShortcut(shortcut);
    }

    public void addShortcutSchema(SchemeInfo schema) {
        this.shortcuts.addScheme(schema);
    }

    public ShortcutsInfo getShortcuts() {
        return this.shortcuts;
    }

    public void installActions(ActionRegistry registry, Configurer[] configurers) {
        this.installCategories(registry);
        this.installConfigurers(registry);
        this.installFactoryActions(registry, configurers);
        this.installRegularActions(registry, configurers);
    }

    private void installRegularActions(ActionRegistry registry, Configurer[] configurers) {
        for (ActionDescriptor action : this.actions) {
            this.registerAction(registry, action, configurers);
        }
    }

    private void installFactoryActions(ActionRegistry registry, Configurer[] configurers) {
        for (ActionFactoryDescriptor factory : this.factories) {
            this.addFactoryActions(registry, factory, configurers);
        }
    }

    private void installConfigurers(ActionRegistry registry) {
        registry.addConfigurer(this.createConfigurer());
    }

    private void registerAction(ActionRegistry registry, ActionDescriptor descriptor, Configurer[] configurers) {
        if (descriptor.getClassName() == null && !(descriptor instanceof ActionGroupDescriptor)) {
            return;
        }
        if (descriptor.isEnumerated()) {
            ActionDescriptor[] descriptors = descriptor.getChilds();
            for (int i = 0; i < descriptors.length; ++i) {
                SimpleActionStub action = new SimpleActionStub(descriptor.getClassName(), configurers, i, descriptors[i].getSubID());
                this.register(registry, action, descriptor.getCategoryID(), descriptors[i].getID());
            }
        } else {
            SimpleActionStub action = descriptor instanceof ActionGroupDescriptor ? new ActionGroupStub((ActionGroupDescriptor)descriptor, configurers, registry) : new SimpleActionStub(descriptor.getClassName(), configurers);
            this.register(registry, action, descriptor.getCategoryID(), descriptor.getID());
        }
    }

    private void register(ActionRegistry registry, Action action, String categoryID, String id) {
        String category = categoryID;
        if (categoryID != null && registry.getCategory(categoryID) == null) {
            System.err.println("Missing category for action " + id);
            category = null;
        }
        registry.register(id, category, action);
    }

    private void addFactoryActions(ActionRegistry registry, ActionFactoryDescriptor descriptor, Configurer[] configurers) {
        try {
            Object o = descriptor.createInstance();
            ActionSet.configure(o, configurers);
            ActionFactory factory = (ActionFactory)o;
            Action[] actions = factory.createActions();
            for (int i = 0; i < actions.length; ++i) {
                ActionSet.configure(actions[i], configurers);
                registry.register((String)actions[i].getValue("ActionCommandKey"), descriptor.getCategoryID(), actions[i]);
            }
        }
        catch (Exception e) {
            System.err.println("Invalid factory class " + descriptor.getFactoryClassName());
            e.printStackTrace();
        }
    }

    private void installCategories(ActionRegistry manager) {
        for (Category category : this.categories) {
            if (manager.getCategory(category.getID()) != null) continue;
            manager.registerCategory(category);
        }
    }

    public void installShortcuts(ShortcutManager manager) {
        this.shortcuts.installShortcuts(manager);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int actionCount = in.readInt();
        for (int i = 0; i < actionCount; ++i) {
            ActionDescriptor action = in.readBoolean() ? new ActionGroupDescriptor() : new ActionDescriptor();
            action.readExternal(in);
            this.actions.add(action);
        }
        int factoryCount = in.readInt();
        for (int i = 0; i < factoryCount; ++i) {
            ActionFactoryDescriptor factory = new ActionFactoryDescriptor();
            factory.readExternal(in);
            this.factories.add(factory);
        }
        int categoryCount = in.readInt();
        for (int i = 0; i < categoryCount; ++i) {
            Category category = new Category();
            category.readExternal(in);
            this.categories.add(category);
        }
        this.shortcuts.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.actions.size());
        for (ActionDescriptor action : this.actions) {
            out.writeBoolean(action instanceof ActionGroupDescriptor);
            action.writeExternal(out);
        }
        out.writeInt(this.factories.size());
        for (ActionFactoryDescriptor factory : this.factories) {
            factory.writeExternal(out);
        }
        out.writeInt(this.categories.size());
        for (Category category : this.categories) {
            category.writeExternal(out);
        }
        this.shortcuts.writeExternal(out);
    }

    public int hashCode() {
        return Utils.hash(this.actions, this.factories, this.categories, this.shortcuts);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ActionSet)) {
            return false;
        }
        ActionSet other = (ActionSet)obj;
        return Utils.equals(this.actions, other.actions) && Utils.equals(this.factories, other.factories) && Utils.equals(this.categories, other.categories) && Utils.equals(this.shortcuts, other.shortcuts);
    }

    private static void configure(Object object, Configurer[] configurers) {
        for (int i = 0; i < configurers.length; ++i) {
            configurers[i].configure(object);
        }
    }

    private static class ActionGroupStub
    extends SimpleActionStub {
        private String[] ids;
        private String defaultID;
        private ActionRegistry registry;

        public ActionGroupStub(ActionGroupDescriptor descriptor, Configurer[] configurers, ActionRegistry registry) {
            super(descriptor.getClassName(), configurers);
            this.ids = descriptor.getEntries();
            this.defaultID = descriptor.getDefaultID();
            this.registry = registry;
        }

        @Override
        public void init(Action action) {
            super.init(action);
            if (action instanceof DefaultActionGroup) {
                ((DefaultActionGroup)action).init(this.registry, this.defaultID, this.ids);
            }
        }
    }

    private static class SimpleActionStub
    extends DefaultActionStub {
        private final Configurer[] configurers;

        public SimpleActionStub(String className, Configurer[] configurers) {
            this(className, configurers, -1, null);
        }

        public SimpleActionStub(String className, Configurer[] configurers, int index, String enumID) {
            super(className, index, enumID);
            this.configurers = configurers;
        }

        @Override
        public void init(Action action) {
            super.init(action);
            ActionSet.configure(action, this.configurers);
        }
    }
}

