/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.action;

import chemaxon.marvin.uif.builder.impl.action.SchemeInfo;
import chemaxon.marvin.uif.builder.impl.action.ShortcutInfo;
import chemaxon.marvin.uif.shortcut.KeyboardShortcut;
import chemaxon.marvin.uif.shortcut.Shortcut;
import chemaxon.marvin.uif.shortcut.ShortcutManager;
import chemaxon.marvin.uif.shortcut.ShortcutScheme;
import chemaxon.marvin.uif.shortcut.ShortcutUtil;
import chemaxon.marvin.uif.util.SerialUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

public class ShortcutsInfo
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private List<SchemeInfo> schemes = new ArrayList<SchemeInfo>(3);
    private List<ShortcutInfo> shortcuts = new ArrayList<ShortcutInfo>(10);
    private String active;

    public ShortcutsInfo() {
    }

    public ShortcutsInfo(ShortcutManager manager) {
        this();
        int i;
        ShortcutScheme[] schemes = manager.getShortcutSchemes();
        for (i = 0; i < schemes.length; ++i) {
            this.addScheme(new SchemeInfo(schemes[i].getID(), schemes[i].getParentID(), schemes[i].getName()));
        }
        for (i = 0; i < schemes.length; ++i) {
            Shortcut[] shortcuts = schemes[i].getOverridenShortcuts();
            for (int j = 0; j < shortcuts.length; ++j) {
                if (!(shortcuts[j] instanceof KeyboardShortcut)) continue;
                KeyboardShortcut shortcut = (KeyboardShortcut)shortcuts[j];
                this.addShortcut(new ShortcutInfo(ShortcutUtil.keyToString(shortcut.getKeyStroke()), schemes[i].getCommandID(shortcuts[j]), schemes[i].getID()));
            }
        }
        this.setActive(manager.getActive());
    }

    public void add(ShortcutsInfo info) {
        SchemeInfo[] schemes = info.getSchemes();
        for (int i = 0; i < schemes.length; ++i) {
            this.addScheme(schemes[i]);
        }
        ShortcutInfo[] shortcuts = info.getShortcuts();
        for (int i = 0; i < shortcuts.length; ++i) {
            this.addShortcut(shortcuts[i]);
        }
    }

    public SchemeInfo[] getSchemes() {
        return this.schemes.toArray(new SchemeInfo[this.schemes.size()]);
    }

    public void addScheme(SchemeInfo info) {
        this.schemes.add(info);
    }

    public ShortcutInfo[] getShortcuts() {
        return this.shortcuts.toArray(new ShortcutInfo[this.shortcuts.size()]);
    }

    public void addShortcut(ShortcutInfo info) {
        this.shortcuts.add(info);
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public void installShortcuts(ShortcutManager manager) {
        for (SchemeInfo schemeInfo : this.schemes) {
            if (schemeInfo.isDeleted()) {
                manager.removeShortcutSchema(schemeInfo.getId());
                continue;
            }
            ShortcutScheme parentScheme = null;
            if (schemeInfo.getParentID() != null && (parentScheme = manager.getShortcutScheme(schemeInfo.getParentID())) == null) {
                System.err.println("Missing parent scheme for " + schemeInfo.getId());
                continue;
            }
            if (!manager.hasShortcutSchema(schemeInfo.getId())) {
                manager.addShortcutScheme(new ShortcutScheme(parentScheme, schemeInfo.getId(), schemeInfo.getDisplayName()));
                continue;
            }
            if (schemeInfo.getDisplayName() == null) continue;
            manager.getShortcutScheme(schemeInfo.getId()).setName(schemeInfo.getDisplayName());
        }
        for (ShortcutInfo shortcutInfo : this.shortcuts) {
            KeyStroke keyStroke = ShortcutUtil.stringToKey(shortcutInfo.getKeyStroke());
            if (keyStroke == null) {
                System.err.println("Invalid shortcut keystroke: " + shortcutInfo.getKeyStroke());
                continue;
            }
            ShortcutScheme scheme = manager.getShortcutScheme(shortcutInfo.getSchemeID());
            if (scheme == null) {
                System.err.println("Missing scheme " + shortcutInfo.getSchemeID() + " for key " + shortcutInfo.getKeyStroke());
                continue;
            }
            scheme.addShortcut(shortcutInfo.getCommandID(), new KeyboardShortcut(keyStroke));
        }
        if (this.active != null) {
            manager.setActive(this.active);
        }
    }

    public int hashCode() {
        return ((Object)this.shortcuts).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortcutsInfo)) {
            return false;
        }
        ShortcutsInfo other = (ShortcutsInfo)obj;
        return ((Object)this.shortcuts).equals(other.shortcuts) && ((Object)this.schemes).equals(other.schemes) && (this.active == other.active || this.active != null && this.active.equals(other.active));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.active = SerialUtils.readString(in);
        int schemeCount = in.readInt();
        for (int i = 0; i < schemeCount; ++i) {
            SchemeInfo scheme = new SchemeInfo();
            scheme.readExternal(in);
            this.schemes.add(scheme);
        }
        int shortcutCount = in.readInt();
        for (int i = 0; i < shortcutCount; ++i) {
            ShortcutInfo shortcut = new ShortcutInfo();
            shortcut.readExternal(in);
            this.shortcuts.add(shortcut);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.active);
        out.writeInt(this.schemes.size());
        for (SchemeInfo scheme : this.schemes) {
            scheme.writeExternal(out);
        }
        out.writeInt(this.shortcuts.size());
        for (ShortcutInfo shortcut : this.shortcuts) {
            shortcut.writeExternal(out);
        }
    }
}

