/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.MenuPathHelper;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ToolBarGroup;
import chemaxon.marvin.uif.util.SerialUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AddConfigurationEntry
implements ConfigurationEntry,
Externalizable {
    private static final long serialVersionUID = 0L;
    public static final String ANCHOR_START_VALUE = "start";
    public static final String ANCHOR_END_VALUE = "end";
    private String path;
    private List<Item> items;
    private String anchor;

    public AddConfigurationEntry() {
    }

    public AddConfigurationEntry(String path, String anchor) {
        this(path, new ArrayList<Item>(), anchor);
    }

    public AddConfigurationEntry(String path, List<Item> items) {
        this(path, items, null);
    }

    public AddConfigurationEntry(String path, List<Item> items, String anchor) {
        this.path = path;
        this.items = new ArrayList<Item>(items);
        this.anchor = anchor;
    }

    @Override
    public void apply(GUIRegistry registry) {
        if (this.items.isEmpty()) {
            System.err.println("Empty <add> configuration entry for.");
            return;
        }
        if (this.path.length() == 0) {
            this.setMenuBar(registry);
        } else if ("popup".equals(this.path)) {
            this.addPopups(registry);
        } else if ("toolbar".equals(this.path)) {
            this.addToolBars(registry);
        } else {
            this.addToGroup(MenuPathHelper.findGroup(registry, this.path));
        }
    }

    public String getPath() {
        return this.path;
    }

    public List<Item> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public void addAll(Collection<Item> items) {
        items.addAll(items);
    }

    public void addItem(Item item) {
        this.items.add(item);
    }

    public String getAnchor() {
        return this.anchor;
    }

    private void addToGroup(ItemGroup group) {
        if (group == null) {
            return;
        }
        int pos = this.isAppend() ? group.getItemCount() : 0;
        for (int i = 0; i < this.items.size(); ++i) {
            group.add(this.items.get(i), pos + i);
        }
    }

    private void addPopups(GUIRegistry registry) {
        for (Item item : this.items) {
            if (!(item instanceof ItemGroup)) continue;
            registry.addPopup((ItemGroup)item);
        }
    }

    private void addToolBars(GUIRegistry registry) {
        for (Item item : this.items) {
            if (!(item instanceof ToolBarGroup)) continue;
            registry.addToolBar((ToolBarGroup)item);
        }
    }

    private void setMenuBar(GUIRegistry registry) {
        Item item = this.items.get(0);
        if (item instanceof ItemGroup) {
            registry.setMenuBar((ItemGroup)item);
        }
    }

    private boolean isAppend() {
        return !ANCHOR_START_VALUE.equals(this.anchor);
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddConfigurationEntry)) {
            return false;
        }
        AddConfigurationEntry other = (AddConfigurationEntry)obj;
        return (this.path == other.path || this.path != null && this.path.equals(other.path)) && (this.anchor == other.anchor || this.anchor != null && this.anchor.equals(other.anchor)) && (this.items == other.items || this.items != null && ((Object)this.items).equals(other.items));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = SerialUtils.readString(in);
        this.anchor = SerialUtils.readString(in);
        this.items = SerialUtils.readList(in, Item.class);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.path);
        SerialUtils.writeString(out, this.anchor);
        SerialUtils.writeCollection(out, this.items);
    }
}

