/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.util.PublicCloneable;
import chemaxon.marvin.uif.util.SerialUtils;
import chemaxon.marvin.uif.util.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Configuration
implements PublicCloneable<Configuration>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private String id;
    private String displayName;
    private String parentID;
    private String includePath;
    private Boolean largeIcons;
    private ArrayList<ConfigurationEntry> entries;

    public Configuration() {
    }

    public Configuration(String id) {
        this(id, null, null);
    }

    public Configuration(String id, String parent, String displayName) {
        this(id, parent, displayName, null);
    }

    public Configuration(String id, String parent, String displayName, String includePath) {
        this.id = id;
        this.displayName = displayName;
        this.parentID = parent;
        this.includePath = includePath;
        this.entries = new ArrayList(5);
    }

    public void add(Configuration config) {
        if (config.displayName != null) {
            this.displayName = config.displayName;
        }
        if (config.largeIcons != null) {
            this.largeIcons = config.largeIcons;
        }
        this.entries.addAll(config.entries);
    }

    public void addEntry(ConfigurationEntry entry) {
        this.entries.add(entry);
    }

    public List<ConfigurationEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void configure(GUIRegistry registry) {
        if (this.displayName != null) {
            registry.setDisplayName(this.displayName);
        }
        if (this.largeIcons != null) {
            registry.setUseLargeIcons(this.largeIcons);
        }
        for (ConfigurationEntry entry : this.entries) {
            entry.apply(registry);
        }
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getParent() {
        return this.parentID;
    }

    public void setParent(String parent) {
        this.parentID = parent;
    }

    public Boolean isLargeIcons() {
        return this.largeIcons;
    }

    public void setLargeIcons(Boolean largeIcons) {
        this.largeIcons = largeIcons;
    }

    public String getIncludePath() {
        return this.includePath;
    }

    public void setIncludePath(String includePath) {
        this.includePath = includePath;
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }

    @Override
    public Configuration clone() {
        try {
            Configuration result = (Configuration)super.clone();
            result.entries = new ArrayList<ConfigurationEntry>(this.entries);
            return result;
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return Utils.equals(this.id, other.id) && Utils.equals(this.displayName, other.displayName) && Utils.equals(this.parentID, other.parentID) && Utils.equals(this.includePath, other.includePath) && Utils.equals(this.largeIcons, other.largeIcons) && Utils.equals(this.entries, other.entries);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = SerialUtils.readString(in);
        this.displayName = SerialUtils.readString(in);
        this.parentID = SerialUtils.readString(in);
        this.includePath = SerialUtils.readString(in);
        this.largeIcons = SerialUtils.readBoolean(in);
        this.entries = SerialUtils.readList(in, ConfigurationEntry.class);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.id);
        SerialUtils.writeString(out, this.displayName);
        SerialUtils.writeString(out, this.parentID);
        SerialUtils.writeString(out, this.includePath);
        SerialUtils.writeBoolean(out, this.largeIcons);
        SerialUtils.writeCollection(out, this.entries);
    }
}

