/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.builder.impl.config;

import chemaxon.marvin.uif.builder.impl.config.ConfigurationEntry;
import chemaxon.marvin.uif.builder.impl.config.MenuPathHelper;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.util.SerialUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoveConfigurationEntry
implements ConfigurationEntry,
Externalizable {
    private static final long serialVersionUID = 0L;
    private String path;

    public RemoveConfigurationEntry() {
    }

    public RemoveConfigurationEntry(String path) {
        this.path = path;
    }

    @Override
    public void apply(GUIRegistry registry) {
        Item item;
        if ("menubar".equals(this.path)) {
            registry.setMenuBar(null);
        }
        if ((item = MenuPathHelper.findItem(registry, this.path)) == null) {
            return;
        }
        if (MenuPathHelper.isToolBar(this.path)) {
            registry.removeToolBar(item.getID());
        } else if (MenuPathHelper.isPopup(this.path)) {
            registry.removePopup(item.getID());
        } else if (item.getParent() != null) {
            item.getParent().remove(item);
        }
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoveConfigurationEntry)) {
            return false;
        }
        RemoveConfigurationEntry other = (RemoveConfigurationEntry)obj;
        return this.path == other.path || this.path != null && this.path.equals(other.path);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.path = SerialUtils.readString(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerialUtils.writeString(out, this.path);
    }
}

