/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl;

import chemaxon.marvin.uif.action.GUIDefaults;
import chemaxon.marvin.uif.component.ButtonFactory;
import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.controller.TopLevelController;
import chemaxon.marvin.uif.controller.impl.binding.BindingManager;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.controller.support.AbstractGroupController;
import chemaxon.marvin.uif.controller.support.ItemController;
import chemaxon.marvin.uif.controller.support.ItemControllerFactory;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

abstract class AbstractTopLevelController<T extends ItemController, E extends JComponent>
extends AbstractGroupController<T, E>
implements TopLevelController<E> {
    private boolean showMenuIcons;
    private boolean showMnemonic;
    private ButtonFactory buttonFactory;
    private MenuFactory menuFactory;
    private BindingManager manager;
    private PropertyChangeListener uiHandler;

    public AbstractTopLevelController(ItemGroup group, ItemControllerFactory factory, BindingManager manager) {
        super(group, factory);
        this.manager = manager;
        this.init();
    }

    private void init() {
        this.showMenuIcons = GUIDefaults.getDefaultMenuIconVisible();
        this.showMnemonic = GUIDefaults.getDefaultMnemonicVisible();
    }

    @Override
    protected void initContainer(E container) {
        this.uiHandler = new UIHandler(this, container);
        ((Container)container).addPropertyChangeListener(this.uiHandler);
    }

    protected ConfigurationContext getContext() {
        return new ConfigurationContext(this.getShowMenuIcons(), this.getShowMnemonic());
    }

    protected final void updateBindings() {
        this.manager.setContext(this.getContext());
        if (this.hasComponent()) {
            ((JComponent)this.getContainer()).revalidate();
            ((Component)this.getContainer()).repaint();
        }
    }

    @Override
    public boolean getShowMenuIcons() {
        return this.showMenuIcons;
    }

    @Override
    public boolean getShowMnemonic() {
        return this.showMnemonic;
    }

    @Override
    public void setShowMenuIcons(boolean showMenuIcons) {
        if (showMenuIcons != this.getShowMenuIcons()) {
            this.showMenuIcons = showMenuIcons;
            this.updateBindings();
        }
    }

    @Override
    public void setShowMnemonic(boolean showMnemonic) {
        if (showMnemonic != this.getShowMnemonic()) {
            this.showMnemonic = showMnemonic;
            this.updateBindings();
        }
    }

    ButtonFactory getButtonFactory() {
        return this.buttonFactory;
    }

    void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    MenuFactory getMenuFactory() {
        return this.menuFactory;
    }

    void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
    }

    protected void uiChanged() {
        this.updateUI();
    }

    @Override
    public void dispose() {
        this.manager.releaseAll();
        if (this.hasComponent()) {
            ((Component)this.getContainer()).removePropertyChangeListener(this.uiHandler);
        }
        super.dispose();
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static class UIHandler
    extends WeakPropertyChangeListener {
        public UIHandler(AbstractTopLevelController<?, ?> target, Object source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || "UI".equals(evt.getPropagationId())) {
                ((AbstractTopLevelController)target).uiChanged();
            }
        }
    }
}

