/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.RegistryEvent;
import chemaxon.marvin.uif.action.RegistryListener;
import chemaxon.marvin.uif.action.support.WeakRegistryListener;
import chemaxon.marvin.uif.component.ButtonFactory;
import chemaxon.marvin.uif.component.DefaultButtonFactory;
import chemaxon.marvin.uif.component.DefaultMenuFactory;
import chemaxon.marvin.uif.component.MenuFactory;
import chemaxon.marvin.uif.controller.impl.MenuController;
import chemaxon.marvin.uif.controller.impl.binding.BindingManager;
import chemaxon.marvin.uif.controller.impl.binding.BindingProvider;
import chemaxon.marvin.uif.controller.impl.item.ItemFactory;
import chemaxon.marvin.uif.controller.support.FactoryListener;
import chemaxon.marvin.uif.controller.support.ItemControllerFactory;
import chemaxon.marvin.uif.controller.support.MenuItemController;
import chemaxon.marvin.uif.controller.support.SeparatorController;
import chemaxon.marvin.uif.controller.support.ToolBarItemController;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.util.swing.NullAction;
import javax.swing.Action;
import javax.swing.event.EventListenerList;

public class DefaultControllerFactory
implements ItemControllerFactory,
RegistryListener {
    private ItemFactory factory;
    private BindingManager manager;
    private ActionRegistry registry;
    private MenuFactory menuFactory;
    private ButtonFactory buttonFactory;
    private RegistryListener listener;
    private EventListenerList listenerList;
    private boolean lazyMenus = true;

    public DefaultControllerFactory(ActionRegistry registry, String faceName) {
        this(registry, faceName, DefaultButtonFactory.getInstance(), DefaultMenuFactory.getInstance());
    }

    public DefaultControllerFactory(ActionRegistry registry, String faceName, ButtonFactory buttonFactory, MenuFactory menuFactory) {
        this.registry = registry;
        this.menuFactory = menuFactory;
        this.buttonFactory = buttonFactory;
        this.manager = new BindingManager(registry, faceName);
        this.factory = new ItemFactory(this.manager, menuFactory, buttonFactory);
        this.listenerList = new EventListenerList();
        this.listener = new WeakRegistryListener(this, registry);
    }

    private Action createDummy(Item command) {
        NullAction result = new NullAction(null);
        result.putValue("ActionCommandKey", command.getID());
        return result;
    }

    public BindingManager getBindingManager() {
        return this.manager;
    }

    @Override
    public MenuItemController createMenuController(Item command) {
        if (command.isSeparator()) {
            return new SeparatorController();
        }
        if (command instanceof ItemGroup) {
            return this.createMenu(command);
        }
        return this.createMenuItem(command);
    }

    private MenuItemController createMenuItem(Item command) {
        Action action = this.registry.getAction(command.getID());
        if (action == null) {
            return null;
        }
        return this.factory.createController(action, command.getDisplayProperties());
    }

    private MenuController createMenu(Item command) {
        ItemGroup group = (ItemGroup)command;
        Action action = this.registry.getAction(command.getID());
        if (action == null) {
            action = this.createDummy(command);
        }
        MenuController result = new MenuController(group, this, this.createBindingProvider(command.getDisplayProperties(), action), this.menuFactory);
        result.setLazyUpdate(this.lazyMenus);
        return result;
    }

    private BindingProvider createBindingProvider(DisplayProperties properties, Action action) {
        return this.manager.createProvider(action, properties);
    }

    @Override
    public ToolBarItemController createToolBarController(Item command) {
        if (command.isSeparator()) {
            return new SeparatorController();
        }
        Action action = this.registry.getAction(command.getID());
        if (action != null) {
            return this.factory.createToolBarController(action, command.getDisplayProperties());
        }
        return null;
    }

    public void setButtonFactory(ButtonFactory buttonFactory) {
        this.buttonFactory = buttonFactory;
        this.reconfigureFactory();
    }

    public void setMenuFactory(MenuFactory menuFactory) {
        this.menuFactory = menuFactory;
        this.reconfigureFactory();
    }

    private void reconfigureFactory() {
        this.factory.setButtonFactory(this.buttonFactory);
        this.factory.setMenuFactory(this.menuFactory);
    }

    private void fireFactoryChanged(String itemID) {
        FactoryListener[] listeners = (FactoryListener[])this.listenerList.getListeners(FactoryListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].controllerChanged(itemID);
        }
    }

    public boolean getUseLazyMenus() {
        return this.lazyMenus;
    }

    public void setUseLazyMenus(boolean lazyMenus) {
        this.lazyMenus = lazyMenus;
    }

    @Override
    public synchronized void addFactoryListener(FactoryListener listener) {
        this.listenerList.add(FactoryListener.class, listener);
        if (this.listenerList.getListenerCount(FactoryListener.class) == 1) {
            this.registry.addRegistryListener(this.listener);
        }
    }

    @Override
    public synchronized void removeFactoryListener(FactoryListener listener) {
        this.listenerList.remove(FactoryListener.class, listener);
        if (this.listenerList.getListenerCount(FactoryListener.class) == 0) {
            this.registry.removeRegistryListener(this.listener);
        }
    }

    @Override
    public void actionRegistered(RegistryEvent e) {
        this.fireFactoryChanged(e.getActionID());
    }

    @Override
    public void actionRemoved(RegistryEvent e) {
        this.fireFactoryChanged(e.getActionID());
    }
}

