/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.controller.impl.binding.Binding;
import chemaxon.marvin.uif.controller.impl.binding.BindingProvider;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.model.DisplayProperties;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JComponent;

public class BindingManager {
    private static final Object BINDING_KEY = "bindingKey";
    private final Map<JComponent, Object> components;
    private final ActionRegistry registry;
    private final String faceName;
    private ConfigurationContext context;

    public BindingManager(ActionRegistry registry, String faceName) {
        this(new ConfigurationContext(), registry, faceName);
    }

    public BindingManager(ConfigurationContext initialContext, ActionRegistry registry, String faceName) {
        this.context = initialContext;
        this.components = new WeakHashMap<JComponent, Object>();
        this.registry = registry;
        this.faceName = faceName;
    }

    public BindingProvider createProvider(Action action, String alternateFaceName) {
        return this.createProvider(action, alternateFaceName, null);
    }

    public BindingProvider createProvider(String actionID, DisplayProperties properties) {
        return new BindingProvider(this, this.registry.getAction(actionID), this.registry.getActionFace(actionID, this.faceName), properties);
    }

    public BindingProvider createProvider(Action action, DisplayProperties properties) {
        return this.createProvider(action, this.faceName, properties);
    }

    private BindingProvider createProvider(Action action, String face, DisplayProperties properties) {
        String actionID = this.registry.getID(action);
        if (actionID == null) {
            return new BindingProvider(this, action, properties);
        }
        return new BindingProvider(this, action, this.registry.getActionFace(actionID, face), properties);
    }

    public void releaseAll() {
        JComponent[] items;
        for (JComponent item : items = this.components.keySet().toArray(new JComponent[this.components.size()])) {
            this.release(item);
        }
    }

    public void release(JComponent component) {
        if (!this.components.containsKey(component)) {
            return;
        }
        this.components.remove(component);
        Binding binding = BindingManager.getBinding(component);
        if (binding != null) {
            binding.release();
            BindingManager.setBinding(component, null);
        }
    }

    void registerBinding(JComponent component, Binding binding) {
        this.release(component);
        BindingManager.setBinding(component, binding);
        this.components.put(component, Boolean.TRUE);
        binding.setContext(this.context);
    }

    public ConfigurationContext getContext() {
        return this.context;
    }

    public void setContext(ConfigurationContext context) {
        this.context = context;
        for (JComponent component : this.components.keySet()) {
            Binding binding = BindingManager.getBinding(component);
            if (binding == null) continue;
            binding.setContext(context);
        }
    }

    private static Binding getBinding(JComponent component) {
        return (Binding)component.getClientProperty(BINDING_KEY);
    }

    private static void setBinding(JComponent component, Binding binding) {
        component.putClientProperty(BINDING_KEY, binding);
    }
}

