/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.support.DefaultActionProperties;
import chemaxon.marvin.uif.action.support.PropertiesUtil;
import chemaxon.marvin.uif.controller.impl.binding.Binding;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.controller.impl.binding.Configurer;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.util.listener.ActionPropertyChangeListener;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;

class ButtonBinding
implements Binding {
    private AbstractButton button;
    private Configurer configurer;
    private Action action;
    private DisplayProperties displayProperties;
    private ActionProperties face;
    private PropertyChangeListener actionPropertyChangeHandler;
    private PropertyChangeListener displayPropertyHandler;
    private ConfigurationContext context;
    private FaceHandler faceHandler;

    public ButtonBinding(AbstractButton button, Action action, ActionProperties face, DisplayProperties properties, Configurer configurer) {
        this(button, action, face, properties, configurer, null);
    }

    public ButtonBinding(AbstractButton button, Action action, ActionProperties face, DisplayProperties properties, Configurer configurer, ConfigurationContext initialContext) {
        this.button = button;
        this.action = action;
        this.configurer = configurer;
        this.context = initialContext;
        this.face = face;
        this.displayProperties = properties;
        this.init();
    }

    private void init() {
        this.updateEnablement();
        this.updateVisibility();
        this.setActionCommand();
        this.initListeners();
        this.registerListeners();
        this.reconfigureButton();
    }

    private ActionProperties createProperties() {
        String name;
        DefaultActionProperties result = new DefaultActionProperties(this.face);
        if (result.getNamePattern() != null && (name = this.decodeString(result.getNamePattern())) != null) {
            PropertiesUtil.configure(result, this.decodeString(result.getNamePattern()));
        }
        if (this.displayProperties != null) {
            if (this.displayProperties.getIcon() != null) {
                result.setSmallIcon(this.displayProperties.getIcon());
            }
            if (this.displayProperties.getDisplayName() != null) {
                PropertiesUtil.configure(result, this.displayProperties.getDisplayName());
            }
            if (this.displayProperties.getHelpID() != null) {
                result.setHelpID(this.displayProperties.getHelpID());
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String decodeString(String name) {
        if (name == null || name.indexOf("${") == -1) {
            return name;
        }
        StringBuffer result = new StringBuffer();
        int idx = name.indexOf("${");
        int current = 0;
        while (true) {
            if (idx == -1) {
                result.append(name.substring(current));
                return result.toString();
            }
            if (idx == 0 || idx > 0 && name.charAt(idx - 1) != '\\') {
                int endIndex = name.indexOf("}", current);
                if (endIndex == -1) {
                    System.out.println("Closing brace not found in " + name);
                    return null;
                }
                result.append(name.substring(current, idx));
                String propertyName = name.substring(idx + 2, endIndex);
                Object o = this.action.getValue(propertyName);
                if (o == null) {
                    return null;
                }
                result.append(o.toString());
                current = endIndex + 1;
            } else {
                result.append(name.substring(current, idx - 1));
                result.append("${");
                current = idx + 2;
            }
            idx = name.indexOf("${", current);
        }
    }

    private String getActionCommand() {
        return (String)this.action.getValue("ActionCommandKey");
    }

    private boolean isEnabeld() {
        return this.action.isEnabled();
    }

    private void initListeners() {
        this.actionPropertyChangeHandler = new ActionHandler((Object)this, this.action);
        this.faceHandler = new FaceHandler(this, this.face);
        if (this.displayProperties != null) {
            this.displayPropertyHandler = new DisplayPropertiesHandler(this, this.displayProperties);
        }
    }

    private void registerListeners() {
        this.action.addPropertyChangeListener(this.actionPropertyChangeHandler);
        this.face.addPropertyChangeListener(this.faceHandler);
        if (this.displayProperties != null) {
            this.displayProperties.addPropertyChangeListener(this.displayPropertyHandler);
        }
        this.button.addActionListener(this.action);
    }

    private void removeListeners() {
        this.action.removePropertyChangeListener(this.actionPropertyChangeHandler);
        this.face.removePropertyChangeListener(this.faceHandler);
        if (this.displayProperties != null) {
            this.displayProperties.removePropertyChangeListener(this.displayPropertyHandler);
        }
        this.button.removeActionListener(this.action);
    }

    protected final boolean isDisposed() {
        return this.button == null;
    }

    protected final AbstractButton getButton() {
        return this.button;
    }

    protected final Action getAction() {
        return this.action;
    }

    @Override
    public final void setContext(ConfigurationContext context) {
        if (context == null) {
            throw new NullPointerException("Context cannot be null");
        }
        ConfigurationContext oldContext = this.context;
        this.context = context;
        if (!context.equals(oldContext)) {
            this.reconfigureButton();
            this.updateEnablement();
        }
    }

    @Override
    public void release() {
        this.removeListeners();
        this.displayProperties = null;
        this.displayPropertyHandler = null;
        this.face = null;
        this.faceHandler = null;
        this.action = null;
        this.actionPropertyChangeHandler = null;
        this.button = null;
    }

    protected void reconfigureButton() {
        if (this.context != null) {
            this.configurer.configure(this.button, this.createProperties(), this.context);
        }
    }

    protected void actionPropertyChanged(PropertyChangeEvent e) {
        if ("enabled".equals(e.getPropertyName())) {
            this.updateEnablement();
        } else if ("ActionCommandKey".equals(e.getPropertyName())) {
            this.setActionCommand();
        } else if ("Visible".equals(e.getPropertyName())) {
            this.updateVisibility();
        } else {
            this.reconfigureButton();
        }
    }

    protected void addNotify() {
        this.registerListeners();
        this.reconfigureButton();
    }

    protected void removeNotify() {
        this.removeListeners();
    }

    protected void faceChanged() {
        this.reconfigureButton();
    }

    private void setActionCommand() {
        this.button.setActionCommand(this.getActionCommand());
    }

    private void updateEnablement() {
        this.button.setEnabled(this.isEnabeld() && this.context.isEnabled());
    }

    private void updateVisibility() {
        Boolean b = (Boolean)this.action.getValue("Visible");
        if (b != null) {
            this.button.setVisible(b);
        }
    }

    private void displayPropertyChanged(PropertyChangeEvent e) {
        this.reconfigureButton();
    }

    static class DisplayPropertiesHandler
    extends WeakPropertyChangeListener {
        private static final long serialVersionUID = 376245920711576285L;

        public DisplayPropertiesHandler(Object target, Object source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent e) {
            ((ButtonBinding)target).displayPropertyChanged(e);
        }
    }

    static class FaceHandler
    extends WeakPropertyChangeListener {
        private static final long serialVersionUID = 1L;

        public FaceHandler(ButtonBinding target, ActionProperties source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            ((ButtonBinding)target).faceChanged();
        }
    }

    static class ActionHandler
    extends ActionPropertyChangeListener {
        private static final long serialVersionUID = 5145742076948669839L;

        public ActionHandler(Object target, Action action) {
            super(target, action);
        }

        @Override
        protected void actionPropertyChanged(Object target, Action action, PropertyChangeEvent e) {
            if (!((ButtonBinding)target).isDisposed()) {
                ((ButtonBinding)target).actionPropertyChanged(e);
            }
        }
    }
}

