/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.binding;

import chemaxon.marvin.uif.action.ActionProperties;
import chemaxon.marvin.uif.action.support.AbstractExtendedAction;
import chemaxon.marvin.uif.controller.impl.binding.ButtonBinding;
import chemaxon.marvin.uif.controller.impl.binding.ConfigurationContext;
import chemaxon.marvin.uif.controller.impl.binding.Configurer;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.util.listener.WeakItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;

class ToggleButtonBinding
extends ButtonBinding {
    private ItemListener itemChangeListener;

    public ToggleButtonBinding(AbstractButton button, Action action, ActionProperties face, DisplayProperties properties, Configurer configurer) {
        this(button, action, face, properties, configurer, null);
    }

    public ToggleButtonBinding(AbstractButton button, Action action, ActionProperties face, DisplayProperties properties, Configurer configurer, ConfigurationContext initialContext) {
        super(button, action, face, properties, configurer, initialContext);
        this.init();
    }

    private void init() {
        this.updateButtonSelection();
        this.itemChangeListener = new ItemChangeHandler(this, (Object)this.getButton());
        this.getButton().addItemListener(this.itemChangeListener);
    }

    @Override
    public void release() {
        if (this.itemChangeListener != null && this.getButton() != null) {
            this.getButton().removeItemListener(this.itemChangeListener);
            this.itemChangeListener = null;
        }
        super.release();
    }

    @Override
    protected void actionPropertyChanged(PropertyChangeEvent e) {
        if (AbstractExtendedAction.getSelectionKey(this.getAction()).equals(e.getPropertyName())) {
            this.updateButtonSelection();
        } else {
            super.actionPropertyChanged(e);
        }
    }

    @Override
    protected void reconfigureButton() {
        super.reconfigureButton();
        this.updateButtonSelection();
    }

    private void updateButtonSelection() {
        boolean selected = AbstractExtendedAction.isSelected(this.getAction());
        if (selected != this.getButton().isSelected()) {
            this.getButton().setSelected(selected);
        }
    }

    private void updateActionSelection() {
        if (AbstractExtendedAction.isToggleAction(this.getAction()) && !AbstractExtendedAction.isSwingStyleToggleAction(this.getAction())) {
            this.updateButtonSelection();
            return;
        }
        if (this.getButton().isSelected() != AbstractExtendedAction.isSelected(this.getAction())) {
            AbstractExtendedAction.setSelected(this.getAction(), this.getButton().isSelected());
        }
    }

    private static class ItemChangeHandler
    extends WeakItemListener {
        private static final long serialVersionUID = -6833491124336885257L;

        public ItemChangeHandler(ToggleButtonBinding target, Object source) {
            super(target, source);
        }

        @Override
        protected void itemStateChanged(Object target, Object source, ItemEvent evt) {
            ((ToggleButtonBinding)target).updateActionSelection();
        }
    }
}

