/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.impl.item;

import chemaxon.marvin.uif.action.ActionGroup;
import chemaxon.marvin.uif.controller.impl.binding.BindingProvider;
import chemaxon.marvin.uif.controller.impl.item.AbstractToolBarItemController;
import chemaxon.marvin.uif.controller.impl.item.ItemFactory;
import chemaxon.marvin.uif.controller.support.MenuItemController;
import chemaxon.marvin.uif.util.listener.ActionPropertyChangeListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ActionGroupToolbarController
extends AbstractToolBarItemController {
    private ActionGroup group;
    private ItemFactory factory;
    private JPopupMenu popup;
    private PropertyChangeListener listener;
    private MenuItemController[] controllers;

    public ActionGroupToolbarController(BindingProvider bindingProvider, ActionGroup group, ItemFactory factory) {
        super(bindingProvider);
        this.group = group;
        this.factory = factory;
        this.listener = new DefaultActionHandler(this, (Action)group);
        group.addPropertyChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        this.group.removePropertyChangeListener(this.listener);
        if (this.hasComponent()) {
            this.popup = null;
            this.disposeControllers();
        }
        super.dispose();
    }

    private void disposeControllers() {
        if (this.controllers == null) {
            return;
        }
        for (int i = 0; i < this.controllers.length; ++i) {
            this.controllers[i].dispose();
        }
        this.controllers = null;
    }

    private Action getDefaultAction() {
        return this.group.getDefaultAction() != null ? this.group.getDefaultAction() : this.group;
    }

    private void defaultChanged() {
        if (this.hasComponent()) {
            this.getProvider().release(this.getComponent());
        }
        this.setProvider(this.factory.createProvider(this.getDefaultAction()));
        if (this.hasComponent()) {
            this.getProvider().bind((JToggleButton)this.getComponent());
        }
    }

    private void fill() {
        this.ensureHasControllers();
        for (int j = 0; j < this.controllers.length; ++j) {
            this.controllers[j].fill(this.popup);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.controllers == null) {
            return;
        }
        for (int i = 0; i < this.controllers.length; ++i) {
            this.controllers[i].updateUI();
        }
    }

    @Override
    protected JComponent createAndBindItem() {
        final JToggleButton button = this.getButtonFactory().createSplitToggleButton(null);
        button.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (button.getClientProperty("dropDownMenu") != null) {
                    return;
                }
                ActionGroupToolbarController.this.popup = ActionGroupToolbarController.this.getMenuFactory().createPopupMenu();
                ActionGroupToolbarController.this.popup.addPopupMenuListener(new PopupHandler());
                button.putClientProperty("dropDownMenu", ActionGroupToolbarController.this.popup);
                button.removeComponentListener(this);
            }
        });
        this.getProvider().bind(button);
        return button;
    }

    private void ensureHasControllers() {
        if (this.controllers == null) {
            this.controllers = this.createControllers();
        }
    }

    private MenuItemController[] createControllers() {
        Action[] actions = this.group.getActions();
        MenuItemController[] result = new MenuItemController[actions.length];
        for (int i = 0; i < actions.length; ++i) {
            result[i] = this.factory.createController(actions[i], "toolpopup");
        }
        return result;
    }

    private class PopupHandler
    implements PopupMenuListener {
        private PopupHandler() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            ActionGroupToolbarController.this.popup.removeAll();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            ActionGroupToolbarController.this.popup.removeAll();
            ActionGroupToolbarController.this.fill();
            ActionGroupToolbarController.this.popup.invalidate();
            ActionGroupToolbarController.this.popup.repaint();
        }
    }

    private static class DefaultActionHandler
    extends ActionPropertyChangeListener {
        public DefaultActionHandler(ActionGroupToolbarController controller, Action action) {
            super((Object)controller, action);
        }

        @Override
        protected void actionPropertyChanged(Object target, Action action, PropertyChangeEvent e) {
            if ("defaultAction".equals(e.getPropertyName())) {
                ((ActionGroupToolbarController)target).defaultChanged();
            } else if ("actions".equals(e.getPropertyName())) {
                ((ActionGroupToolbarController)target).disposeControllers();
            }
        }
    }
}

