/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.controller.support;

import chemaxon.marvin.uif.controller.support.FactoryListener;
import chemaxon.marvin.uif.controller.support.ItemController;
import chemaxon.marvin.uif.controller.support.ItemControllerFactory;
import chemaxon.marvin.uif.controller.support.MenuItemController;
import chemaxon.marvin.uif.controller.support.ToolBarItemController;
import chemaxon.marvin.uif.model.GroupEvent;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ItemGroupListener;
import chemaxon.marvin.uif.util.listener.AbstractWeakListener;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;

public abstract class AbstractGroupController<T extends ItemController, E extends JComponent> {
    private ItemControllerFactory factory;
    private ItemGroup group;
    private Map<Item, T> controllerCache;
    private Map<Item, PropertyChangeListener> visibilityListeners;
    private ItemGroupListener groupHandler;
    private FactoryHandler factoryHandler;
    private E container;

    public AbstractGroupController(ItemGroup group, ItemControllerFactory factory) {
        this.factory = factory;
        this.group = group;
        this.controllerCache = new WeakHashMap<Item, T>();
        this.visibilityListeners = new WeakHashMap<Item, PropertyChangeListener>(5);
        this.initListeners();
        this.registerListeners();
    }

    public AbstractGroupController(ItemGroup group) {
        this(group, null);
    }

    public ItemControllerFactory getFactory() {
        return this.factory;
    }

    private void initListeners() {
        this.groupHandler = new GroupChangeHandler(this, this.group);
        this.factoryHandler = new FactoryHandler(this, this.factory);
    }

    private void registerListeners() {
        this.group.addItemGroupListener(this.groupHandler);
        if (this.factory != null) {
            this.factory.addFactoryListener(this.factoryHandler);
        }
        for (int i = 0; i < this.group.getItemCount(); ++i) {
            this.registerListener(this.group.getItem(i));
        }
    }

    private void registerListener(Item command) {
        this.removeListener(command);
        VisibilityHandler visibilityHandler = new VisibilityHandler(this, command);
        this.visibilityListeners.put(command, visibilityHandler);
        command.addPropertyChangeListener(visibilityHandler);
    }

    private void removeListeners() {
        this.group.removeItemGroupListener(this.groupHandler);
        if (this.factory != null) {
            this.factory.removeFactoryListener(this.factoryHandler);
        }
        for (int i = 0; i < this.group.getItemCount(); ++i) {
            this.removeListener(this.group.getItem(i));
        }
    }

    private void removeListener(Item command) {
        if (this.visibilityListeners.containsKey(command)) {
            PropertyChangeListener visibilityHandler = this.visibilityListeners.remove(command);
            command.removePropertyChangeListener(visibilityHandler);
        }
    }

    private void disposeImpl() {
        this.removeListeners();
        this.groupHandler = null;
        this.factoryHandler = null;
        this.group = null;
        this.factory = null;
        if (this.container != null) {
            this.container = null;
        }
    }

    private void disposeChilds() {
        for (int i = 0; i < this.group.getItemCount(); ++i) {
            this.removeFromCache(this.group.getItem(i));
        }
    }

    protected void dispose() {
        this.disposeChilds();
        this.disposeImpl();
    }

    protected ItemGroup getGroup() {
        return this.group;
    }

    public final boolean hasComponent() {
        return this.container != null;
    }

    protected final E getContainer() {
        if (!this.hasComponent()) {
            this.container = this.createContainer();
            this.initContainer(this.container);
            this.contentChanged();
        }
        return this.container;
    }

    protected abstract E createContainer();

    protected void initContainer(E container) {
    }

    protected T getCachedController(Item command) {
        return (T)((ItemController)this.controllerCache.get(command));
    }

    protected void removeFromCache(Item command) {
        ItemController controller;
        if (this.controllerCache.containsKey(command) && (controller = (ItemController)this.controllerCache.remove(command)) != null) {
            controller.dispose();
        }
    }

    protected void controllerChanged(String itemID) {
        if (itemID == null) {
            return;
        }
        if (this.group.getItem(itemID) == null) {
            return;
        }
        for (int i = 0; i < this.group.getItemCount(); ++i) {
            if (!itemID.equals(this.group.getItem(i).getID())) continue;
            this.removeFromCache(this.group.getItem(i));
        }
        this.contentChanged();
    }

    protected abstract T createController(Item var1);

    protected final MenuItemController createMenuController(Item command) {
        return this.factory.createMenuController(command);
    }

    protected final ToolBarItemController createToolBarControler(Item command) {
        return this.factory.createToolBarController(command);
    }

    protected T getController(Item command) {
        T result = this.getCachedController(command);
        if (result == null) {
            result = this.createController(command);
            this.controllerCache.put(command, result);
        }
        return result;
    }

    public void updateUI() {
        for (int i = 0; i < this.getGroup().getItemCount(); ++i) {
            Item item = this.getGroup().getItem(i);
            T controller = this.getCachedController(item);
            if (controller == null) continue;
            controller.updateUI();
        }
    }

    protected List<T> getNormalizedControllerList() {
        ArrayList<T> result = new ArrayList<T>(this.group.getItemCount());
        for (int i = 0; i < this.group.getItemCount(); ++i) {
            Item command = this.group.getItem(i);
            if (!command.isVisible() || this.getController(command) == null) continue;
            result.add(this.getController(command));
        }
        return result;
    }

    protected boolean hasVisibleDynamicItem() {
        for (int i = 0; i < this.group.getItemCount(); ++i) {
            T controller = this.getCachedController(this.group.getItem(i));
            if (!this.group.getItem(i).isVisible() || controller == null || !controller.isDynamic()) continue;
            return true;
        }
        return false;
    }

    protected void contentChanged() {
        this.contentChangedImpl();
    }

    protected final void contentChangedImpl() {
        if (!this.hasComponent()) {
            return;
        }
        ((Container)this.getContainer()).removeAll();
        for (ItemController controller : this.getNormalizedControllerList()) {
            this.fillContainer(controller);
        }
        ((JComponent)this.getContainer()).revalidate();
        ((Component)this.getContainer()).repaint();
    }

    protected abstract void fillContainer(T var1);

    private void handleVisibilityChange() {
        this.contentChanged();
    }

    private void disposeChild(Item command) {
        this.removeListener(command);
        this.removeFromCache(command);
    }

    private void handleAdd(Item command) {
        this.registerListener(command);
        if (command.isVisible()) {
            this.contentChanged();
        }
    }

    private void handleRemove(Item command) {
        this.disposeChild(command);
        if (command.isVisible()) {
            this.contentChanged();
        }
    }

    private void handleMove() {
        this.contentChanged();
    }

    private static class FactoryHandler
    extends AbstractWeakListener
    implements FactoryListener {
        public FactoryHandler(Object target, Object source) {
            super(target, source, FactoryListener.class);
        }

        @Override
        public void controllerChanged(String itemID) {
            AbstractGroupController target = (AbstractGroupController)this.getTarget();
            if (target != null) {
                target.controllerChanged(itemID);
            }
        }
    }

    private static class VisibilityHandler
    extends WeakPropertyChangeListener {
        public VisibilityHandler(AbstractGroupController<?, ?> target, Item source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                ((AbstractGroupController)target).handleVisibilityChange();
            }
        }
    }

    private static class GroupChangeHandler
    extends AbstractWeakListener
    implements ItemGroupListener {
        public GroupChangeHandler(AbstractGroupController<?, ?> target, ItemGroup source) {
            super(target, source, ItemGroupListener.class);
        }

        @Override
        public void itemAdded(GroupEvent e) {
            AbstractGroupController target = (AbstractGroupController)this.getTarget();
            if (target != null) {
                target.handleAdd(e.getChild());
            }
        }

        @Override
        public void itemRemoved(GroupEvent e) {
            AbstractGroupController target = (AbstractGroupController)this.getTarget();
            if (target != null) {
                target.handleRemove(e.getChild());
            }
        }

        @Override
        public void itemMoved(GroupEvent e) {
            AbstractGroupController target = (AbstractGroupController)this.getTarget();
            if (target != null) {
                target.handleMove();
            }
        }
    }
}

