/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.dialog.model.DialogProvider;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.marvin.uif.module.ModuleConfiguration;
import chemaxon.marvin.uif.util.Utils;
import chemaxon.marvin.uif.util.swing.ExceptionDialog;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ConfigurationModel {
    private static final String EXPORT_NAME = "export.name";
    private static final String IMPORT_NAME = "import.name";
    private static final String EDIT_NAME = "edit.name";
    private static final String COPY_NAME = "copy.name";
    private static final String DELETE_NAME = "delete.name";
    private static final String RESET_NAME = "reset.name";
    private static final String RENAME_NAME = "rename.name";
    private static final String NAME_DIALOG_MESSAGE = "nameDialog.message";
    private static final String MAKE_DEFAULT_NAME = "makeDefault.name";
    private static final String CUSTOM_REGISTRY_PREFIX = "custom-";
    private ResourceBundle bundle;
    private DefaultListModel listModel;
    private ListSelectionModel configurationSelection;
    private GUIModule module;
    private ModuleConfiguration configuration;
    private JComponent component;
    private Action makeDefaultAction;
    private Action editAction;
    private Action renameAction;
    private Action deleteAction;
    private Action copyAction;
    private Action importAction;
    private Action exportAction;
    private MouseListener doubleClickHandler;
    private DialogProvider customizeDialog;

    public ConfigurationModel(GUIModule module, DialogProvider customizeDialog) {
        this.configuration = module.getModuleConfiguration();
        this.customizeDialog = customizeDialog;
        this.module = module;
        this.bundle = ResourceBundle.getBundle(ConfigurationModel.class.getName());
        this.initModels();
        this.initActions();
    }

    private void initModels() {
        this.listModel = this.createConfigurationList();
        this.configurationSelection = this.createSelectionModel();
    }

    private void initActions() {
        this.makeDefaultAction = new ActivateAction();
        this.renameAction = new RenameAction();
        this.copyAction = new CopyAction();
        this.doubleClickHandler = new DoubleClickHandler();
        this.deleteAction = new DeleteOrResetAction();
        this.editAction = new EditAction();
        this.exportAction = new ExportAction();
        this.importAction = new ImportAction();
    }

    private DefaultListModel createConfigurationList() {
        DefaultListModel<GUIRegistry> result = new DefaultListModel<GUIRegistry>();
        String[] ids = this.configuration.getRegistryIDs();
        for (int i = 0; i < ids.length; ++i) {
            result.addElement(this.configuration.getRegistry(ids[i]));
        }
        return result;
    }

    private ListSelectionModel createSelectionModel() {
        DefaultListSelectionModel result = new DefaultListSelectionModel();
        result.setSelectionMode(0);
        result.setSelectionInterval(this.getActiveItemIndex(), this.getActiveItemIndex());
        return result;
    }

    public ListModel getConfigurations() {
        return this.listModel;
    }

    public ListSelectionModel getConfigurationSelection() {
        return this.configurationSelection;
    }

    public int getActiveItemIndex() {
        return this.listModel.indexOf(this.configuration.getActiveRegistry());
    }

    public Action getActivateAction() {
        return this.makeDefaultAction;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getEditAction() {
        return this.editAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getRenameAction() {
        return this.renameAction;
    }

    public Action getImportAction() {
        return this.importAction;
    }

    public Action getExportAction() {
        return this.exportAction;
    }

    public MouseListener getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public void setComponent(JComponent component) {
        this.component = component;
    }

    private GUIRegistry getSelectedRegistry() {
        if (!this.hasSelection()) {
            return null;
        }
        return (GUIRegistry)this.getConfigurations().getElementAt(this.getSelectedIndex());
    }

    private String getSelectedRegistryID() {
        if (!this.hasSelection()) {
            return null;
        }
        return this.getSelectedRegistry().getID();
    }

    private int getSelectedIndex() {
        return this.getConfigurationSelection().getMinSelectionIndex();
    }

    private boolean hasSelection() {
        return !this.getConfigurationSelection().isSelectionEmpty();
    }

    private void doMakeActive() {
        this.configuration.setActive(this.getSelectedRegistry().getID());
        this.listModel.set(this.getSelectedIndex(), this.getSelectedRegistry());
    }

    private void doRename() {
        String name = JOptionPane.showInputDialog(this.component, (Object)this.bundle.getString(NAME_DIALOG_MESSAGE));
        if (name == null || name.equals("")) {
            return;
        }
        this.getSelectedRegistry().setDisplayName(name);
        this.listModel.set(this.getSelectedIndex(), this.getSelectedRegistry());
    }

    private void doCopy() {
        String name = JOptionPane.showInputDialog(this.component, (Object)this.bundle.getString(NAME_DIALOG_MESSAGE));
        if (name == null || name.equals("")) {
            return;
        }
        String parentID = this.getSelectedRegistry().getID();
        GUIRegistry registry = (GUIRegistry)this.configuration.getRegistry(parentID).clone();
        registry.setID(Utils.createUniqueID(CUSTOM_REGISTRY_PREFIX, Arrays.asList(this.configuration.getRegistryIDs())));
        registry.setParentID(parentID);
        registry.setDisplayName(name);
        this.configuration.addRegistry(registry, false);
        this.addToModel(registry);
        this.doMakeActive();
    }

    private void addToModel(GUIRegistry registry) {
        this.listModel.addElement(registry);
        this.configurationSelection.setSelectionInterval(this.listModel.getSize() - 1, this.listModel.getSize() - 1);
    }

    private void doDelete() {
        String id = this.getSelectedRegistryID();
        if (this.configuration.getRegistryDefaults(id) != null) {
            return;
        }
        int index = Math.max(this.getSelectedIndex() - 1, 0);
        this.configuration.removeRegistry(id);
        this.listModel.removeRange(this.getSelectedIndex(), this.getSelectedIndex());
        this.configurationSelection.setSelectionInterval(index, index);
        if (this.configuration.getActive() == null) {
            this.doMakeActive();
        } else {
            this.listModel.set(this.getSelectedIndex(), this.getSelectedRegistry());
        }
    }

    private void doReset() {
        this.configuration.resetRegistry(this.getSelectedRegistryID());
        this.listModel.set(this.getSelectedIndex(), this.configuration.getRegistry(this.getSelectedRegistryID()));
    }

    private void doEdit() {
        if (this.canActivate()) {
            this.doMakeActive();
        }
        this.customizeDialog.create(SwingUtilities.getWindowAncestor(this.component), this.module).open();
    }

    private void doExport() {
        int confirm;
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter defaultFilter = this.createFilter("filter");
        FileNameExtensionFilter serFilter = this.createFilter("serFilter");
        chooser.addChoosableFileFilter(defaultFilter);
        chooser.addChoosableFileFilter(serFilter);
        chooser.setFileFilter(defaultFilter);
        int choice = chooser.showSaveDialog(this.component);
        if (choice != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file.exists() && (confirm = JOptionPane.showConfirmDialog(this.component, MessageFormat.format(this.bundle.getString("overwrite.message"), file.getName()), this.bundle.getString("overwrite.title"), 0)) != 0) {
            return;
        }
        if (file.getName().split("\\.").length == 1 && chooser.getFileFilter() instanceof FileNameExtensionFilter) {
            file = new File(file.getPath() + "." + ((FileNameExtensionFilter)chooser.getFileFilter()).getExtensions()[0]);
        }
        try {
            this.module.getModuleConfiguration().exportConfiguration(new FileOutputStream(file), this.getSelectedRegistryID(), chooser.getFileFilter() == serFilter);
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.component, e.getMessage(), "Error", 0);
            e.printStackTrace();
        }
    }

    private void doImport() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter defaultFilter = this.createFilter("filter");
        FileNameExtensionFilter serFilter = this.createFilter("serFilter");
        chooser.addChoosableFileFilter(defaultFilter);
        chooser.addChoosableFileFilter(serFilter);
        chooser.setFileFilter(defaultFilter);
        int choice = chooser.showOpenDialog(this.component);
        if (choice != 0) {
            return;
        }
        if (!chooser.getSelectedFile().exists()) {
            return;
        }
        try {
            String id = this.module.getModuleConfiguration().importConfiguration(new FileInputStream(chooser.getSelectedFile()), chooser.getFileFilter() == serFilter);
            if (id != null) {
                this.addToModel(this.module.getModuleConfiguration().getRegistry(id));
            } else {
                JOptionPane.showMessageDialog(this.component, "Import failed. Not a valid configuration.", "Error", 0);
            }
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
        }
        catch (IOException e) {
            this.handleError(e);
        }
    }

    private void handleError(Throwable e) {
        ExceptionDialog.showErrorDialog(SwingUtilities.getWindowAncestor(this.component), "Error", e);
    }

    private FileNameExtensionFilter createFilter(String id) {
        return new FileNameExtensionFilter(this.bundle.getString(id + ".name"), this.bundle.getString(id + ".ext"));
    }

    private boolean canActivate() {
        return !this.configurationSelection.isSelectionEmpty() && this.getSelectedRegistry() != this.configuration.getActiveRegistry();
    }

    private class DoubleClickHandler
    extends MouseAdapter {
        private DoubleClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && ConfigurationModel.this.canActivate()) {
                ConfigurationModel.this.doMakeActive();
            }
        }
    }

    private class EditAction
    extends BaseAction {
        private EditAction() {
            super(ConfigurationModel.this.bundle.getString(ConfigurationModel.EDIT_NAME));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationModel.this.doEdit();
        }
    }

    private class ImportAction
    extends AbstractAction {
        private ImportAction() {
            super(ConfigurationModel.this.bundle.getString(ConfigurationModel.IMPORT_NAME));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationModel.this.doImport();
        }
    }

    private class ExportAction
    extends BaseAction {
        private ExportAction() {
            super(ConfigurationModel.this.bundle.getString(ConfigurationModel.EXPORT_NAME));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationModel.this.doExport();
        }
    }

    private class DeleteOrResetAction
    extends BaseAction {
        private DeleteOrResetAction() {
            super(ConfigurationModel.this.bundle.getString(ConfigurationModel.DELETE_NAME));
            this.update();
        }

        private boolean canReset() {
            return ConfigurationModel.this.configuration.getRegistryDefaults(ConfigurationModel.this.getSelectedRegistryID()) != null;
        }

        @Override
        protected void update() {
            this.setEnabled(ConfigurationModel.this.hasSelection());
            if (this.isEnabled()) {
                String name = this.canReset() ? ConfigurationModel.this.bundle.getString(ConfigurationModel.RESET_NAME) : ConfigurationModel.this.bundle.getString(ConfigurationModel.DELETE_NAME);
                this.putValue("Name", name);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.canReset()) {
                ConfigurationModel.this.doReset();
            } else {
                ConfigurationModel.this.doDelete();
            }
        }
    }

    private class CopyAction
    extends BaseAction {
        private CopyAction() {
            super(ConfigurationModel.this.bundle.getString(ConfigurationModel.COPY_NAME));
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationModel.this.doCopy();
        }
    }

    private class RenameAction
    extends BaseAction {
        private RenameAction() {
            super(ConfigurationModel.this.bundle.getString(ConfigurationModel.RENAME_NAME));
            this.update();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationModel.this.doRename();
        }
    }

    private class ActivateAction
    extends BaseAction
    implements ListDataListener {
        private ActivateAction() {
            super(ConfigurationModel.this.bundle.getString(ConfigurationModel.MAKE_DEFAULT_NAME));
            ConfigurationModel.this.listModel.addListDataListener(this);
            this.update();
        }

        @Override
        protected void update() {
            this.setEnabled(ConfigurationModel.this.canActivate());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigurationModel.this.doMakeActive();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.update();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private abstract class BaseAction
    extends AbstractAction
    implements ListSelectionListener {
        protected BaseAction(String name) {
            super(name);
            ConfigurationModel.this.getConfigurationSelection().addListSelectionListener(this);
        }

        protected void update() {
            this.setEnabled(ConfigurationModel.this.hasSelection());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.update();
        }
    }
}

