/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.support.LabelInfo;
import chemaxon.marvin.uif.dialog.model.CategoriesModel;
import chemaxon.marvin.uif.dialog.model.DialogProvider;
import chemaxon.marvin.uif.dialog.model.ItemListAdapter;
import chemaxon.marvin.uif.dialog.model.OptionPanelUtils;
import chemaxon.marvin.uif.dialog.model.PropertiesHelper;
import chemaxon.marvin.uif.dialog.model.PropertiesProvider;
import chemaxon.marvin.uif.model.DefaultItemGroup;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.IDHelper;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.Separator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ItemGroupModel {
    private static final String ADD_ACTION = "add.name";
    private static final String DELETE_ACTION = "delete.name";
    private static final String RENAME_ACTION = "rename.name";
    private static final String ADD_SEPARATOR_ACTION = "addSeparator.name";
    private static final String ADD_SUBMENU_ACTION = "addSubmenu.name";
    private static final String MOVE_UP_ACTION = "moveUp.name";
    private static final String MOVE_DOWN_ACTION = "moveDown.name";
    private DialogProvider categoriesDialog;
    private Component component;
    private ResourceBundle bundle;
    private ItemGroup model;
    private ItemListAdapter groupList;
    private ListSelectionModel selectionModel;
    private PropertiesProvider helper;
    private ActionRegistry registry;
    private Action deleteAction;
    private Action addAction;
    private Action renameAction;
    private Action addSeparatorAction;
    private Action addSubMenuAction;
    private Action moveUpAction;
    private Action moveDownAction;

    public ItemGroupModel(ActionRegistry registry, DialogProvider categoriesDialog) {
        this(registry, null, categoriesDialog);
    }

    public ItemGroupModel(ActionRegistry registry, ItemGroup model, DialogProvider categoriesDialog) {
        this(registry, model, null, categoriesDialog);
    }

    public ItemGroupModel(ActionRegistry registry, ItemGroup model, Item defaultSelection, DialogProvider categoriesDialog) {
        this.model = model;
        this.registry = registry;
        this.categoriesDialog = categoriesDialog;
        this.bundle = ResourceBundle.getBundle(ItemGroupModel.class.getName());
        this.helper = new PropertiesHelper(registry);
        this.initModels();
        this.initActions();
        this.initEventHandling();
        this.setGroup(model);
        this.initSelecion(defaultSelection);
    }

    public ListModel getListModel() {
        return this.groupList;
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Action getAddAction() {
        return this.addAction;
    }

    public Action getAddSeparatorAction() {
        return this.addSeparatorAction;
    }

    public Action getAddSubMenuAction() {
        return this.addSubMenuAction;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getMoveDownAction() {
        return this.moveDownAction;
    }

    public Action getMoveUpAction() {
        return this.moveUpAction;
    }

    public Action getRenameAction() {
        return this.renameAction;
    }

    public String getDescription() {
        return this.getSelectedItem() != null ? this.helper.getProperties(this.getSelectedItem()).getDescription() : null;
    }

    public void release() {
        this.setGroup(null);
        this.component = null;
    }

    public void setGroup(ItemGroup model) {
        this.setGroup(model, null);
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    private void setGroup(ItemGroup model, Item initialSelection) {
        this.model = model;
        this.groupList.setGroup(model);
        this.updateActions();
        int selection = initialSelection != null ? model.indexOf(initialSelection) : (this.groupList.getSize() != 0 ? 0 : -1);
        this.selectionModel.setSelectionInterval(selection, selection);
    }

    private void initModels() {
        this.groupList = new ItemListAdapter(null);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
    }

    private void configure(Action action, String id) {
        LabelInfo.configure(action, this.bundle.getString(id));
    }

    private void initActions() {
        this.deleteAction = new DeleteAction();
        this.addAction = new AddAction();
        this.renameAction = new RenameAction();
        this.addSeparatorAction = new AddSeparatorAction();
        this.addSubMenuAction = new AddSubmenuAction();
        this.moveUpAction = new MoveUpAction();
        this.moveDownAction = new MoveDownAction();
        this.configure(this.deleteAction, DELETE_ACTION);
        this.configure(this.addAction, ADD_ACTION);
        this.configure(this.renameAction, RENAME_ACTION);
        this.configure(this.addSeparatorAction, ADD_SEPARATOR_ACTION);
        this.configure(this.addSubMenuAction, ADD_SUBMENU_ACTION);
        this.configure(this.moveUpAction, MOVE_UP_ACTION);
        this.configure(this.moveDownAction, MOVE_DOWN_ACTION);
    }

    private void initEventHandling() {
        this.selectionModel.addListSelectionListener(new SelectionHandler());
    }

    private boolean hasSelection() {
        return this.model != null && !this.selectionModel.isSelectionEmpty();
    }

    private boolean canMoveUp() {
        return this.hasSelection() && this.selectionModel.getMinSelectionIndex() != 0;
    }

    private boolean canMoveDown() {
        return this.hasSelection() && this.selectionModel.getMinSelectionIndex() < this.groupList.getSize() - 1;
    }

    private Item getSelectedItem() {
        if (!this.hasSelection()) {
            return null;
        }
        return (Item)this.groupList.getElementAt(this.selectionModel.getMinSelectionIndex());
    }

    private int viewToModel(int index) {
        return this.model.indexOf((Item)this.groupList.getElementAt(index));
    }

    private void initSelecion(Item defaultSelection) {
        if (defaultSelection == null) {
            return;
        }
        this.selectionModel.addSelectionInterval(this.groupList.getDelegate().indexOf(defaultSelection), this.groupList.getDelegate().indexOf(defaultSelection));
    }

    void add(Item item) {
        if (this.model.indexOf(item.getID()) != -1) {
            return;
        }
        int insertIndex = this.selectionModel.isSelectionEmpty() ? 0 : this.viewToModel(this.selectionModel.getMinSelectionIndex()) + 1;
        int selectionIndex = this.selectionModel.isSelectionEmpty() ? 0 : this.selectionModel.getMinSelectionIndex() + 1;
        this.model.add(item, insertIndex);
        if (this.model.indexOf(item) != -1) {
            this.selectionModel.setSelectionInterval(selectionIndex, selectionIndex);
        }
    }

    public PropertiesProvider getProvider() {
        return this.helper;
    }

    private void doRename() {
        String name = OptionPanelUtils.showItemRenameDialog(this.component, this.helper.getProperties(this.getSelectedItem()));
        if (name != null) {
            this.getSelectedItem().getDisplayProperties().setDisplayName(name);
        }
    }

    private void doAdd() {
        CategoriesModel model = new CategoriesModel(this, this.registry);
        this.categoriesDialog.create(SwingUtilities.getWindowAncestor(this.component), model).open();
    }

    private void doDelete() {
        int index = this.selectionModel.getMinSelectionIndex();
        this.model.remove(this.getSelectedItem());
        if (this.groupList.getSize() != 0) {
            int newIndex = Math.min(this.groupList.getSize() - 1, index);
            this.selectionModel.setSelectionInterval(newIndex, newIndex);
        }
    }

    private void doAddSeparator() {
        this.add(Separator.createSeparatorFor(this.model));
    }

    private void doMoveUp() {
        this.move(-1);
    }

    private void doMoveDown() {
        this.move(1);
    }

    public void doAddSubMenu() {
        String name = JOptionPane.showInputDialog(this.component, this.bundle.getString("addSubmenuPopup.message"), this.bundle.getString("addSubmenuPopup.title"), 3);
        if (name == null || name.trim().length() == 0) {
            return;
        }
        this.add(new DefaultItemGroup(IDHelper.createUniqueCustomMenuID(this.model), new DisplayProperties(name)));
    }

    private void move(int delta) {
        int index = this.selectionModel.getMinSelectionIndex();
        this.model.move(this.viewToModel(index), this.viewToModel(index + delta));
        this.selectionModel.setSelectionInterval(index + delta, index + delta);
    }

    private void updateActions() {
        this.deleteAction.setEnabled(this.hasSelection());
        this.addAction.setEnabled(this.model != null);
        this.addSubMenuAction.setEnabled(this.model != null);
        this.addSeparatorAction.setEnabled(this.model != null);
        this.moveUpAction.setEnabled(this.canMoveUp());
        this.moveDownAction.setEnabled(this.canMoveDown());
        this.renameAction.setEnabled(this.hasSelection() && !this.getSelectedItem().isSeparator() && this.getSelectedItem().getDisplayProperties() != null);
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ItemGroupModel.this.updateActions();
        }
    }

    private class AddSubmenuAction
    extends AbstractAction {
        private AddSubmenuAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemGroupModel.this.doAddSubMenu();
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemGroupModel.this.doMoveDown();
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemGroupModel.this.doMoveUp();
        }
    }

    private class AddSeparatorAction
    extends AbstractAction {
        private AddSeparatorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemGroupModel.this.doAddSeparator();
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemGroupModel.this.doDelete();
        }
    }

    private class RenameAction
    extends AbstractAction {
        private RenameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemGroupModel.this.doRename();
        }
    }

    private class AddAction
    extends AbstractAction {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ItemGroupModel.this.doAdd();
        }
    }
}

