/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.dialog.model.ListModelAdapter;
import chemaxon.marvin.uif.model.GroupEvent;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ItemGroupListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ComboBoxModel;

class ItemTreeAdapter
extends ListModelAdapter
implements ComboBoxModel {
    private Object selectedObject;
    private ItemGroupListener listener = new GroupChangeHandler();
    private PropertyChangeListener changeHandler = new PropertyChangeHandler();
    private ItemGroup root;

    public ItemTreeAdapter() {
        this((ItemGroup)null);
    }

    public ItemTreeAdapter(ItemGroup group) {
        this.setItems(group);
    }

    public void setItems(ItemGroup group) {
        ArrayList result = new ArrayList();
        this.collectItems(group, result);
        if (!result.contains(this.selectedObject)) {
            this.setSelectedItem(null);
        }
        this.removeListeners();
        this.root = group;
        this.setDelegate(result);
        this.registerListeners();
        if (this.getSize() == 0) {
            this.setSelectedItem(null);
        } else if (this.getSelectedItem() == null) {
            this.setSelectedItem(this.getElementAt(0));
        }
    }

    private void removeListeners() {
        if (this.root != null) {
            this.root.removeItemGroupListener(this.listener);
        }
        for (int i = 0; i < this.getSize(); ++i) {
            ((ItemGroup)this.getElementAt(i)).removeItemGroupListener(this.listener);
        }
    }

    private void registerListeners() {
        if (this.root != null) {
            this.root.addItemGroupListener(this.listener);
        }
        for (int i = 0; i < this.getSize(); ++i) {
            ((ItemGroup)this.getElementAt(i)).addItemGroupListener(this.listener);
        }
    }

    public ItemGroup getSelectedGroup() {
        return (ItemGroup)this.getSelectedItem();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        ItemGroup group = this.getSelectedGroup();
        if (group != null && group.getDisplayProperties() != null) {
            group.getDisplayProperties().addPropertyChangeListener(this.changeHandler);
        }
        this.selectedObject = anObject;
        if (this.getSelectedGroup() != null && this.getSelectedGroup().getDisplayProperties() != null) {
            this.getSelectedGroup().getDisplayProperties().addPropertyChangeListener(this.changeHandler);
        }
        this.fireContentsChanged(this, -1, -1);
    }

    private void collectItems(ItemGroup group, List result) {
        if (group == null) {
            return;
        }
        for (int i = 0; i < group.getItemCount(); ++i) {
            Item item = group.getItem(i);
            if (!(item instanceof ItemGroup)) continue;
            result.add(item);
            this.collectItems((ItemGroup)item, result);
        }
    }

    private void rebuild() {
        this.setItems(this.root);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ItemTreeAdapter.this.fireContentsChanged(ItemTreeAdapter.this, -1, -1);
        }
    }

    private class GroupChangeHandler
    implements ItemGroupListener {
        private GroupChangeHandler() {
        }

        @Override
        public void itemAdded(GroupEvent e) {
            this.check(e);
        }

        @Override
        public void itemMoved(GroupEvent e) {
            this.check(e);
        }

        @Override
        public void itemRemoved(GroupEvent e) {
            this.check(e);
        }

        private void check(GroupEvent e) {
            if (e.getChild() instanceof ItemGroup) {
                ItemTreeAdapter.this.rebuild();
            }
        }
    }
}

