/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.action.support.LabelInfo;
import chemaxon.marvin.uif.dialog.model.DialogProvider;
import chemaxon.marvin.uif.dialog.model.ItemGroupModel;
import chemaxon.marvin.uif.dialog.model.ItemTreeAdapter;
import chemaxon.marvin.uif.dialog.model.OptionPanelUtils;
import chemaxon.marvin.uif.dialog.model.PropertiesHelper;
import chemaxon.marvin.uif.dialog.model.PropertiesProvider;
import chemaxon.marvin.uif.model.DefaultItemGroup;
import chemaxon.marvin.uif.model.IDHelper;
import chemaxon.marvin.uif.model.ItemGroup;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MenuManagerModel {
    private static final String NEW_ACTION = "new.name";
    private static final String DELETE_ACTION = "delete.name";
    private static final String MOVE_ACTION = "move.name";
    private static final String RENAME_ACTION = "rename.name";
    private ResourceBundle bundle;
    private ActionRegistry registry;
    private ItemGroup rootMenu;
    private ItemTreeAdapter menuList;
    private ItemGroupModel activeMenu;
    private ListDataListener listener;
    private Component component;
    private PropertiesProvider helper;
    private DialogProvider categories;
    private DialogProvider menuMove;
    private Action newAction;
    private Action deleteAction;
    private Action moveAction;
    private Action renameAction;

    public MenuManagerModel(ActionRegistry registry, DialogProvider categories, DialogProvider menuMove) {
        this(null, registry, categories, menuMove);
    }

    public MenuManagerModel(ItemGroup rootMenu, ActionRegistry registry, DialogProvider categories, DialogProvider menuMove) {
        this.rootMenu = rootMenu;
        this.registry = registry;
        this.menuMove = menuMove;
        this.helper = new PropertiesHelper(registry);
        this.bundle = ResourceBundle.getBundle(MenuManagerModel.class.getName());
        this.categories = categories;
        this.initModels();
        this.initActions();
        this.initEventHandling();
        this.setItemGroup(rootMenu);
    }

    private void initModels() {
        this.menuList = new ItemTreeAdapter(null);
        this.activeMenu = new ItemGroupModel(this.registry, this.menuList.getSelectedGroup(), this.categories);
    }

    private void initEventHandling() {
        this.listener = new ListChangeHandler();
        this.menuList.addListDataListener(this.listener);
    }

    private void initActions() {
        this.newAction = new NewAction();
        this.deleteAction = new DeleteAction();
        this.moveAction = new MoveAction();
        this.renameAction = new RenameAction();
        LabelInfo.configure(this.newAction, this.bundle.getString(NEW_ACTION));
        LabelInfo.configure(this.deleteAction, this.bundle.getString(DELETE_ACTION));
        LabelInfo.configure(this.moveAction, this.bundle.getString(MOVE_ACTION));
        LabelInfo.configure(this.renameAction, this.bundle.getString(RENAME_ACTION));
        this.updateActions();
    }

    private void updateActions() {
        this.newAction.setEnabled(this.rootMenu != null);
        this.deleteAction.setEnabled(this.hasSelectedGroup());
        this.renameAction.setEnabled(this.hasSelectedGroup());
        this.moveAction.setEnabled(this.canMove());
    }

    private boolean hasSelectedGroup() {
        return this.menuList.getSelectedItem() != null;
    }

    private boolean canMove() {
        return this.hasSelectedGroup() && this.menuList.getSelectedGroup().getParent() == this.rootMenu;
    }

    public void release() {
        this.menuList.setItems(null);
        this.activeMenu.setGroup(null);
    }

    private void doNew() {
        String name = OptionPanelUtils.showAddMenuDialog(this.component);
        if (name == null) {
            return;
        }
        DefaultItemGroup newGroup = new DefaultItemGroup(IDHelper.createUniqueCustomMenuID(this.rootMenu));
        newGroup.getDisplayProperties().setDisplayName(name);
        this.rootMenu.add(newGroup);
        this.menuList.setSelectedItem(newGroup);
    }

    private void doDelete() {
        int selectedIndex = this.menuList.getDelegate().indexOf(this.menuList.getSelectedGroup());
        ItemGroup deletedItem = this.menuList.getSelectedGroup();
        this.menuList.setSelectedItem(null);
        deletedItem.getParent().remove(deletedItem);
        if (this.menuList.getSize() != 0) {
            int newSelection = Math.max(selectedIndex - 1, 0);
            this.menuList.setSelectedItem(this.menuList.getElementAt(newSelection));
        }
    }

    private void doMove() {
        this.menuMove.create(SwingUtilities.getWindowAncestor(this.component), new ItemGroupModel(this.registry, this.rootMenu, this.menuList.getSelectedGroup(), this.categories)).open();
    }

    private void doRename() {
        String name = OptionPanelUtils.showMenuRenameDialog(this.component, this.helper.getProperties(this.menuList.getSelectedGroup()));
        if (name != null) {
            this.menuList.getSelectedGroup().getDisplayProperties().setDisplayName(name);
        }
    }

    private void handleListSelectionChange() {
        this.updateActions();
        this.activeMenu.setGroup((ItemGroup)this.menuList.getSelectedItem());
    }

    public final void setItemGroup(ItemGroup menu) {
        this.rootMenu = menu;
        this.menuList.setItems(this.rootMenu);
    }

    public Action getNewAction() {
        return this.newAction;
    }

    public Action getDeleteAction() {
        return this.deleteAction;
    }

    public Action getMoveAction() {
        return this.moveAction;
    }

    public Action getRenameAction() {
        return this.renameAction;
    }

    public void setComponent(Component component) {
        this.component = component;
        this.activeMenu.setComponent(component);
    }

    public ItemGroupModel getSelectedMenuModel() {
        return this.activeMenu;
    }

    public ComboBoxModel getMenuSelector() {
        return this.menuList;
    }

    public PropertiesProvider getProvider() {
        return this.helper;
    }

    private class ListChangeHandler
    implements ListDataListener {
        private ListChangeHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            MenuManagerModel.this.handleListSelectionChange();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private class RenameAction
    extends AbstractAction {
        private RenameAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuManagerModel.this.doRename();
        }
    }

    private class MoveAction
    extends AbstractAction {
        private MoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuManagerModel.this.doMove();
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuManagerModel.this.doDelete();
        }
    }

    private class NewAction
    extends AbstractAction {
        private NewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuManagerModel.this.doNew();
        }
    }
}

