/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.uif.dialog.model;

import chemaxon.marvin.uif.action.ActionRegistry;
import chemaxon.marvin.uif.dialog.model.DialogProvider;
import chemaxon.marvin.uif.dialog.model.ItemGroupModel;
import chemaxon.marvin.uif.dialog.model.ItemTreeAdapter;
import chemaxon.marvin.uif.model.DisplayProperties;
import chemaxon.marvin.uif.model.GUIRegistry;
import chemaxon.marvin.uif.model.Item;
import chemaxon.marvin.uif.model.ItemGroup;
import chemaxon.marvin.uif.model.ItemGroupListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class PopupManagerModel {
    private GUIRegistry guiRegistry;
    private ItemGroupModel selectedMenu;
    private ActionRegistry actionRegistry;
    private ComboBoxModel popupSelector;

    public PopupManagerModel(GUIRegistry guiRegistry, ActionRegistry actionRegistry, DialogProvider categories) {
        this.guiRegistry = guiRegistry;
        this.actionRegistry = actionRegistry;
        this.initModels(categories);
        this.initEventHandling();
    }

    private ItemGroup getSelectedPopup() {
        return (ItemGroup)this.popupSelector.getSelectedItem();
    }

    private void initEventHandling() {
        this.popupSelector.addListDataListener(new PopupSelectionHandler());
    }

    private void initModels(DialogProvider categories) {
        this.selectedMenu = new ItemGroupModel(this.actionRegistry, categories);
        this.popupSelector = new ItemTreeAdapter(new GroupAdapter(this.collectPopups()));
        this.updateSelection();
    }

    private Item[] collectPopups() {
        ArrayList<ItemGroup> result = new ArrayList<ItemGroup>();
        String[] ids = this.guiRegistry.getPopupIDs();
        for (int i = 0; i < ids.length; ++i) {
            result.add(this.guiRegistry.getPopup(ids[i]));
        }
        return result.toArray(new Item[result.size()]);
    }

    private void updateSelection() {
        this.selectedMenu.setGroup(this.getSelectedPopup());
    }

    public ComboBoxModel getPopupSelector() {
        return this.popupSelector;
    }

    public ItemGroupModel getMenuModel() {
        return this.selectedMenu;
    }

    public void release() {
        this.selectedMenu.release();
    }

    private static class GroupAdapter
    implements ItemGroup {
        private List groups;

        public GroupAdapter(Item[] groups) {
            this.groups = Arrays.asList(groups);
        }

        @Override
        public void add(Item command) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Item command, int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAfter(String id, Item command) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addBefore(String id, Item command) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addItemGroupListener(ItemGroupListener listener) {
        }

        @Override
        public Item getItem(int index) {
            return (Item)this.groups.get(index);
        }

        @Override
        public Item getItem(String id) {
            if (id == null) {
                return null;
            }
            int index = this.indexOf(id);
            if (index != -1) {
                return (Item)this.groups.get(index);
            }
            return null;
        }

        @Override
        public int getItemCount() {
            return this.groups.size();
        }

        @Override
        public int indexOf(Item command) {
            return this.groups.indexOf(command);
        }

        @Override
        public int indexOf(String id) {
            if (id == null) {
                return -1;
            }
            for (int i = 0; i < this.groups.size(); ++i) {
                Item item = (Item)this.groups.get(i);
                if (!id.equals(item.getID())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void move(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(Item command) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(String id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAll() {
        }

        @Override
        public void removeItemGroupListener(ItemGroupListener listener) {
        }

        @Override
        public DisplayProperties getDisplayProperties() {
            return null;
        }

        @Override
        public String getID() {
            return null;
        }

        @Override
        public ItemGroup getParent() {
            return null;
        }

        @Override
        public boolean isSeparator() {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void setParent(ItemGroup parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setVisible(boolean visible) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public Item clone() {
            try {
                return (Item)super.clone();
            }
            catch (CloneNotSupportedException ignored) {
                return null;
            }
        }
    }

    private class PopupSelectionHandler
    implements ListDataListener {
        private PopupSelectionHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            PopupManagerModel.this.updateSelection();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }
}

